/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public final class MatchResultImpl
extends MatchResult {
    private String name;
    private SmartPsiPointer matchRef;
    private int start;
    private int end = -1;
    private String matchImage;
    private List<MatchResult> matches;
    private boolean target;
    private boolean myScopeMatch;
    private boolean myMultipleMatch;
    @NonNls
    private static final String NULL = "null";
    private MatchResultImpl myContext;

    MatchResultImpl() {
    }

    public MatchResultImpl(String name, String image, SmartPsiPointer ref, boolean target) {
        this(name, image, ref, 0, -1, target);
    }

    public MatchResultImpl(String name, String image, SmartPsiPointer ref, int start, int end, boolean target) {
        this.matchRef = ref;
        this.name = name;
        this.matchImage = image;
        this.target = target;
        this.start = start;
        this.end = end;
    }

    @Override
    public String getMatchImage() {
        if (this.matchImage == null) {
            this.matchImage = NULL;
        }
        return this.matchImage;
    }

    public void setParent(MatchResult parent) {
    }

    @Override
    public SmartPsiPointer getMatchRef() {
        return this.matchRef;
    }

    @Override
    public PsiElement getMatch() {
        return this.matchRef.getElement();
    }

    public void setMatchRef(SmartPsiPointer matchStart) {
        this.matchRef = matchStart;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<MatchResult> getMatches() {
        if (this.matches == null) {
            this.matches = new ArrayList<MatchResult>();
        }
        return this.matches;
    }

    @Override
    public List<MatchResult> getAllSons() {
        return this.getMatches();
    }

    @Override
    public boolean hasSons() {
        return this.matches != null;
    }

    @Override
    public boolean isScopeMatch() {
        return this.myScopeMatch;
    }

    @Override
    public boolean isMultipleMatch() {
        return this.myMultipleMatch;
    }

    public void clear() {
        if (this.matchRef != null) {
            this.matchRef.clear();
            this.matchRef = null;
        }
        if (this.matches != null) {
            for (MatchResult match : this.matches) {
                ((MatchResultImpl)match).clear();
            }
            this.matches = null;
        }
        this.name = null;
        this.matchImage = null;
    }

    public void clearMatches() {
        this.matches = null;
    }

    public void setScopeMatch(boolean scopeMatch) {
        this.myScopeMatch = scopeMatch;
    }

    public void setMultipleMatch(boolean multipleMatch) {
        this.myMultipleMatch = multipleMatch;
    }

    public MatchResultImpl findSon(String name) {
        if (this.matches != null) {
            for (MatchResult match : this.matches) {
                MatchResultImpl res = (MatchResultImpl)match;
                if (!name.equals(res.getName())) continue;
                return res;
            }
        }
        return null;
    }

    public MatchResultImpl removeSon(String typedVar) {
        if (this.matches == null) {
            return null;
        }
        Iterator<MatchResult> i = this.matches.iterator();
        while (i.hasNext()) {
            MatchResultImpl res = (MatchResultImpl)i.next();
            if (!typedVar.equals(res.getName())) continue;
            i.remove();
            return res;
        }
        return null;
    }

    public void addSon(MatchResultImpl result) {
        this.getMatches().add(result);
    }

    public void setMatchImage(String matchImage) {
        this.matchImage = matchImage;
    }

    public boolean isTarget() {
        return this.target;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    public boolean isMatchImageNull() {
        return this.matchImage == null;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setContext(MatchResultImpl context) {
        this.myContext = context;
    }

    public MatchResultImpl getContext() {
        return this.myContext;
    }

    public String toString() {
        return "MatchResultImpl{name='" + this.name + '\'' + ", matchImage='" + this.matchImage + '\'' + "}";
    }
}

