/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.IconDeferrerImpl;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.PaintingParent;
import com.intellij.ui.RowIcon;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import org.jetbrains.annotations.NotNull;

public class DeferredIconImpl<T>
implements DeferredIcon {
    private static final int MIN_AUTO_UPDATE_MILLIS = 950;
    private static final RepaintScheduler ourRepaintScheduler = new RepaintScheduler();
    @NotNull
    private volatile Icon myDelegateIcon;
    private Function<T, Icon> myEvaluator;
    private volatile boolean myIsScheduled;
    private T myParam;
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_16;
    private final boolean myNeedReadAction;
    private boolean myDone;
    private final boolean myAutoUpdatable;
    private long myLastCalcTime;
    private long myLastTimeSpent;
    private final IconListener<T> myEvalListener;
    private static final TransferToEDTQueue<Runnable> ourLaterInvocator = TransferToEDTQueue.createRunnableMerger((String)"Deferred icon later invocator", (int)200);

    public DeferredIconImpl(Icon baseIcon, T param, @NotNull Function<T, Icon> evaluator, @NotNull IconListener<T> listener, boolean autoUpdatable) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/ui/DeferredIconImpl", "<init>"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/DeferredIconImpl", "<init>"));
        }
        this(baseIcon, param, true, evaluator, listener, autoUpdatable);
    }

    public DeferredIconImpl(Icon baseIcon, T param, boolean needReadAction, @NotNull Function<T, Icon> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/ui/DeferredIconImpl", "<init>"));
        }
        this(baseIcon, param, needReadAction, evaluator, null, false);
    }

    private DeferredIconImpl(Icon baseIcon, T param, boolean needReadAction, Function<T, Icon> evaluator, IconListener<T> listener, boolean autoUpdatable) {
        this.myIsScheduled = false;
        this.myLastCalcTime = 0L;
        this.myLastTimeSpent = 0L;
        this.myParam = param;
        this.myDelegateIcon = DeferredIconImpl.nonNull(baseIcon);
        this.myEvaluator = evaluator;
        this.myNeedReadAction = needReadAction;
        this.myEvalListener = listener;
        this.myAutoUpdatable = autoUpdatable;
    }

    @NotNull
    private static Icon nonNull(Icon icon) {
        Icon icon2 = icon == null ? EMPTY_ICON : icon;
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/DeferredIconImpl", "nonNull"));
        }
        return icon2;
    }

    public void paintIcon(final Component c, Graphics g, final int x, final int y) {
        if (!(this.myDelegateIcon instanceof DeferredIconImpl) || !(((DeferredIconImpl)((Object)this.myDelegateIcon)).myDelegateIcon instanceof DeferredIconImpl)) {
            this.myDelegateIcon.paintIcon(c, g, x, y);
        }
        if (this.isDone() || this.myIsScheduled || PowerSaveMode.isEnabled()) {
            return;
        }
        this.myIsScheduled = true;
        final Component target = DeferredIconImpl.getTarget(c);
        final Container paintingParent = SwingUtilities.getAncestorOfClass(PaintingParent.class, c);
        final Rectangle paintingParentRec = paintingParent == null ? null : ((PaintingParent)paintingParent).getChildRec(c);
        JobLauncher.getInstance().submitToJobThread(100, new Runnable(){

            @Override
            public void run() {
                int oldWidth = DeferredIconImpl.this.myDelegateIcon.getIconWidth();
                final Icon[] evaluated = new Icon[1];
                final long startTime = System.currentTimeMillis();
                if (DeferredIconImpl.this.myNeedReadAction) {
                    final Ref cancelled = new Ref();
                    boolean result = ProgressIndicatorUtils.runWithWriteActionPriority(new Runnable(){

                        @Override
                        public void run() {
                            if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    IconDeferrerImpl.evaluateDeferred(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                evaluated[0] = DeferredIconImpl.nonNull((Icon)DeferredIconImpl.this.myEvaluator.fun(DeferredIconImpl.this.myParam));
                                            }
                                            catch (IndexNotReadyException e) {
                                                evaluated[0] = EMPTY_ICON;
                                            }
                                        }
                                    });
                                    if (DeferredIconImpl.this.myAutoUpdatable) {
                                        DeferredIconImpl.this.myLastCalcTime = System.currentTimeMillis();
                                        DeferredIconImpl.this.myLastTimeSpent = DeferredIconImpl.this.myLastCalcTime - startTime;
                                    }
                                }
                            })) {
                                cancelled.set((Object)Boolean.TRUE);
                            }
                        }
                    });
                    if (cancelled.get() == Boolean.TRUE || !result) {
                        DeferredIconImpl.this.myIsScheduled = false;
                        return;
                    }
                } else {
                    IconDeferrerImpl.evaluateDeferred(new Runnable(){

                        @Override
                        public void run() {
                            evaluated[0] = DeferredIconImpl.nonNull((Icon)DeferredIconImpl.this.myEvaluator.fun(DeferredIconImpl.this.myParam));
                        }
                    });
                    if (DeferredIconImpl.this.myAutoUpdatable) {
                        DeferredIconImpl.this.myLastCalcTime = System.currentTimeMillis();
                        DeferredIconImpl.this.myLastTimeSpent = DeferredIconImpl.this.myLastCalcTime - startTime;
                    }
                }
                final Icon result = evaluated[0];
                DeferredIconImpl.this.myDelegateIcon = result;
                final boolean shouldRevalidate = Registry.is((String)"ide.tree.deferred.icon.invalidates.cache") && DeferredIconImpl.this.myDelegateIcon.getIconWidth() != oldWidth;
                ourLaterInvocator.offer((Object)new Runnable(){

                    @Override
                    public void run() {
                        TreeUI ui;
                        DeferredIconImpl.this.setDone(result);
                        Component actualTarget = target;
                        if (actualTarget != null && SwingUtilities.getWindowAncestor(actualTarget) == null && ((actualTarget = paintingParent) == null || SwingUtilities.getWindowAncestor(actualTarget) == null)) {
                            actualTarget = null;
                        }
                        if (actualTarget == null) {
                            return;
                        }
                        if (shouldRevalidate && actualTarget instanceof JTree && (ui = ((JTree)actualTarget).getUI()) instanceof BasicTreeUI) {
                            ((BasicTreeUI)ui).setLeftChildIndent(UIUtil.getTreeLeftChildIndent());
                        }
                        if (c == actualTarget) {
                            c.repaint(x, y, DeferredIconImpl.this.getIconWidth(), DeferredIconImpl.this.getIconHeight());
                        } else {
                            ourRepaintScheduler.pushDirtyComponent(actualTarget, paintingParentRec);
                        }
                    }
                });
            }
        });
    }

    private static Component getTarget(Component c) {
        Container tabLabel;
        Container box;
        Container table;
        Container tree;
        Container list = SwingUtilities.getAncestorOfClass(JList.class, c);
        Component target = list != null ? list : ((tree = SwingUtilities.getAncestorOfClass(JTree.class, c)) != null ? tree : ((table = SwingUtilities.getAncestorOfClass(JTable.class, c)) != null ? table : ((box = SwingUtilities.getAncestorOfClass(JComboBox.class, c)) != null ? box : ((tabLabel = SwingUtilities.getAncestorOfClass(TabLabel.class, c)) == null ? c : tabLabel))));
        return target;
    }

    private void setDone(@NotNull Icon result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ui/DeferredIconImpl", "setDone"));
        }
        if (this.myEvalListener != null) {
            this.myEvalListener.evalDone(this, this.myParam, result);
        }
        this.myDone = true;
        if (!this.myAutoUpdatable) {
            this.myEvaluator = null;
            this.myParam = null;
        }
    }

    @NotNull
    public Icon evaluate() {
        Icon result;
        try {
            result = DeferredIconImpl.nonNull((Icon)this.myEvaluator.fun(this.myParam));
        }
        catch (ProcessCanceledException e) {
            result = EMPTY_ICON;
        }
        catch (IndexNotReadyException e) {
            result = EMPTY_ICON;
        }
        this.checkDoesntReferenceThis(result);
        Icon icon = result;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/DeferredIconImpl", "evaluate"));
        }
        return icon;
    }

    private void checkDoesntReferenceThis(Icon icon) {
        block4: {
            block5: {
                block3: {
                    if (icon == this) {
                        throw new IllegalStateException("Loop in icons delegation");
                    }
                    if (!(icon instanceof DeferredIconImpl)) break block3;
                    this.checkDoesntReferenceThis(((DeferredIconImpl)((Object)icon)).myDelegateIcon);
                    break block4;
                }
                if (!(icon instanceof LayeredIcon)) break block5;
                for (Icon layer : ((LayeredIcon)icon).getAllLayers()) {
                    this.checkDoesntReferenceThis(layer);
                }
                break block4;
            }
            if (!(icon instanceof RowIcon)) break block4;
            RowIcon rowIcon = (RowIcon)icon;
            int count = rowIcon.getIconCount();
            for (int i = 0; i < count; ++i) {
                this.checkDoesntReferenceThis(rowIcon.getIcon(i));
            }
        }
    }

    public int getIconWidth() {
        return this.myDelegateIcon.getIconWidth();
    }

    public int getIconHeight() {
        return this.myDelegateIcon.getIconHeight();
    }

    public boolean isDone() {
        if (this.myAutoUpdatable && this.myDone && this.myLastCalcTime > 0L && System.currentTimeMillis() - this.myLastCalcTime > Math.max(950L, 10L * this.myLastTimeSpent)) {
            this.myDone = false;
            this.myIsScheduled = false;
        }
        return this.myDone;
    }

    public static interface IconListener<T> {
        public void evalDone(DeferredIconImpl<T> var1, T var2, @NotNull Icon var3);
    }

    private static class RepaintRequest {
        private final Component myComponent;
        private final Rectangle myRectangle;

        private RepaintRequest(@NotNull Component component, Rectangle rectangle) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/DeferredIconImpl$RepaintRequest", "<init>"));
            }
            this.myComponent = component;
            this.myRectangle = rectangle;
        }

        @NotNull
        public Component getComponent() {
            Component component = this.myComponent;
            if (component == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/DeferredIconImpl$RepaintRequest", "getComponent"));
            }
            return component;
        }

        public Rectangle getRectangle() {
            return this.myRectangle;
        }
    }

    private static class RepaintScheduler {
        private final Alarm myAlarm = new Alarm();
        private final Set<RepaintRequest> myQueue = new LinkedHashSet<RepaintRequest>();

        private RepaintScheduler() {
        }

        public void pushDirtyComponent(@NotNull Component c, Rectangle rec) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ui/DeferredIconImpl$RepaintScheduler", "pushDirtyComponent"));
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    for (RepaintRequest each : RepaintScheduler.this.myQueue) {
                        Rectangle r = each.getRectangle();
                        if (r == null) {
                            each.getComponent().repaint();
                            continue;
                        }
                        each.getComponent().repaint(r.x, r.y, r.width, r.height);
                    }
                    RepaintScheduler.this.myQueue.clear();
                }
            }, 50);
            this.myQueue.add(new RepaintRequest(c, rec));
        }
    }
}

