/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.ElementPresentationTemplate;
import com.intellij.util.xml.Stubbed;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.ElementPresentationTemplateImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomExtensionImpl;
import gnu.trove.THashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomChildDescriptionImpl
implements AbstractDomChildrenDescription,
Comparable<AbstractDomChildDescriptionImpl> {
    private final Type myType;
    private Map<Class, Annotation> myCustomAnnotations;
    @Nullable
    private Map myUserMap;
    private final NullableLazyValue<ElementPresentationTemplate> myPresentationTemplate = new NullableLazyValue<ElementPresentationTemplate>(){

        protected ElementPresentationTemplate compute() {
            Class clazz = ReflectionUtil.getRawType((Type)AbstractDomChildDescriptionImpl.this.getType());
            Presentation presentation = DomApplicationComponent.getInstance().getInvocationCache(clazz).getClassAnnotation(Presentation.class);
            return presentation == null ? null : new ElementPresentationTemplateImpl(presentation, clazz);
        }
    };
    private NotNullLazyValue<Boolean> myStubbed = new NotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            Boolean bl = AbstractDomChildDescriptionImpl.this.myType instanceof Class && DomReflectionUtil.findAnnotationDFS((Class)((Class)AbstractDomChildDescriptionImpl.this.myType), Stubbed.class) != null || AbstractDomChildDescriptionImpl.this.getAnnotation(Stubbed.class) != null;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl$2", "compute"));
            }
            return bl;
        }
    };

    protected AbstractDomChildDescriptionImpl(Type type) {
        this.myType = type;
    }

    public final void addCustomAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "addCustomAnnotation"));
        }
        if (this.myCustomAnnotations == null) {
            this.myCustomAnnotations = new THashMap();
        }
        this.myCustomAnnotations.put(annotation.annotationType(), annotation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDomChildDescriptionImpl that = (AbstractDomChildDescriptionImpl)o;
        if (this.myCustomAnnotations != null ? !((Object)this.myCustomAnnotations).equals(that.myCustomAnnotations) : that.myCustomAnnotations != null) {
            return false;
        }
        if (!this.getType().equals(that.getType())) {
            return false;
        }
        return !(this.myUserMap != null ? !((Object)this.myUserMap).equals(that.myUserMap) : that.myUserMap != null);
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + (this.myCustomAnnotations != null ? ((Object)this.myCustomAnnotations).hashCode() : 0);
        result = 31 * result + (this.myUserMap != null ? ((Object)this.myUserMap).hashCode() : 0);
        return result;
    }

    public void setUserMap(Map userMap) {
        this.myUserMap = userMap;
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)(this.myCustomAnnotations == null ? null : this.myCustomAnnotations.get(annotationClass));
    }

    public <T> T getUserData(Key<T> key) {
        return this.myUserMap == null ? null : (T)this.myUserMap.get(key);
    }

    @NotNull
    public final List<? extends DomElement> getStableValues(final @NotNull DomElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "getStableValues"));
        }
        List list = this.getValues(parent);
        ArrayList<DomElement> result = new ArrayList<DomElement>(list.size());
        DomManager domManager = parent.getManager();
        int i = 0;
        while (i < list.size()) {
            final int i1 = i++;
            result.add(domManager.createStableValue((Factory)new Factory<DomElement>(){

                @Nullable
                public DomElement create() {
                    if (!parent.isValid()) {
                        return null;
                    }
                    List domElements = AbstractDomChildDescriptionImpl.this.getValues(parent);
                    return domElements.size() > i1 ? (DomElement)domElements.get(i1) : null;
                }
            }));
        }
        ArrayList<DomElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "getStableValues"));
        }
        return arrayList;
    }

    @NotNull
    public final Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "getType"));
        }
        return type;
    }

    @NotNull
    public DomNameStrategy getDomNameStrategy(@NotNull DomElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "getDomNameStrategy"));
        }
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(ReflectionUtil.getRawType((Type)this.getType()), false);
        DomNameStrategy domNameStrategy = strategy == null ? parent.getNameStrategy() : strategy;
        if (domNameStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "getDomNameStrategy"));
        }
        return domNameStrategy;
    }

    public boolean isValid() {
        return true;
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    @Nullable
    public ElementPresentationTemplate getPresentationTemplate() {
        return (ElementPresentationTemplate)this.myPresentationTemplate.getValue();
    }

    @Nullable
    public PsiElement getDeclaration(Project project) {
        PsiElement element;
        DomElement domDeclaration = this.getDomDeclaration();
        if (domDeclaration != null) {
            DomTarget target = DomTarget.getTarget((DomElement)domDeclaration);
            if (target != null) {
                return PomService.convertToPsi((PsiTarget)target);
            }
            return domDeclaration.getXmlElement();
        }
        DomAnchor anchor = this.getUserData(DomExtensionImpl.KEY_DOM_DECLARATION);
        if (anchor != null) {
            return anchor.getContainingFile();
        }
        SmartPsiElementPointer<?> pointer = this.getUserData(DomExtensionImpl.DECLARING_ELEMENT_KEY);
        if (pointer != null && (element = pointer.getElement()) != null) {
            return element;
        }
        return PomService.convertToPsi((Project)project, (PomTarget)this);
    }

    public DomElement getDomDeclaration() {
        DomAnchor anchor = this.getUserData(DomExtensionImpl.KEY_DOM_DECLARATION);
        if (anchor != null) {
            return anchor.retrieveDomElement();
        }
        return null;
    }

    public boolean isStubbed() {
        return (Boolean)this.myStubbed.getValue();
    }
}

