/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.visible;

import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.utils.Flags;
import org.jetbrains.annotations.NotNull;

public class DottedEdgesComputer {
    @NotNull
    private final LinearGraph myDelegateGraph;
    @NotNull
    private final Flags myVisibleNodes;
    @NotNull
    private final MultiMap<Integer, Integer> myDottedEdges;
    @NotNull
    private final int[] myNumbers;

    @NotNull
    public static MultiMap<Integer, Integer> compute(@NotNull LinearGraph delegateGraph, @NotNull Flags visibleNodes) {
        if (delegateGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateGraph", "com/intellij/vcs/log/graph/impl/visible/DottedEdgesComputer", "compute"));
        }
        if (visibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleNodes", "com/intellij/vcs/log/graph/impl/visible/DottedEdgesComputer", "compute"));
        }
        DottedEdgesComputer dottedEdgesComputer = new DottedEdgesComputer(delegateGraph, visibleNodes);
        dottedEdgesComputer.compute();
        MultiMap<Integer, Integer> multiMap = dottedEdgesComputer.myDottedEdges;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/DottedEdgesComputer", "compute"));
        }
        return multiMap;
    }

    private DottedEdgesComputer(@NotNull LinearGraph delegateGraph, @NotNull Flags visibleNodes) {
        if (delegateGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateGraph", "com/intellij/vcs/log/graph/impl/visible/DottedEdgesComputer", "<init>"));
        }
        if (visibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleNodes", "com/intellij/vcs/log/graph/impl/visible/DottedEdgesComputer", "<init>"));
        }
        assert (delegateGraph.nodesCount() == visibleNodes.size());
        this.myDelegateGraph = delegateGraph;
        this.myVisibleNodes = visibleNodes;
        this.myDottedEdges = MultiMap.create();
        this.myNumbers = new int[this.myDelegateGraph.nodesCount()];
    }

    private void putEdge(int node1, int node2) {
        this.myDottedEdges.putValue((Object)node1, (Object)node2);
        this.myDottedEdges.putValue((Object)node2, (Object)node1);
    }

    private void compute() {
        this.downWalk();
        this.upWalk();
    }

    private void downWalk() {
        for (int i = 0; i < this.myDelegateGraph.nodesCount() - 1; ++i) {
            int nearlyUp;
            if (this.myVisibleNodes.get(i)) {
                nearlyUp = Integer.MIN_VALUE;
                int maxAdjNumber = Integer.MIN_VALUE;
                for (int upNode : this.myDelegateGraph.getUpNodes(i)) {
                    if (this.myVisibleNodes.get(upNode)) {
                        maxAdjNumber = Math.max(maxAdjNumber, this.myNumbers[upNode]);
                        continue;
                    }
                    nearlyUp = Math.max(nearlyUp, this.myNumbers[upNode]);
                }
                if (nearlyUp == maxAdjNumber || nearlyUp == Integer.MIN_VALUE) {
                    this.myNumbers[i] = maxAdjNumber;
                    continue;
                }
                this.putEdge(i, nearlyUp);
                this.myNumbers[i] = nearlyUp;
                continue;
            }
            nearlyUp = Integer.MIN_VALUE;
            for (int upNode : this.myDelegateGraph.getUpNodes(i)) {
                if (this.myVisibleNodes.get(upNode)) {
                    nearlyUp = Math.max(nearlyUp, upNode);
                    continue;
                }
                nearlyUp = Math.max(nearlyUp, this.myNumbers[upNode]);
            }
            this.myNumbers[i] = nearlyUp;
        }
    }

    private void upWalk() {
        for (int i = this.myDelegateGraph.nodesCount() - 1; i >= 0; --i) {
            int nearlyDown;
            if (this.myVisibleNodes.get(i)) {
                nearlyDown = Integer.MAX_VALUE;
                int minAdjNumber = Integer.MAX_VALUE;
                for (int downNode : this.myDelegateGraph.getDownNodes(i)) {
                    if (downNode == Integer.MAX_VALUE) continue;
                    if (this.myVisibleNodes.get(downNode)) {
                        minAdjNumber = Math.min(minAdjNumber, this.myNumbers[downNode]);
                        continue;
                    }
                    nearlyDown = Math.min(nearlyDown, this.myNumbers[downNode]);
                }
                if (nearlyDown == minAdjNumber || nearlyDown == Integer.MAX_VALUE) {
                    this.myNumbers[i] = minAdjNumber;
                    continue;
                }
                this.putEdge(i, nearlyDown);
                this.myNumbers[i] = nearlyDown;
                continue;
            }
            nearlyDown = Integer.MAX_VALUE;
            for (int downNode : this.myDelegateGraph.getDownNodes(i)) {
                if (downNode == Integer.MAX_VALUE) continue;
                if (this.myVisibleNodes.get(downNode)) {
                    nearlyDown = Math.min(nearlyDown, downNode);
                    continue;
                }
                nearlyDown = Math.min(nearlyDown, this.myNumbers[downNode]);
            }
            this.myNumbers[i] = nearlyDown;
        }
    }
}

