/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.DebuggerToggleActionHandler;
import com.intellij.xdebugger.impl.actions.EditBreakpointActionHandler;
import com.intellij.xdebugger.impl.actions.MarkObjectActionHandler;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.settings.DebuggerSettingsPanelProvider;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerSupport {
    private static final ExtensionPointName<DebuggerSupport> EXTENSION_POINT = ExtensionPointName.create((String)"com.intellij.xdebugger.debuggerSupport");
    private static final DebuggerSettingsPanelProvider EMPTY_SETTINGS_PANEL_PROVIDER = new DebuggerSettingsPanelProvider(){};
    private static final QuickEvaluateHandler DISABLED_QUICK_EVALUATE = new QuickEvaluateHandler(){

        @Override
        public boolean isEnabled(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/DebuggerSupport$2", "isEnabled"));
            }
            return false;
        }

        @Override
        @Nullable
        public AbstractValueHint createValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, ValueHintType type) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/DebuggerSupport$2", "createValueHint"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/DebuggerSupport$2", "createValueHint"));
            }
            if (point == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/DebuggerSupport$2", "createValueHint"));
            }
            return null;
        }

        @Override
        public boolean canShowHint(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/DebuggerSupport$2", "canShowHint"));
            }
            return false;
        }

        @Override
        public int getValueLookupDelay(Project project) {
            return 0;
        }
    };

    @NotNull
    public static DebuggerSupport[] getDebuggerSupports() {
        DebuggerSupport[] debuggerSupportArray = (DebuggerSupport[])Extensions.getExtensions(EXTENSION_POINT);
        if (debuggerSupportArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/DebuggerSupport", "getDebuggerSupports"));
        }
        return debuggerSupportArray;
    }

    @NotNull
    public abstract BreakpointPanelProvider<?> getBreakpointPanelProvider();

    @Deprecated
    @NotNull
    public DebuggerSettingsPanelProvider getSettingsPanelProvider() {
        DebuggerSettingsPanelProvider debuggerSettingsPanelProvider = EMPTY_SETTINGS_PANEL_PROVIDER;
        if (debuggerSettingsPanelProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/DebuggerSupport", "getSettingsPanelProvider"));
        }
        return debuggerSettingsPanelProvider;
    }

    @NotNull
    public abstract DebuggerActionHandler getStepOverHandler();

    @NotNull
    public abstract DebuggerActionHandler getStepIntoHandler();

    @NotNull
    public abstract DebuggerActionHandler getSmartStepIntoHandler();

    @NotNull
    public abstract DebuggerActionHandler getStepOutHandler();

    @NotNull
    public abstract DebuggerActionHandler getForceStepOverHandler();

    @NotNull
    public abstract DebuggerActionHandler getForceStepIntoHandler();

    @NotNull
    public abstract DebuggerActionHandler getRunToCursorHandler();

    @NotNull
    public abstract DebuggerActionHandler getForceRunToCursorHandler();

    @NotNull
    public abstract DebuggerActionHandler getResumeActionHandler();

    @NotNull
    public abstract DebuggerActionHandler getPauseHandler();

    @NotNull
    public abstract DebuggerActionHandler getToggleLineBreakpointHandler();

    @NotNull
    public abstract DebuggerActionHandler getToggleTemporaryLineBreakpointHandler();

    @NotNull
    public abstract DebuggerActionHandler getShowExecutionPointHandler();

    @NotNull
    public abstract DebuggerActionHandler getEvaluateHandler();

    @NotNull
    public QuickEvaluateHandler getQuickEvaluateHandler() {
        QuickEvaluateHandler quickEvaluateHandler = DISABLED_QUICK_EVALUATE;
        if (quickEvaluateHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/DebuggerSupport", "getQuickEvaluateHandler"));
        }
        return quickEvaluateHandler;
    }

    @NotNull
    public abstract DebuggerActionHandler getAddToWatchesActionHandler();

    public DebuggerActionHandler getEvaluateInConsoleActionHandler() {
        return DisabledActionHandler.INSTANCE;
    }

    @NotNull
    public abstract DebuggerToggleActionHandler getMuteBreakpointsHandler();

    @NotNull
    public abstract MarkObjectActionHandler getMarkObjectHandler();

    @Nullable
    public abstract AbstractDebuggerSession getCurrentSession(@NotNull Project var1);

    @NotNull
    public abstract EditBreakpointActionHandler getEditBreakpointAction();

    @NotNull
    public static <T extends DebuggerSupport> DebuggerSupport getDebuggerSupport(Class<T> aClass) {
        for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
            if (support.getClass() != aClass) continue;
            DebuggerSupport debuggerSupport = support;
            if (debuggerSupport == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/DebuggerSupport", "getDebuggerSupport"));
            }
            return debuggerSupport;
        }
        throw new IllegalStateException();
    }

    protected static final class DisabledActionHandler
    extends DebuggerActionHandler {
        public static final DisabledActionHandler INSTANCE = new DisabledActionHandler();

        protected DisabledActionHandler() {
        }

        @Override
        public void perform(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/DebuggerSupport$DisabledActionHandler", "perform"));
            }
        }

        @Override
        public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/DebuggerSupport$DisabledActionHandler", "isEnabled"));
            }
            return false;
        }
    }
}

