/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.memory.InnerClassReferenceVisitor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class InnerClassMayBeStaticInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inner.class.may.be.static.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/InnerClassMayBeStaticInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inner.class.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/InnerClassMayBeStaticInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InnerClassMayBeStaticFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassMayBeStaticVisitor();
    }

    private static class InnerClassMayBeStaticVisitor
    extends BaseInspectionVisitor {
        private InnerClassMayBeStaticVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass[] innerClasses;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/memory/InnerClassMayBeStaticInspection$InnerClassMayBeStaticVisitor", "visitClass"));
            }
            if (aClass.getContainingClass() != null && !aClass.hasModifierProperty("static")) {
                return;
            }
            if (aClass instanceof PsiAnonymousClass) {
                return;
            }
            for (PsiClass innerClass : innerClasses = aClass.getInnerClasses()) {
                if (innerClass.hasModifierProperty("static")) continue;
                InnerClassReferenceVisitor visitor = new InnerClassReferenceVisitor(innerClass);
                innerClass.accept((PsiElementVisitor)visitor);
                if (!visitor.canInnerClassBeStatic()) continue;
                this.registerClassError(innerClass, new Object[0]);
            }
        }
    }

    private static class InnerClassMayBeStaticFix
    extends InspectionGadgetsFix {
        private InnerClassMayBeStaticFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/InnerClassMayBeStaticInspection$InnerClassMayBeStaticFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("make.static.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/InnerClassMayBeStaticInspection$InnerClassMayBeStaticFix", "getName"));
            }
            return string;
        }

        @Override
        protected boolean prepareForWriting() {
            return false;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiJavaToken classNameToken = (PsiJavaToken)descriptor.getPsiElement();
            PsiClass innerClass = (PsiClass)classNameToken.getParent();
            if (innerClass == null) {
                return;
            }
            SearchScope useScope = innerClass.getUseScope();
            Query query = ReferencesSearch.search((PsiElement)innerClass, (SearchScope)useScope);
            Collection references = query.findAll();
            ArrayList<Object> elements = new ArrayList<Object>(references.size() + 1);
            for (PsiReference reference : references) {
                elements.add(reference.getElement());
            }
            elements.add(innerClass);
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                return;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            for (PsiReference reference : references) {
                PsiExpressionList argumentList;
                PsiNewExpression newExpression;
                PsiJavaCodeReferenceElement classReference;
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                if (!(parent instanceof PsiNewExpression) || (classReference = (newExpression = (PsiNewExpression)parent).getClassReference()) == null || (argumentList = newExpression.getArgumentList()) == null) continue;
                PsiExpression expression = factory.createExpressionFromText("new " + classReference.getQualifiedName() + argumentList.getText(), (PsiElement)innerClass);
                codeStyleManager.shortenClassReferences(newExpression.replace((PsiElement)expression));
            }
            PsiModifierList modifiers = innerClass.getModifierList();
            if (modifiers == null) {
                return;
            }
            modifiers.setModifierProperty("static", true);
        }
    }
}

