/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.ReplaceIfWithConditionalPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceIfWithConditionalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ReplaceIfWithConditionalPredicate replaceIfWithConditionalPredicate = new ReplaceIfWithConditionalPredicate();
        if (replaceIfWithConditionalPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/trivialif/ReplaceIfWithConditionalIntention", "getElementPredicate"));
        }
        return replaceIfWithConditionalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/trivialif/ReplaceIfWithConditionalIntention", "processIntention"));
        }
        PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
        if (ifStatement == null) {
            return;
        }
        if (ReplaceIfWithConditionalPredicate.isReplaceableAssignment(ifStatement)) {
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiExpressionStatement strippedThenBranch = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiExpressionStatement strippedElseBranch = (PsiExpressionStatement)ControlFlowUtils.stripBraces(elseBranch);
            PsiAssignmentExpression thenAssign = (PsiAssignmentExpression)strippedThenBranch.getExpression();
            PsiAssignmentExpression elseAssign = (PsiAssignmentExpression)strippedElseBranch.getExpression();
            PsiExpression lhs = thenAssign.getLExpression();
            String lhsText = lhs.getText();
            PsiJavaToken sign = thenAssign.getOperationSign();
            String operator = sign.getText();
            PsiExpression thenRhs = thenAssign.getRExpression();
            if (thenRhs == null) {
                return;
            }
            PsiExpression elseRhs = elseAssign.getRExpression();
            if (elseRhs == null) {
                return;
            }
            String conditional = ReplaceIfWithConditionalIntention.getConditionalText(condition, thenRhs, elseRhs, thenAssign.getType());
            PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, lhsText + operator + conditional + ';');
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement)) {
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiReturnStatement thenReturn = (PsiReturnStatement)ControlFlowUtils.stripBraces(thenBranch);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiReturnStatement elseReturn = (PsiReturnStatement)ControlFlowUtils.stripBraces(elseBranch);
            PsiExpression thenReturnValue = thenReturn.getReturnValue();
            if (thenReturnValue == null) {
                return;
            }
            PsiExpression elseReturnValue = elseReturn.getReturnValue();
            if (elseReturnValue == null) {
                return;
            }
            PsiElement method = PsiTreeUtil.getParentOfType((PsiElement)thenReturn, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (method == null) {
                return;
            }
            PsiType returnType = method instanceof PsiMethod ? ((PsiMethod)method).getReturnType() : LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)method));
            String conditional = ReplaceIfWithConditionalIntention.getConditionalText(condition, thenReturnValue, elseReturnValue, returnType);
            PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, "return " + conditional + ';');
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableMethodCall(ifStatement)) {
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            PsiExpressionStatement thenBranch = (PsiExpressionStatement)ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            PsiExpressionStatement elseBranch = (PsiExpressionStatement)ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
            PsiMethodCallExpression thenMethodCallExpression = (PsiMethodCallExpression)thenBranch.getExpression();
            PsiMethodCallExpression elseMethodCallExpression = (PsiMethodCallExpression)elseBranch.getExpression();
            StringBuilder replacementText = new StringBuilder(thenMethodCallExpression.getMethodExpression().getText());
            replacementText.append('(');
            PsiExpressionList thenArgumentList = thenMethodCallExpression.getArgumentList();
            PsiExpression[] thenArguments = thenArgumentList.getExpressions();
            PsiExpressionList elseArgumentList = elseMethodCallExpression.getArgumentList();
            PsiExpression[] elseArguments = elseArgumentList.getExpressions();
            int length = thenArguments.length;
            for (int i = 0; i < length; ++i) {
                PsiExpression elseArgument;
                PsiExpression thenArgument;
                if (i > 0) {
                    replacementText.append(',');
                }
                if (EquivalenceChecker.expressionsAreEquivalent(thenArgument = thenArguments[i], elseArgument = elseArguments[i])) {
                    replacementText.append(thenArgument.getText());
                    continue;
                }
                PsiMethod method = thenMethodCallExpression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiParameterList parameterList = method.getParameterList();
                PsiType requiredType = parameterList.getParameters()[i].getType();
                String conditionalText = ReplaceIfWithConditionalIntention.getConditionalText(condition, thenArgument, elseArgument, requiredType);
                if (conditionalText == null) {
                    return;
                }
                replacementText.append(conditionalText);
            }
            replacementText.append(");");
            PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, replacementText.toString());
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableImplicitReturn(ifStatement)) {
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            PsiReturnStatement thenBranch = (PsiReturnStatement)ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            PsiExpression thenReturnValue = thenBranch.getReturnValue();
            if (thenReturnValue == null) {
                return;
            }
            PsiReturnStatement elseBranch = (PsiReturnStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)ifStatement, PsiReturnStatement.class);
            if (elseBranch == null) {
                return;
            }
            PsiExpression elseReturnValue = elseBranch.getReturnValue();
            if (elseReturnValue == null) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)thenBranch, PsiMethod.class);
            if (method == null) {
                return;
            }
            PsiType methodType = method.getReturnType();
            String conditional = ReplaceIfWithConditionalIntention.getConditionalText(condition, thenReturnValue, elseReturnValue, methodType);
            if (conditional == null) {
                return;
            }
            PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, "return " + conditional + ';');
            elseBranch.delete();
        }
    }

    private static String getConditionalText(PsiExpression condition, PsiExpression thenValue, PsiExpression elseValue, PsiType requiredType) {
        condition = ParenthesesUtils.stripParentheses(condition);
        thenValue = ParenthesesUtils.stripParentheses(thenValue);
        elseValue = ParenthesesUtils.stripParentheses(elseValue);
        if ((thenValue = ReplaceIfWithConditionalIntention.expandDiamondsWhenNeeded(thenValue, requiredType)) == null) {
            return null;
        }
        if ((elseValue = ReplaceIfWithConditionalIntention.expandDiamondsWhenNeeded(elseValue, requiredType)) == null) {
            return null;
        }
        StringBuilder conditional = new StringBuilder();
        String conditionText = ReplaceIfWithConditionalIntention.getExpressionText(condition, true);
        conditional.append(conditionText).append('?');
        PsiType thenType = thenValue.getType();
        PsiType elseType = elseValue.getType();
        if (thenType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)thenType) && !(elseType instanceof PsiPrimitiveType) && !(requiredType instanceof PsiPrimitiveType)) {
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)thenType;
            conditional.append(primitiveType.getBoxedTypeName());
            conditional.append(".valueOf(").append(thenValue.getText()).append("):");
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(elseValue, false));
        } else if (elseType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)elseType) && !(thenType instanceof PsiPrimitiveType) && !(requiredType instanceof PsiPrimitiveType)) {
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(thenValue, false));
            conditional.append(':');
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)elseType;
            conditional.append(primitiveType.getBoxedTypeName());
            conditional.append(".valueOf(").append(elseValue.getText()).append(')');
        } else {
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(thenValue, false));
            conditional.append(':');
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(elseValue, false));
        }
        return conditional.toString();
    }

    private static PsiExpression expandDiamondsWhenNeeded(PsiExpression thenValue, PsiType requiredType) {
        if (thenValue instanceof PsiNewExpression && !PsiDiamondTypeUtil.canChangeContextForDiamond((PsiNewExpression)thenValue, requiredType)) {
            return PsiDiamondTypeUtil.expandTopLevelDiamondsInside(thenValue);
        }
        return thenValue;
    }

    private static String getExpressionText(PsiExpression expression, boolean isCondition) {
        int precedence = ParenthesesUtils.getPrecedence(expression);
        if (precedence <= 15) {
            if (isCondition && precedence == 15) {
                return '(' + expression.getText() + ')';
            }
            return expression.getText();
        }
        return '(' + expression.getText() + ')';
    }
}

