/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import com.intellij.openapi.util.ActionCallback;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public abstract class ValueManager {
    private final AtomicInteger cacheStamp = new AtomicInteger();
    private volatile boolean obsolete;

    public void clearCaches() {
        this.cacheStamp.incrementAndGet();
    }

    @NotNull
    public Runnable getClearCachesTask() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ValueManager.this.clearCaches();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ValueManager", "getClearCachesTask"));
        }
        return runnable;
    }

    public final int getCacheStamp() {
        return this.cacheStamp.get();
    }

    public final boolean isObsolete() {
        return this.obsolete;
    }

    public final void markObsolete() {
        this.obsolete = true;
    }

    public final boolean rejectIfObsolete(@NotNull ActionCallback result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/debugger/values/ValueManager", "rejectIfObsolete"));
        }
        if (this.isObsolete()) {
            result.reject("Obsolete context");
            return true;
        }
        return false;
    }
}

