/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.IncorrectOperationException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.GenerateToStringContext;
import org.jetbrains.generate.tostring.GenerateToStringUtils;
import org.jetbrains.generate.tostring.config.Config;
import org.jetbrains.generate.tostring.config.ConflictResolutionPolicy;
import org.jetbrains.generate.tostring.config.DuplicatePolicy;
import org.jetbrains.generate.tostring.config.DuplicationPolicy;
import org.jetbrains.generate.tostring.config.InsertAfterEqualsHashCodeStrategy;
import org.jetbrains.generate.tostring.config.InsertAtCaretStrategy;
import org.jetbrains.generate.tostring.config.InsertLastStrategy;
import org.jetbrains.generate.tostring.config.InsertNewMethodStrategy;
import org.jetbrains.generate.tostring.config.InsertWhere;
import org.jetbrains.generate.tostring.config.ReplacePolicy;
import org.jetbrains.generate.tostring.element.ClassElement;
import org.jetbrains.generate.tostring.element.Element;
import org.jetbrains.generate.tostring.element.ElementComparator;
import org.jetbrains.generate.tostring.element.ElementFactory;
import org.jetbrains.generate.tostring.element.ElementUtils;
import org.jetbrains.generate.tostring.exception.GenerateCodeException;
import org.jetbrains.generate.tostring.psi.PsiAdapter;
import org.jetbrains.generate.tostring.template.TemplateResource;
import org.jetbrains.generate.tostring.velocity.VelocityFactory;
import org.jetbrains.generate.tostring.view.MethodExistsDialog;

public class GenerateToStringWorker {
    private static final Logger logger = Logger.getInstance((String)"#org.jetbrains.generate.tostring.GenerateToStringWorker");
    private final Editor editor;
    private final PsiClass clazz;
    private final Config config;
    private final boolean hasOverrideAnnotation;

    public GenerateToStringWorker(PsiClass clazz, Editor editor, boolean insertAtOverride) {
        this.clazz = clazz;
        this.editor = editor;
        this.config = GenerateToStringContext.getConfig();
        this.hasOverrideAnnotation = insertAtOverride;
    }

    public void execute(Collection<PsiMember> members, TemplateResource template) throws IncorrectOperationException, GenerateCodeException {
        ConflictResolutionPolicy resolutionPolicy = this.exitsMethodDialog(template);
        resolutionPolicy.setNewMethodStrategy(GenerateToStringWorker.getStrategy(this.config.getInsertNewMethodInitialOption()));
        HashMap<String, String> params = new HashMap<String, String>();
        this.beforeCreateToStringMethod(params, template);
        PsiMethod method = this.createToStringMethod(members, resolutionPolicy, params, template);
        if (method != null) {
            this.afterCreateToStringMethod(method, params, template);
        }
    }

    private static InsertNewMethodStrategy getStrategy(InsertWhere option) {
        switch (option) {
            case AFTER_EQUALS_AND_HASHCODE: {
                return InsertAfterEqualsHashCodeStrategy.getInstance();
            }
            case AT_CARET: {
                return InsertAtCaretStrategy.getInstance();
            }
            case AT_THE_END_OF_A_CLASS: {
                return InsertLastStrategy.getInstance();
            }
        }
        return InsertLastStrategy.getInstance();
    }

    protected ConflictResolutionPolicy exitsMethodDialog(TemplateResource template) {
        DuplicationPolicy dupPolicy = this.config.getReplaceDialogInitialOption();
        if (dupPolicy == DuplicationPolicy.ASK) {
            PsiMethod existingMethod = PsiAdapter.findMethodByName(this.clazz, template.getTargetMethodName());
            if (existingMethod != null) {
                return MethodExistsDialog.showDialog(template.getTargetMethodName());
            }
        } else if (dupPolicy == DuplicationPolicy.REPLACE) {
            return ReplacePolicy.getInstance();
        }
        return DuplicatePolicy.getInstance();
    }

    private void beforeCreateToStringMethod(Map<String, String> params, TemplateResource template) {
        PsiDocComment doc;
        PsiMethod existingMethod = PsiAdapter.findMethodByName(this.clazz, template.getTargetMethodName());
        if (existingMethod != null && existingMethod.getDocComment() != null && (doc = existingMethod.getDocComment()) != null) {
            params.put("existingJavaDoc", doc.getText());
        }
    }

    @Nullable
    private PsiMethod createToStringMethod(Collection<PsiMember> selectedMembers, ConflictResolutionPolicy policy, Map<String, String> params, TemplateResource template) throws IncorrectOperationException, GenerateCodeException {
        PsiMethod newMethod;
        String body = this.velocityGenerateCode(selectedMembers, params, template.getMethodBody());
        if (logger.isDebugEnabled()) {
            logger.debug("Method body generated from Velocity:\n" + body);
        }
        body = StringUtil.convertLineSeparators((String)body);
        JVMElementFactory topLevelFactory = JVMElementFactories.getFactory((Language)this.clazz.getLanguage(), (Project)this.clazz.getProject());
        if (topLevelFactory == null) {
            return null;
        }
        try {
            newMethod = topLevelFactory.createMethodFromText(template.getMethodSignature() + " { " + body + " }", (PsiElement)this.clazz);
            CodeStyleManager.getInstance((Project)this.clazz.getProject()).reformat((PsiElement)newMethod);
        }
        catch (IncorrectOperationException ignore) {
            HintManager.getInstance().showErrorHint(this.editor, "'toString()' method could not be created from template '" + template.getFileName() + '\'');
            return null;
        }
        PsiMethod existingMethod = this.clazz.findMethodBySignature(newMethod, false);
        PsiMethod toStringMethod = policy.applyMethod(this.clazz, existingMethod, newMethod, this.editor);
        if (toStringMethod == null) {
            return null;
        }
        if (this.hasOverrideAnnotation) {
            toStringMethod.getModifierList().addAnnotation("java.lang.Override");
        }
        String existingJavaDoc = params.get("existingJavaDoc");
        String newJavaDoc = template.getJavaDoc();
        if (existingJavaDoc != null || newJavaDoc != null) {
            newJavaDoc = this.velocityGenerateCode(selectedMembers, params, newJavaDoc);
            if (logger.isDebugEnabled()) {
                logger.debug("JavaDoc body generated from Velocity:\n" + newJavaDoc);
            }
            GenerateToStringWorker.applyJavaDoc(toStringMethod, existingJavaDoc, newJavaDoc);
        }
        return toStringMethod;
    }

    private static void applyJavaDoc(PsiMethod newMethod, String existingJavaDoc, String newJavaDoc) {
        String text = newJavaDoc != null ? newJavaDoc : existingJavaDoc;
        PsiAdapter.addOrReplaceJavadoc(newMethod, text, true);
    }

    private void afterCreateToStringMethod(PsiMethod method, Map<String, String> params, TemplateResource template) {
        PsiFile containingFile = this.clazz.getContainingFile();
        if (containingFile instanceof PsiJavaFile) {
            PsiJavaFile javaFile = (PsiJavaFile)containingFile;
            if (params.get("autoImportPackages") != null) {
                GenerateToStringWorker.autoImportPackages(javaFile, params.get("autoImportPackages"));
            }
        }
        method = (PsiMethod)JavaCodeStyleManager.getInstance((Project)this.clazz.getProject()).shortenClassReferences((PsiElement)method);
        if (!this.config.isJumpToMethod() || this.editor == null) {
            return;
        }
        int offset = method.getTextOffset();
        if (offset <= 2) {
            return;
        }
        VisualPosition vp = this.editor.offsetToVisualPosition(offset);
        if (logger.isDebugEnabled()) {
            logger.debug("Moving/Scrolling caret to " + vp + " (offset=" + offset + ")");
        }
        this.editor.getCaretModel().moveToVisualPosition(vp);
        this.editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_DOWN);
    }

    private static void autoImportPackages(PsiJavaFile psiJavaFile, String packageNames) throws IncorrectOperationException {
        StringTokenizer tok = new StringTokenizer(packageNames, ",");
        while (tok.hasMoreTokens()) {
            String packageName = tok.nextToken().trim();
            if (logger.isDebugEnabled()) {
                logger.debug("Auto importing package: " + packageName);
            }
            PsiAdapter.addImportStatement(psiJavaFile, packageName);
        }
    }

    private String velocityGenerateCode(Collection<PsiMember> selectedMembers, Map<String, String> params, String templateMacro) throws GenerateCodeException {
        if (templateMacro == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try {
            VelocityContext vc = new VelocityContext();
            vc.put("java_version", (Object)PsiAdapter.getJavaVersion((PsiElement)this.clazz));
            logger.debug("Velocity Context - adding fields");
            vc.put("fields", ElementUtils.getOnlyAsFieldElements(selectedMembers));
            logger.debug("Velocity Context - adding methods");
            vc.put("methods", ElementUtils.getOnlyAsMethodElements(selectedMembers));
            logger.debug("Velocity Context - adding members (fields and methods)");
            List<Element> elements = ElementUtils.getOnlyAsFieldAndMethodElements(selectedMembers);
            if (this.config.getSortElements() != 0) {
                Collections.sort(elements, new ElementComparator(this.config.getSortElements()));
            }
            vc.put("members", elements);
            ClassElement ce = ElementFactory.newClassElement(this.clazz);
            vc.put("class", (Object)ce);
            if (logger.isDebugEnabled()) {
                logger.debug("Velocity Context - adding class: " + ce);
            }
            vc.put("classname", (Object)(this.config.isUseFullyQualifiedName() ? ce.getQualifiedName() : ce.getName()));
            vc.put("FQClassname", (Object)ce.getQualifiedName());
            if (logger.isDebugEnabled()) {
                logger.debug("Velocity Macro:\n" + templateMacro);
            }
            VelocityEngine velocity = VelocityFactory.getVelocityEngine();
            logger.debug("Executing velocity +++ START +++");
            velocity.evaluate((Context)vc, (Writer)sw, this.getClass().getName(), templateMacro);
            logger.debug("Executing velocity +++ END +++");
            if (vc.get("autoImportPackages") != null) {
                params.put("autoImportPackages", (String)vc.get("autoImportPackages"));
            }
        }
        catch (Exception e) {
            throw new GenerateCodeException("Error in Velocity code generator", e);
        }
        return sw.getBuffer().toString();
    }

    public static void executeGenerateActionLater(final PsiClass clazz, final Editor editor, final Collection<PsiMember> selectedMembers, final TemplateResource template, final boolean insertAtOverride) {
        Runnable writeCommand = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new GenerateToStringWorker(clazz, editor, insertAtOverride).execute(selectedMembers, template);
                        }
                        catch (Exception e) {
                            GenerateToStringUtils.handleException(clazz.getProject(), e);
                        }
                    }
                });
            }
        };
        CommandProcessor.getInstance().executeCommand(clazz.getProject(), writeCommand, "GenerateToString", null);
    }
}

