/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.rt.execution.junit.ForkedVMWrapper;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.JUnitStarter;
import com.intellij.rt.execution.junit.ProcessBuilder;
import com.intellij.rt.execution.junit.TimeSender;
import com.intellij.rt.execution.junit.TreeSender;
import com.intellij.rt.execution.junit.segments.SegmentedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JUnitForkedStarter {
    static /* synthetic */ Class class$com$intellij$rt$execution$CommandLineWrapper;
    static /* synthetic */ Class class$com$intellij$rt$execution$junit$JUnitForkedStarter;

    private JUnitForkedStarter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String testOutputPath = args[0];
        int lastIdx = Integer.parseInt(args[1]);
        boolean isJUnit4 = args[2].equalsIgnoreCase("true");
        String[] childTestDescription = new String[]{args[3]};
        ArrayList<String> listeners = new ArrayList<String>();
        int argsLength = args.length;
        for (int i = 4; i < argsLength; ++i) {
            listeners.add(args[i]);
        }
        File file = new File(testOutputPath);
        if (!file.exists() && !file.createNewFile()) {
            return;
        }
        FileOutputStream stream = new FileOutputStream(testOutputPath);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        try {
            PrintStream out = new PrintStream(new ForkedVMWrapper(stream, false));
            PrintStream err = new PrintStream(new ForkedVMWrapper(stream, true));
            System.setOut(out);
            System.setErr(err);
            IdeaTestRunner testRunner = (IdeaTestRunner)JUnitStarter.getAgentClass(isJUnit4).newInstance();
            testRunner.setStreams(new SegmentedOutputStream(out, true), new SegmentedOutputStream(err, true), lastIdx);
            System.exit(testRunner.startRunnerWithArgs(childTestDescription, listeners, null, false));
        }
        finally {
            System.setOut(oldOut);
            System.setErr(oldErr);
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int startForkedVMs(String workingDirsPath, String[] args, boolean isJUnit4, List listeners, String params, SegmentedOutputStream out, SegmentedOutputStream err, String forkMode, String path) throws Exception {
        ArrayList<String> parameters = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(path));
        String dynamicClasspath = bufferedReader.readLine();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                parameters.add(line);
            }
        }
        finally {
            bufferedReader.close();
        }
        IdeaTestRunner testRunner = (IdeaTestRunner)JUnitStarter.getAgentClass(isJUnit4).newInstance();
        testRunner.setStreams(out, err, 0);
        Object description = testRunner.getTestToStart(args, params);
        if (description == null) {
            return -1;
        }
        TreeSender.sendTree(testRunner, description, true);
        long time = System.currentTimeMillis();
        int result = 0;
        if (workingDirsPath == null || new File(workingDirsPath).length() == 0L) {
            List children = testRunner.getChildTests(description);
            boolean forkTillMethod = forkMode.equalsIgnoreCase("method");
            result = JUnitForkedStarter.processChildren(isJUnit4, listeners, out, err, parameters, testRunner, children, 0, forkTillMethod, null, System.getProperty("java.class.path"), dynamicClasspath);
        } else {
            BufferedReader perDirReader = new BufferedReader(new FileReader(workingDirsPath));
            try {
                String workingDir;
                String packageName = perDirReader.readLine();
                while ((workingDir = perDirReader.readLine()) != null) {
                    int childResult;
                    ArrayList<String> classNames;
                    String classpath = perDirReader.readLine();
                    try {
                        classNames = new ArrayList<String>();
                        int classNamesSize = Integer.parseInt(perDirReader.readLine());
                        for (int i = 0; i < classNamesSize; ++i) {
                            String className = perDirReader.readLine();
                            if (className == null) {
                                System.err.println("Class name is expected. Working dir: " + workingDir);
                                int n = -1;
                                return n;
                            }
                            classNames.add(className);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Object rootDescriptor = JUnitForkedStarter.findByClassName(testRunner, (String)classNames.get(0), description);
                    File dir = new File(workingDir);
                    if (forkMode.equals("none")) {
                        File tempFile = File.createTempFile("idea_junit", ".tmp");
                        tempFile.deleteOnExit();
                        JUnitStarter.printClassesList(classNames, packageName + ", working directory: '" + workingDir + "'", "", tempFile);
                        childResult = JUnitForkedStarter.runChild(isJUnit4, listeners, out, err, parameters, "@" + tempFile.getAbsolutePath(), dir, String.valueOf(testRunner.getRegistry().getKnownObject(rootDescriptor) - 1), classpath, dynamicClasspath);
                    } else {
                        ArrayList children = new ArrayList(testRunner.getChildTests(description));
                        Iterator iterator = children.iterator();
                        while (iterator.hasNext()) {
                            if (classNames.contains(testRunner.getTestClassName(iterator.next()))) continue;
                            iterator.remove();
                        }
                        boolean forkTillMethod = forkMode.equalsIgnoreCase("method");
                        childResult = JUnitForkedStarter.processChildren(isJUnit4, listeners, out, err, parameters, testRunner, children, result, forkTillMethod, dir, classpath, dynamicClasspath);
                    }
                    result = Math.min(childResult, result);
                }
            }
            finally {
                perDirReader.close();
            }
        }
        time = System.currentTimeMillis() - time;
        new TimeSender(testRunner.getRegistry()).printHeader(time);
        return result;
    }

    private static Object findByClassName(IdeaTestRunner testRunner, String className, Object rootDescription) {
        int i;
        List children = testRunner.getChildTests(rootDescription);
        for (i = 0; i < children.size(); ++i) {
            Object child = children.get(i);
            if (!className.equals(testRunner.getTestClassName(child))) continue;
            return child;
        }
        for (i = 0; i < children.size(); ++i) {
            Object byName = JUnitForkedStarter.findByClassName(testRunner, className, children.get(i));
            if (byName == null) continue;
            return byName;
        }
        return null;
    }

    private static int processChildren(boolean isJUnit4, List listeners, SegmentedOutputStream out, SegmentedOutputStream err, List parameters, IdeaTestRunner testRunner, List children, int result, boolean forkTillMethod, File workingDir, String classpath, String dynamicClasspath) throws IOException, InterruptedException {
        int argsLength = children.size();
        for (int i = 0; i < argsLength; ++i) {
            int childResult;
            Object child = children.get(i);
            List childTests = testRunner.getChildTests(child);
            if (childTests.isEmpty() || !forkTillMethod) {
                int startIndex = testRunner.getRegistry().getKnownObject(child);
                childResult = JUnitForkedStarter.runChild(isJUnit4, listeners, out, err, parameters, testRunner.getStartDescription(child), workingDir, String.valueOf(startIndex), classpath, dynamicClasspath);
            } else {
                childResult = JUnitForkedStarter.processChildren(isJUnit4, listeners, out, err, parameters, testRunner, childTests, result, forkTillMethod, workingDir, classpath, dynamicClasspath);
            }
            result = Math.min(childResult, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runChild(boolean isJUnit4, List listeners, SegmentedOutputStream out, SegmentedOutputStream err, List parameters, String description, File workingDir, String startIndex, String classpath, String dynamicClasspath) throws IOException, InterruptedException {
        File tempFile = File.createTempFile("fork", "test");
        String testOutputPath = tempFile.getAbsolutePath();
        ProcessBuilder builder = new ProcessBuilder();
        builder.add(parameters);
        builder.add("-classpath");
        if (dynamicClasspath.length() > 0) {
            try {
                File classpathFile = File.createTempFile("classpath", null);
                classpathFile.deleteOnExit();
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(classpathFile), "UTF-8"));
                try {
                    int idx = 0;
                    while (idx < classpath.length()) {
                        int endIdx = classpath.indexOf(File.pathSeparator, idx);
                        if (endIdx < 0) {
                            writer.println(classpath.substring(idx));
                            break;
                        }
                        writer.println(classpath.substring(idx, endIdx));
                        idx = endIdx + File.pathSeparator.length();
                    }
                }
                finally {
                    writer.close();
                }
                builder.add(dynamicClasspath);
                builder.add((class$com$intellij$rt$execution$CommandLineWrapper == null ? (class$com$intellij$rt$execution$CommandLineWrapper = JUnitForkedStarter.class$("com.intellij.rt.execution.CommandLineWrapper")) : class$com$intellij$rt$execution$CommandLineWrapper).getName());
                builder.add(classpathFile.getAbsolutePath());
            }
            catch (Throwable e) {
                builder.add(classpath);
            }
        } else {
            builder.add(classpath);
        }
        builder.add((class$com$intellij$rt$execution$junit$JUnitForkedStarter == null ? (class$com$intellij$rt$execution$junit$JUnitForkedStarter = JUnitForkedStarter.class$("com.intellij.rt.execution.junit.JUnitForkedStarter")) : class$com$intellij$rt$execution$junit$JUnitForkedStarter).getName());
        builder.add(testOutputPath);
        builder.add(startIndex);
        builder.add(String.valueOf(isJUnit4));
        builder.add(description);
        builder.add(listeners);
        builder.setWorkingDir(workingDir);
        Process exec = builder.createProcess();
        int result = exec.waitFor();
        ForkedVMWrapper.readWrapped(testOutputPath, out.getPrintStream(), err.getPrintStream());
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

