/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.avdmanager.AvdEditWizard;
import com.android.tools.idea.avdmanager.AvdScaleFactor;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.ConfigureAvdOptionsStep;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdBuilder {
    private static final int MAX_RAM_MB = 1536;
    private static final Logger LOG = Logger.getInstance(AvdBuilder.class);
    private final ScopedStateStore myState = new ScopedStateStore(ScopedStateStore.Scope.WIZARD, null, null);
    private Abi myAbiType;
    private Integer myApiLevel;
    private String myApiString;

    public static AvdBuilder create() {
        return new AvdBuilder();
    }

    private AvdBuilder() {
        this.myState.put(AvdWizardConstants.SCALE_SELECTION_KEY, AvdWizardConstants.DEFAULT_SCALE);
        this.myState.put(AvdWizardConstants.NETWORK_SPEED_KEY, "full");
        this.myState.put(AvdWizardConstants.NETWORK_LATENCY_KEY, "none");
        this.myState.put(AvdWizardConstants.FRONT_CAMERA_KEY, "none");
        this.myState.put(AvdWizardConstants.BACK_CAMERA_KEY, "none");
        this.myState.put(AvdWizardConstants.INTERNAL_STORAGE_KEY, AvdWizardConstants.DEFAULT_INTERNAL_STORAGE);
        this.myState.put(AvdWizardConstants.USE_HOST_GPU_KEY, true);
        this.myState.put(AvdWizardConstants.SD_CARD_STORAGE_KEY, new Storage(100L, Storage.Unit.MiB));
    }

    @NotNull
    public AvdBuilder setDevice(@NotNull String manufacturer, @NotNull String deviceId) throws AvdBuilderException {
        if (manufacturer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manufacturer", "com/android/tools/idea/avdmanager/AvdBuilder", "setDevice"));
        }
        if (deviceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceId", "com/android/tools/idea/avdmanager/AvdBuilder", "setDevice"));
        }
        Device selectedDevice = null;
        List<Device> devices = DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices();
        for (Device device : devices) {
            if (!manufacturer.equals(device.getManufacturer()) || !deviceId.equals(device.getId())) continue;
            selectedDevice = device;
            break;
        }
        if (selectedDevice == null) {
            throw new AvdBuilderException(String.format("No Device found with Manufacturer %1$s, ID %2$s", manufacturer, deviceId));
        }
        this.setDevice(selectedDevice);
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setDevice"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setDevice(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/AvdBuilder", "setDevice"));
        }
        this.myState.put(AvdWizardConstants.DEVICE_DEFINITION_KEY, device);
        this.myState.put(AvdWizardConstants.RAM_STORAGE_KEY, AvdBuilder.getDefaultRam(device.getDefaultHardware()));
        this.myState.put(AvdWizardConstants.VM_HEAP_STORAGE_KEY, ConfigureAvdOptionsStep.calculateVmHeap(device));
        this.myState.put(AvdWizardConstants.DEFAULT_ORIENTATION_KEY, device.getDefaultState().getOrientation());
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setDevice"));
        }
        return avdBuilder;
    }

    @NotNull
    public static Storage getDefaultRam(@NotNull Hardware hardware) {
        if (hardware == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardware", "com/android/tools/idea/avdmanager/AvdBuilder", "getDefaultRam"));
        }
        Storage ram = hardware.getRam();
        if (ram.getSizeAsUnit(Storage.Unit.MiB) >= 1536L) {
            Storage storage = new Storage(1536L, Storage.Unit.MiB);
            if (storage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "getDefaultRam"));
            }
            return storage;
        }
        Storage storage = ram;
        if (storage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "getDefaultRam"));
        }
        return storage;
    }

    @NotNull
    public AvdBuilder setAbiType(@NotNull Abi abiType) {
        if (abiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abiType", "com/android/tools/idea/avdmanager/AvdBuilder", "setAbiType"));
        }
        this.myAbiType = abiType;
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setAbiType"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setAndroidVersion(@NotNull AndroidVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/avdmanager/AvdBuilder", "setAndroidVersion"));
        }
        this.setApiLevel(version.getApiLevel());
        this.setApiString(version.getApiString());
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setAndroidVersion"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setApiLevel(int apiLevel) {
        this.myApiLevel = apiLevel;
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setApiLevel"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setApiString(@NotNull String apiString) {
        if (apiString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apiString", "com/android/tools/idea/avdmanager/AvdBuilder", "setApiString"));
        }
        this.myApiString = apiString;
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setApiString"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setSystemImageDescription(@NotNull AvdWizardConstants.SystemImageDescription description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/avdmanager/AvdBuilder", "setSystemImageDescription"));
        }
        this.myState.put(AvdWizardConstants.SYSTEM_IMAGE_KEY, description);
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setSystemImageDescription"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setRam(@NotNull Storage ram) {
        if (ram == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ram", "com/android/tools/idea/avdmanager/AvdBuilder", "setRam"));
        }
        this.myState.put(AvdWizardConstants.RAM_STORAGE_KEY, ram);
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setRam"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setVmHeapStorage(@NotNull Storage vmHeapStorage) {
        if (vmHeapStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmHeapStorage", "com/android/tools/idea/avdmanager/AvdBuilder", "setVmHeapStorage"));
        }
        this.myState.put(AvdWizardConstants.VM_HEAP_STORAGE_KEY, vmHeapStorage);
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setVmHeapStorage"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setSdCard(@NotNull File sdCardFile) {
        if (sdCardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdCardFile", "com/android/tools/idea/avdmanager/AvdBuilder", "setSdCard"));
        }
        this.myState.remove(AvdWizardConstants.SD_CARD_STORAGE_KEY);
        this.myState.put(AvdWizardConstants.EXISTING_SD_LOCATION, sdCardFile.getPath());
        this.myState.put(AvdWizardConstants.USE_EXISTING_SD_CARD, true);
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setSdCard"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setSdCard(@NotNull Storage sdCard) {
        if (sdCard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdCard", "com/android/tools/idea/avdmanager/AvdBuilder", "setSdCard"));
        }
        this.myState.remove(AvdWizardConstants.EXISTING_SD_LOCATION);
        this.myState.put(AvdWizardConstants.SD_CARD_STORAGE_KEY, sdCard);
        this.myState.put(AvdWizardConstants.USE_EXISTING_SD_CARD, false);
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setSdCard"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setInternalStorage(@NotNull Storage internalStorage) {
        if (internalStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalStorage", "com/android/tools/idea/avdmanager/AvdBuilder", "setInternalStorage"));
        }
        this.myState.put(AvdWizardConstants.INTERNAL_STORAGE_KEY, internalStorage);
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setInternalStorage"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setScale(@NotNull AvdScaleFactor scale) {
        if (scale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scale", "com/android/tools/idea/avdmanager/AvdBuilder", "setScale"));
        }
        this.myState.put(AvdWizardConstants.SCALE_SELECTION_KEY, scale);
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setScale"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setUseHostGpu(boolean useHostGpu) {
        this.myState.put(AvdWizardConstants.USE_HOST_GPU_KEY, useHostGpu);
        if (useHostGpu) {
            this.myState.put(AvdWizardConstants.USE_SNAPSHOT_KEY, false);
        }
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setUseHostGpu"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setUseSnapshot(boolean useSnapshot) {
        this.myState.put(AvdWizardConstants.USE_SNAPSHOT_KEY, useSnapshot);
        if (useSnapshot) {
            this.myState.put(AvdWizardConstants.USE_HOST_GPU_KEY, false);
        }
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setUseSnapshot"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setFrontCamera(@NotNull String cameraType) {
        if (cameraType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cameraType", "com/android/tools/idea/avdmanager/AvdBuilder", "setFrontCamera"));
        }
        this.myState.put(AvdWizardConstants.FRONT_CAMERA_KEY, cameraType.toLowerCase());
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setFrontCamera"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setBackCamera(@NotNull String cameraType) {
        if (cameraType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cameraType", "com/android/tools/idea/avdmanager/AvdBuilder", "setBackCamera"));
        }
        this.myState.put(AvdWizardConstants.BACK_CAMERA_KEY, cameraType.toLowerCase());
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setBackCamera"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setNetworkLatency(@NotNull String latency) {
        if (latency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "latency", "com/android/tools/idea/avdmanager/AvdBuilder", "setNetworkLatency"));
        }
        this.myState.put(AvdWizardConstants.NETWORK_LATENCY_KEY, latency.toLowerCase());
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setNetworkLatency"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setNetworkSpeed(@NotNull String speed) {
        if (speed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "speed", "com/android/tools/idea/avdmanager/AvdBuilder", "setNetworkSpeed"));
        }
        this.myState.put(AvdWizardConstants.NETWORK_SPEED_KEY, speed.toLowerCase());
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setNetworkSpeed"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setDisplayName(@NotNull String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/android/tools/idea/avdmanager/AvdBuilder", "setDisplayName"));
        }
        this.myState.put(AvdWizardConstants.DISPLAY_NAME_KEY, displayName);
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setDisplayName"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdBuilder setSkinFile(@NotNull File skinFile) {
        if (skinFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skinFile", "com/android/tools/idea/avdmanager/AvdBuilder", "setSkinFile"));
        }
        this.myState.put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, skinFile);
        AvdBuilder avdBuilder = this;
        if (avdBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "setSkinFile"));
        }
        return avdBuilder;
    }

    @NotNull
    public AvdInfo build() throws AvdBuilderException {
        AvdInfo avd;
        if (this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY) == null) {
            throw new AvdBuilderException("No device specified. Call setDevice(manufacturer, id).");
        }
        if (this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY) == null) {
            if (this.myAbiType == null) {
                throw new AvdBuilderException("No ABI type specified. Call setAbiType(ABI)");
            }
            if (this.myApiString == null && this.myApiLevel == null) {
                throw new AvdBuilderException("No API level specified. Call setApiLevel(API)");
            }
            AvdWizardConstants.SystemImageDescription description = this.getSystemImageDescription();
            if (description == null) {
                description = this.installRequestedSystemImage();
            }
            if (description == null) {
                throw new AvdBuilderException(String.format(Locale.getDefault(), "Could not find a matching system image for ABI %1$s, API %2$d/%3$s", this.myAbiType, this.myApiLevel, this.myApiString));
            }
            this.myState.put(AvdWizardConstants.SYSTEM_IMAGE_KEY, description);
        }
        if ((avd = AvdEditWizard.createAvd(null, this.myState, true)) == null) {
            throw new AvdBuilderException("Could not create AVD");
        }
        AvdInfo avdInfo = avd;
        if (avdInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdBuilder", "build"));
        }
        return avdInfo;
    }

    @Nullable
    private AvdWizardConstants.SystemImageDescription installRequestedSystemImage() throws AvdBuilderException {
        ArrayList requestedPackages = Lists.newArrayListWithCapacity((int)3);
        AndroidVersion version = new AndroidVersion(this.myApiLevel.intValue(), this.myApiString);
        requestedPackages.add(PkgDesc.Builder.newSysImg((AndroidVersion)version, (IdDisplay)SystemImage.DEFAULT_TAG, (String)Abi.X86.toString(), (MajorRevision)new MajorRevision(1)).create());
        requestedPackages.add(PkgDesc.Builder.newSysImg((AndroidVersion)version, (IdDisplay)AvdWizardConstants.WEAR_TAG, (String)Abi.X86.toString(), (MajorRevision)new MajorRevision(1)).create());
        requestedPackages.add(PkgDesc.Builder.newSysImg((AndroidVersion)version, (IdDisplay)AvdWizardConstants.TV_TAG, (String)Abi.X86.toString(), (MajorRevision)new MajorRevision(1)).create());
        SdkQuickfixWizard sdkQuickfixWizard = new SdkQuickfixWizard(null, null, requestedPackages);
        sdkQuickfixWizard.init();
        sdkQuickfixWizard.showAndGet();
        return this.getSystemImageDescription();
    }

    @Nullable
    private AvdWizardConstants.SystemImageDescription getSystemImageDescription() throws AvdBuilderException {
        AndroidSdkData sdk = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdk == null) {
            throw new AvdBuilderException("No SDK found!");
        }
        sdk.getLocalSdk().clearLocalPkg(PkgType.PKG_ALL);
        AvdWizardConstants.SystemImageDescription description = null;
        ArrayList targets = Lists.newArrayList((Object[])sdk.getTargets());
        block0: for (IAndroidTarget target : targets) {
            ISystemImage[] systemImages;
            if (target.getVersion().getApiLevel() != this.myApiLevel.intValue() && (this.myApiString == null || !this.myApiString.equals(target.getVersion().getCodename())) || (systemImages = target.getSystemImages()) == null) continue;
            for (ISystemImage image : systemImages) {
                if (!image.getAbiType().equals(this.myAbiType.toString())) continue;
                description = new AvdWizardConstants.SystemImageDescription(target, image);
                continue block0;
            }
        }
        return description;
    }

    public static class AvdBuilderException
    extends Exception {
        public AvdBuilderException(String message) {
            super(message);
        }
    }
}

