/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.ConfigureDeviceOptionsStep;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.SingleStepPath;
import org.jetbrains.annotations.Nullable;

public class DeviceEditWizard
extends DynamicWizard {
    @Nullable
    private final Device myDeviceTemplate;
    private final boolean myForceCreation;

    public DeviceEditWizard(@Nullable Device deviceTemplate, boolean forceCreation) {
        super(null, null, "Create hardware profile");
        this.myDeviceTemplate = deviceTemplate;
        this.myForceCreation = forceCreation;
        this.setTitle("Hardware Profile Configuration");
    }

    @Override
    public void init() {
        this.addPath(new SingleStepPath(new ConfigureDeviceOptionsStep(this.myDeviceTemplate, this.myForceCreation, this.getDisposable())));
        super.init();
    }

    @Override
    public void performFinishingActions() {
        Device device = this.getState().get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        if (device != null) {
            DeviceManagerConnection.getDefaultDeviceManagerConnection().createOrEditDevice(device);
        }
    }

    @Override
    protected String getWizardActionDescription() {
        return "Create or edit a virtual device hardware profile";
    }
}

