/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.editors.navigation.NavigationView;
import com.android.tools.idea.rendering.RenderedView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.Nullable;

class HierarchyUtils {
    private static final Logger LOG = Logger.getInstance((String)HierarchyUtils.class.getName());

    HierarchyUtils() {
    }

    private static String getTagName(@Nullable RenderedView leaf) {
        if (leaf != null && leaf.tag != null) {
            return leaf.tag.getName();
        }
        return "null";
    }

    private static String getTagName(@Nullable ViewInfo leaf) {
        Object cookie;
        if (leaf != null && (cookie = leaf.getCookie()) instanceof XmlTag) {
            XmlTag tag = (XmlTag)cookie;
            return tag.getName();
        }
        return "null";
    }

    static void display(@Nullable RenderedView root) {
        if (root == null) {
            return;
        }
        new Object(){

            public void display(RenderedView view, String indent) {
                LOG.info(indent + HierarchyUtils.getTagName(view) + " " + NavigationView.getViewId(view));
                for (RenderedView c : view.getChildren()) {
                    this.display(c, "  " + indent);
                }
            }
        }.display(root, "");
    }

    static void display(@Nullable ViewInfo root) {
        if (root == null) {
            return;
        }
        new Object(){

            public void display(ViewInfo view, String indent) {
                LOG.info(indent + HierarchyUtils.getTagName(view) + " " + NavigationView.getViewId(view));
                for (ViewInfo c : view.getChildren()) {
                    this.display(c, ".." + indent);
                }
            }
        }.display(root, "");
    }
}

