/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.IdeaGradleProject;
import com.android.tools.idea.gradle.IdeaJavaProject;
import com.android.tools.idea.gradle.project.GradleModelVersionCheck;
import com.android.tools.idea.gradle.project.ProjectImportErrorHandler;
import com.android.tools.idea.gradle.project.SdkSync;
import com.android.tools.idea.gradle.service.notification.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class AndroidGradleProjectResolver
extends AbstractProjectResolverExtension {
    @NotNull
    private final ProjectImportErrorHandler myErrorHandler;

    public AndroidGradleProjectResolver() {
        this(new ProjectImportErrorHandler());
    }

    @VisibleForTesting
    AndroidGradleProjectResolver(@NotNull ProjectImportErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "<init>"));
        }
        this.myErrorHandler = errorHandler;
    }

    @NotNull
    public ModuleData createModule(@NotNull IdeaModule gradleModule, @NotNull ProjectData projectData) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "createModule"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "createModule"));
        }
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        if (androidProject != null && !GradleModelVersionCheck.isSupportedVersion(androidProject)) {
            String msg = AndroidGradleProjectResolver.getUnsupportedModelVersionErrorMsg(GradleModelVersionCheck.getModelVersion(androidProject));
            throw new IllegalStateException(msg);
        }
        ModuleData moduleData = this.nextResolver.createModule(gradleModule, projectData);
        if (moduleData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "createModule"));
        }
        return moduleData;
    }

    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        File gradleSettingsFile;
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleContentRoots"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleContentRoots"));
        }
        GradleScript buildScript = null;
        try {
            buildScript = gradleModule.getGradleProject().getBuildScript();
        }
        catch (UnsupportedOperationException ignore) {
            // empty catch block
        }
        if (buildScript == null || !this.inAndroidGradleProject(gradleModule)) {
            this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
            return;
        }
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)((ModuleData)ideModule.getData()).getModuleFilePath()));
        File moduleRootDirPath = moduleFilePath.getParentFile();
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        if (androidProject != null) {
            Variant selectedVariant = AndroidGradleProjectResolver.getVariantToSelect(androidProject);
            IdeaAndroidProject ideaAndroidProject = new IdeaAndroidProject(gradleModule.getName(), moduleRootDirPath, androidProject, selectedVariant.getName());
            ideModule.createChild(AndroidProjectKeys.IDE_ANDROID_PROJECT, (Object)ideaAndroidProject);
        }
        if ((gradleSettingsFile = new File(moduleRootDirPath, "settings.gradle")).isFile() && androidProject == null) {
            this.createJavaProject(gradleModule, ideModule);
            return;
        }
        File buildFilePath = buildScript.getSourceFile();
        IdeaGradleProject gradleProject = IdeaGradleProject.newIdeaGradleProject(gradleModule.getName(), gradleModule.getGradleProject(), buildFilePath);
        ideModule.createChild(AndroidProjectKeys.IDE_GRADLE_PROJECT, (Object)gradleProject);
        if (androidProject == null && AndroidGradleProjectResolver.isJavaProject(gradleModule)) {
            this.createJavaProject(gradleModule, ideModule);
        }
    }

    private static boolean isJavaProject(@NotNull IdeaModule gradleModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "isJavaProject"));
        }
        for (GradleTask task : gradleModule.getGradleProject().getTasks()) {
            if (!"compileJava".equals(task.getName())) continue;
            return true;
        }
        return false;
    }

    private void createJavaProject(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "createJavaProject"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "createJavaProject"));
        }
        ModuleExtendedModel model = (ModuleExtendedModel)this.resolverCtx.getExtraProject(gradleModule, ModuleExtendedModel.class);
        IdeaJavaProject javaProject = new IdeaJavaProject(gradleModule, model);
        ideModule.createChild(AndroidProjectKeys.IDE_JAVA_PROJECT, (Object)javaProject);
    }

    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleCompileOutputSettings"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleCompileOutputSettings"));
        }
        if (!this.inAndroidGradleProject(gradleModule)) {
            this.nextResolver.populateModuleCompileOutputSettings(gradleModule, ideModule);
        }
    }

    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleDependencies"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleDependencies"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleDependencies"));
        }
        if (!this.inAndroidGradleProject(gradleModule)) {
            this.nextResolver.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleExtraModels"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "populateModuleExtraModels"));
        }
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
        if (this.inAndroidGradleProject(gradleModule) && AndroidStudioSpecificInitializer.isAndroidStudio()) {
            HashSet classes = Sets.newHashSet();
            HashSet sources = Sets.newHashSet();
            for (File jarPath : AndroidGradleProjectResolver.findAndroidGradlePluginJarPaths()) {
                String jarName = jarPath.getName();
                if (jarName.endsWith("sources.jar")) {
                    sources.add(jarPath.getPath());
                    continue;
                }
                if (!jarName.endsWith(".jar")) continue;
                classes.add(jarPath.getPath());
            }
            if (!classes.isEmpty()) {
                BuildScriptClasspathData.ClasspathEntry classpathEntry = new BuildScriptClasspathData.ClasspathEntry((Set)classes, (Set)sources, Collections.emptySet());
                List<BuildScriptClasspathData.ClasspathEntry> classpathEntries = Collections.singletonList(classpathEntry);
                BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
                ideModule.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
            }
        }
    }

    @NotNull
    private static List<File> findAndroidGradlePluginJarPaths() {
        File parentPath;
        File repoPath = GradleUtil.getAndroidStudioLocalMavenRepoPath();
        if (repoPath != null && (parentPath = new File(repoPath, FileUtil.join((String[])new String[]{"com", "android", "tools", "build"}))).isDirectory()) {
            ArrayList paths = Lists.newArrayList();
            paths.addAll(AndroidGradleProjectResolver.findAndroidGradlePluginJarPaths(parentPath, "builder"));
            paths.addAll(AndroidGradleProjectResolver.findAndroidGradlePluginJarPaths(parentPath, "builder-model"));
            paths.addAll(AndroidGradleProjectResolver.findAndroidGradlePluginJarPaths(parentPath, "gradle"));
            ArrayList arrayList = paths;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "findAndroidGradlePluginJarPaths"));
            }
            return arrayList;
        }
        List<File> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "findAndroidGradlePluginJarPaths"));
        }
        return list;
    }

    @NotNull
    private static List<File> findAndroidGradlePluginJarPaths(@NotNull File parentPath, @NotNull String artifactId) {
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "findAndroidGradlePluginJarPaths"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "findAndroidGradlePluginJarPaths"));
        }
        File artifactPath = new File(parentPath, artifactId);
        if (artifactPath.isDirectory()) {
            for (File versionDirPath : FileUtil.notNullize((File[])artifactPath.listFiles())) {
                File[] files = FileUtil.notNullize((File[])versionDirPath.listFiles());
                if (files.length <= 0) continue;
                List<File> list = Arrays.asList(files);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "findAndroidGradlePluginJarPaths"));
                }
                return list;
            }
        }
        List<File> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "findAndroidGradlePluginJarPaths"));
        }
        return list;
    }

    private boolean inAndroidGradleProject(@NotNull IdeaModule gradleModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "inAndroidGradleProject"));
        }
        if (!this.resolverCtx.findModulesWithModel(AndroidProject.class).isEmpty()) {
            return true;
        }
        return "buildSrc".equals(gradleModule.getGradleProject().getName()) && AndroidStudioSpecificInitializer.isAndroidStudio();
    }

    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        HashSet hashSet = Sets.newHashSet((Object[])new Class[]{AndroidProject.class});
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getExtraProjectModelClasses"));
        }
        return hashSet;
    }

    public void preImportCheck() {
        Application application;
        Runnable task;
        if (AndroidPlugin.isGuiTestingMode() && (task = (Runnable)(application = ApplicationManager.getApplication()).getUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_SYNC_TASK_IN_GUI_TEST_KEY)) != null) {
            application.putUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_SYNC_TASK_IN_GUI_TEST_KEY, null);
            task.run();
        }
        if (AndroidStudioSpecificInitializer.isAndroidStudio()) {
            LocalProperties localProperties = this.getLocalProperties();
            SdkSync.syncIdeAndProjectAndroidHomes(localProperties);
        }
    }

    @NotNull
    public List<KeyValue<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            File androidHomePath;
            LocalProperties localProperties;
            ArrayList args = Lists.newArrayList();
            if (!AndroidStudioSpecificInitializer.isAndroidStudio() && (localProperties = this.getLocalProperties()).getAndroidSdkPath() == null && (androidHomePath = DefaultSdks.getDefaultAndroidHome()) != null) {
                args.add(KeyValue.create((Object)"android.home", (Object)androidHomePath.getPath()));
            }
            ArrayList arrayList = args;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getExtraJvmArgs"));
            }
            return arrayList;
        }
        List<KeyValue<String, String>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getExtraJvmArgs"));
        }
        return list;
    }

    @NotNull
    public List<String> getExtraCommandLineArgs() {
        String[] commandLineOptions;
        ArrayList args = Lists.newArrayList();
        Project project = this.findProject();
        if (project != null && (commandLineOptions = (String[])project.getUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY)) != null) {
            project.putUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY, null);
            Collections.addAll(args, commandLineOptions);
        }
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
        if (AndroidPlugin.isGuiTestingMode()) {
            ApplicationManager.getApplication().putUserData(AndroidPlugin.GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY, (Object)ArrayUtil.toStringArray((Collection)args));
        }
        GradleUtil.addLocalMavenRepoInitScriptCommandLineOption(args);
        ArrayList arrayList = args;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getExtraCommandLineArgs"));
        }
        return arrayList;
    }

    @Nullable
    private Project findProject() {
        String projectDir = this.resolverCtx.getProjectPath();
        if (StringUtil.isNotEmpty((String)projectDir)) {
            Project[] projects;
            File projectDirPath = new File(FileUtil.toSystemDependentName((String)projectDir));
            for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                File currentPath = new File(project.getBasePath());
                if (!FileUtil.filesEqual((File)projectDirPath, (File)currentPath)) continue;
                return project;
            }
        }
        return null;
    }

    @NotNull
    private LocalProperties getLocalProperties() {
        LocalProperties localProperties;
        block2: {
            File projectDir = new File(FileUtil.toSystemDependentName((String)this.resolverCtx.getProjectPath()));
            try {
                localProperties = new LocalProperties(projectDir);
                if (localProperties != null) break block2;
            }
            catch (IOException e) {
                String msg = String.format("Unable to read local.properties file in project '%1$s'", projectDir.getPath());
                throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getLocalProperties"));
        }
        return localProperties;
    }

    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        Throwable rootCause;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getUserFriendlyError"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getUserFriendlyError"));
        }
        String msg = error.getMessage();
        if (msg != null && !msg.contains("The project is using an unsupported version of the Android Gradle plug-in") && (rootCause = ExceptionUtil.getRootCause((Throwable)error)) instanceof ClassNotFoundException && ("org.gradle.api.artifacts.result.ResolvedComponentResult".equals(msg = rootCause.getMessage()) || "org.gradle.api.artifacts.result.ResolvedModuleVersionResult".equals(msg))) {
            ExternalSystemException externalSystemException = new ExternalSystemException("The project is using an unsupported version of Gradle.");
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        ExternalSystemException userFriendlyError = this.myErrorHandler.getUserFriendlyError(error, projectPath, buildFilePath);
        ExternalSystemException externalSystemException = userFriendlyError != null ? userFriendlyError : this.nextResolver.getUserFriendlyError(error, projectPath, buildFilePath);
        if (externalSystemException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getUserFriendlyError"));
        }
        return externalSystemException;
    }

    @NotNull
    private static String getUnsupportedModelVersionErrorMsg(@Nullable FullRevision modelVersion) {
        StringBuilder builder = new StringBuilder();
        builder.append("The project is using an unsupported version of the Android Gradle plug-in");
        String recommendedVersion = String.format("The recommended version is %1$s.", "1.0.0");
        if (modelVersion != null) {
            builder.append(String.format(" (%1$s).", modelVersion.toString())).append(" ").append(recommendedVersion);
            if (modelVersion.getMajor() == 0 && modelVersion.getMinor() <= 8) {
                builder.append("\n\nStarting with version 0.9.0 incompatible changes were introduced in the build language.\n").append("Please read the migration guide").append(" to learn how to update your project.");
            }
        } else {
            builder.append(". ").append(recommendedVersion);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getUnsupportedModelVersionErrorMsg"));
        }
        return string;
    }

    @NotNull
    private static Variant getVariantToSelect(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getVariantToSelect"));
        }
        Collection variants = androidProject.getVariants();
        if (variants.size() == 1) {
            Variant variant = (Variant)ContainerUtil.getFirstItem((Collection)variants);
            assert (variant != null);
            Variant variant2 = variant;
            if (variant2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getVariantToSelect"));
            }
            return variant2;
        }
        for (Variant variant : variants) {
            if (!"debug".equals(variant.getName())) continue;
            Variant variant3 = variant;
            if (variant3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getVariantToSelect"));
            }
            return variant3;
        }
        ArrayList sortedVariants = Lists.newArrayList((Iterable)variants);
        Collections.sort(sortedVariants, new Comparator<Variant>(){

            @Override
            public int compare(Variant o1, Variant o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Variant variant = (Variant)sortedVariants.get(0);
        if (variant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "getVariantToSelect"));
        }
        return variant;
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/android/tools/idea/gradle/project/AndroidGradleProjectResolver", "enhanceRemoteProcessing"));
        }
        ArrayList classPath = ContainerUtilRt.newArrayList();
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()), (Collection)classPath);
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(FullRevision.class), (Collection)classPath);
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(AndroidGradleSettings.class), (Collection)classPath);
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(AndroidProject.class), (Collection)classPath);
        parameters.getClassPath().addAll((List)classPath);
    }
}

