/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.messages.AbstractNavigatable;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.structure.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ProjectBuilder;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.profiles.ProjectProfileSelectionDialog;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.android.tools.idea.templates.TemplateManager;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class PostProjectSetupTasksExecutor {
    private static final String SOURCES_JAR_NAME_SUFFIX = "-sources.jar";
    private static boolean ourSdkVersionWarningShown;
    @NotNull
    private final Project myProject;
    private static final boolean DEFAULT_GENERATE_SOURCES_AFTER_SYNC = true;
    private volatile boolean myGenerateSourcesAfterSync;

    @NotNull
    public static PostProjectSetupTasksExecutor getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "getInstance"));
        }
        PostProjectSetupTasksExecutor postProjectSetupTasksExecutor = (PostProjectSetupTasksExecutor)ServiceManager.getService((Project)project, PostProjectSetupTasksExecutor.class);
        if (postProjectSetupTasksExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "getInstance"));
        }
        return postProjectSetupTasksExecutor;
    }

    public PostProjectSetupTasksExecutor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "<init>"));
        }
        this.myGenerateSourcesAfterSync = true;
        this.myProject = project;
    }

    public void onProjectRestoreFromDisk() {
        this.ensureValidSdks();
        if (Projects.hasErrors(this.myProject)) {
            this.addSdkLinkIfNecessary();
            PostProjectSetupTasksExecutor.checkSdkVersion(this.myProject);
            return;
        }
        this.findAndShowVariantConflicts();
        this.addSdkLinkIfNecessary();
        PostProjectSetupTasksExecutor.checkSdkVersion(this.myProject);
        TemplateManager.getInstance().refreshDynamicTemplateMenu(this.myProject);
    }

    public void ensureValidSdks() {
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(this.myProject);
        boolean checkJdkVersion = true;
        HashSet invalidAndroidSdks = Sets.newHashSet();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet != null && androidFacet.getIdeaAndroidProject() != null) {
                Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (sdk != null && !invalidAndroidSdks.contains(sdk) && (PostProjectSetupTasksExecutor.isMissingAndroidLibrary(sdk) || PostProjectSetupTasksExecutor.shouldRemoveAnnotationsJar(sdk))) {
                    AndroidSdkAdditionalData additionalData = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
                    AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
                    if (additionalData != null && sdkData != null) {
                        IAndroidTarget target = additionalData.getBuildTarget(sdkData);
                        if (target == null) {
                            LocalSdk localSdk = sdkData.getLocalSdk();
                            localSdk.clearLocalPkg(EnumSet.of(PkgType.PKG_PLATFORM));
                            target = localSdk.getTargetFromHashString(additionalData.getBuildTargetHashString());
                        }
                        if (target != null) {
                            SdkModificator sdkModificator = sdk.getSdkModificator();
                            sdkModificator.removeAllRoots();
                            for (OrderRoot orderRoot : AndroidSdkUtils.getLibraryRootsForTarget(target, sdk.getHomePath(), true)) {
                                sdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
                            }
                            ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
                            sdkModificator.commitChanges();
                        }
                    }
                    if (PostProjectSetupTasksExecutor.isMissingAndroidLibrary(sdk)) {
                        invalidAndroidSdks.add(sdk);
                    }
                }
                IdeaAndroidProject androidProject = androidFacet.getIdeaAndroidProject();
                Collection unresolved = androidProject.getDelegate().getUnresolvedDependencies();
                messages.reportUnresolvedDependencies(unresolved, module);
                if (!checkJdkVersion || this.hasCorrectJdkVersion(module, androidProject)) continue;
                checkJdkVersion = false;
                continue;
            }
            JavaGradleFacet javaFacet = JavaGradleFacet.getInstance(module);
            if (javaFacet == null || javaFacet.getJavaModel() == null) continue;
            List<String> unresolved = javaFacet.getJavaModel().getUnresolvedDependencyNames();
            messages.reportUnresolvedDependencies(unresolved, module);
        }
        if (!invalidAndroidSdks.isEmpty()) {
            this.reinstallMissingPlatforms(invalidAndroidSdks);
        }
    }

    private static boolean isMissingAndroidLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "isMissingAndroidLibrary"));
        }
        if (AndroidSdkUtils.isAndroidSdk(sdk)) {
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("android.jar") || !library.exists()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean shouldRemoveAnnotationsJar(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "shouldRemoveAnnotationsJar"));
        }
        if (AndroidSdkUtils.isAndroidSdk(sdk)) {
            IAndroidTarget target;
            AndroidSdkAdditionalData additionalData = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
            boolean needsAnnotationJar = false;
            if (additionalData != null && sdkData != null && (target = additionalData.getBuildTarget(sdkData)) != null) {
                needsAnnotationJar = target.getVersion().getApiLevel() <= 15;
            }
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("annotations.jar") || !library.exists() || needsAnnotationJar) continue;
                return true;
            }
        }
        return false;
    }

    private void reinstallMissingPlatforms(@NotNull Collection<Sdk> invalidAndroidSdks) {
        if (invalidAndroidSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidAndroidSdks", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "reinstallMissingPlatforms"));
        }
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(this.myProject);
        ArrayList versionsToInstall = Lists.newArrayList();
        ArrayList missingPlatforms = Lists.newArrayList();
        for (Sdk sdk : invalidAndroidSdks) {
            String platform;
            SdkAdditionalData additionalData = sdk.getSdkAdditionalData();
            if (!(additionalData instanceof AndroidSdkAdditionalData) || (platform = ((AndroidSdkAdditionalData)additionalData).getBuildTargetHashString()) == null) continue;
            missingPlatforms.add("'" + platform + "'");
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)platform);
            if (version == null) continue;
            versionsToInstall.add(version);
        }
        if (!versionsToInstall.isEmpty()) {
            String group = String.format("Failed to sync Gradle project '%1$s'", this.myProject.getName());
            String text = "Missing Android platform(s) detected: " + Joiner.on((String)", ").join((Iterable)missingPlatforms);
            Message msg = new Message(group, Message.Type.ERROR, text);
            messages.add(msg, new InstallPlatformHyperlink(versionsToInstall.toArray(new AndroidVersion[versionsToInstall.size()])));
        }
    }

    public void onProjectSyncCompletion() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            if (!this.hasCorrectJdkVersion(module)) break;
        }
        if (Projects.hasErrors(this.myProject)) {
            this.addSdkLinkIfNecessary();
            PostProjectSetupTasksExecutor.checkSdkVersion(this.myProject);
            GradleSyncState.getInstance(this.myProject).syncEnded();
            return;
        }
        this.attachSourcesToLibraries();
        this.ensureAllModulesHaveValidSdks();
        Projects.enforceExternalBuild(this.myProject);
        if (AndroidStudioSpecificInitializer.isAndroidStudio()) {
            this.removeModulesNotInGradleSettingsFile();
        } else {
            AndroidGradleProjectComponent.getInstance(this.myProject).checkForSupportedModules();
        }
        this.findAndShowVariantConflicts();
        PostProjectSetupTasksExecutor.checkSdkVersion(this.myProject);
        this.addSdkLinkIfNecessary();
        ProjectResourceRepository.moduleRootsChanged(this.myProject);
        GradleSyncState.getInstance(this.myProject).syncEnded();
        if (this.myGenerateSourcesAfterSync) {
            ProjectBuilder.getInstance(this.myProject).generateSourcesOnly();
        } else {
            this.myGenerateSourcesAfterSync = true;
        }
        this.ensureValidSdks();
        TemplateManager.getInstance().refreshDynamicTemplateMenu(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureAllModulesHaveValidSdks() {
        HashSet androidSdks = Sets.newHashSet();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            ModifiableRootModel model = moduleRootManager.getModifiableModel();
            Sdk sdk = model.getSdk();
            if (sdk != null) {
                if (AndroidSdkUtils.isAndroidSdk(sdk)) {
                    androidSdks.add(sdk);
                }
                model.dispose();
                continue;
            }
            try {
                Sdk jdk = DefaultSdks.getDefaultJdk();
                model.setSdk(jdk);
            }
            finally {
                model.commit();
            }
        }
        for (Sdk sdk : androidSdks) {
            PostProjectSetupTasksExecutor.refreshLibrariesIn(sdk);
        }
    }

    private static void refreshLibrariesIn(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "refreshLibrariesIn"));
        }
        VirtualFile[] libraries = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        sdkModificator = sdk.getSdkModificator();
        for (VirtualFile library : libraries) {
            sdkModificator.addRoot(library, OrderRootType.CLASSES);
        }
        sdkModificator.commitChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachSourcesToLibraries() {
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)this.myProject);
        block3: for (Library library : libraryTable.getLibraries()) {
            if (library.getFiles(OrderRootType.SOURCES).length > 0) continue;
            for (VirtualFile classFile : library.getFiles(OrderRootType.CLASSES)) {
                VirtualFile sourceJar = PostProjectSetupTasksExecutor.findSourceJarForJar(classFile);
                if (sourceJar == null) continue;
                Library.ModifiableModel model = library.getModifiableModel();
                try {
                    String url = AbstractDependenciesModuleCustomizer.pathToUrl(sourceJar.getPath());
                    model.addRoot(url, OrderRootType.SOURCES);
                    continue block3;
                }
                finally {
                    model.commit();
                }
            }
        }
    }

    @Nullable
    private static VirtualFile findSourceJarForJar(@NotNull VirtualFile jarFile) {
        if (jarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFile", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "findSourceJarForJar"));
        }
        File jarFilePath = PostProjectSetupTasksExecutor.getJarFromJarUrl(jarFile.getUrl());
        if (jarFilePath == null) {
            return null;
        }
        File sourceJarPath = PostProjectSetupTasksExecutor.getSourceJarForAndroidSupportAar(jarFilePath);
        if (sourceJarPath != null) {
            return VfsUtil.findFileByIoFile((File)sourceJarPath, (boolean)true);
        }
        VirtualFile realJarFile = VfsUtil.findFileByIoFile((File)jarFilePath, (boolean)true);
        if (realJarFile == null) {
            return null;
        }
        VirtualFile parent = realJarFile.getParent();
        String sourceFileName = jarFile.getNameWithoutExtension() + SOURCES_JAR_NAME_SUFFIX;
        if (parent != null) {
            VirtualFile sourceJar = parent.findChild(sourceFileName);
            if (sourceJar != null) {
                return sourceJar;
            }
            if ((parent = parent.getParent()) != null) {
                for (VirtualFile child : parent.getChildren()) {
                    if (!child.isDirectory() || (sourceJar = child.findChild(sourceFileName)) == null) continue;
                    return sourceJar;
                }
            }
        }
        File librarySourceDirPath = InternetAttachSourceProvider.getLibrarySourceDir();
        File sourceJar = new File(librarySourceDirPath, sourceFileName);
        return VfsUtil.findFileByIoFile((File)sourceJar, (boolean)true);
    }

    @Nullable
    private static File getSourceJarForAndroidSupportAar(@NotNull File jarFilePath) {
        File androidHomePath;
        File repositoryLocation;
        String groupId;
        if (jarFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFilePath", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "getSourceJarForAndroidSupportAar"));
        }
        String path = jarFilePath.getPath();
        if (!path.contains("com.android.support")) {
            return null;
        }
        int startingIndex = -1;
        List pathSegments = FileUtil.splitPath((String)jarFilePath.getParentFile().getPath());
        int segmentCount = pathSegments.size();
        for (int i = 0; i < segmentCount; ++i) {
            if (!"exploded-aar".equals(pathSegments.get(i))) continue;
            startingIndex = i + 1;
            break;
        }
        if (startingIndex == -1 || startingIndex >= segmentCount) {
            return null;
        }
        ArrayList sourceJarRelativePath = Lists.newArrayList();
        if ("com.android.support".equals(groupId = (String)pathSegments.get(startingIndex++)) && (repositoryLocation = SdkMavenRepository.ANDROID.getRepositoryLocation(androidHomePath = DefaultSdks.getDefaultAndroidHome(), true)) != null) {
            sourceJarRelativePath.addAll(Splitter.on((char)'.').splitToList((CharSequence)groupId));
            String artifactId = (String)pathSegments.get(startingIndex++);
            sourceJarRelativePath.add(artifactId);
            String version = (String)pathSegments.get(startingIndex);
            sourceJarRelativePath.add(version);
            String sourceJarName = artifactId + "-" + version + SOURCES_JAR_NAME_SUFFIX;
            sourceJarRelativePath.add(sourceJarName);
            File sourceJar = new File(repositoryLocation, FileUtil.join((String[])ArrayUtil.toStringArray((Collection)sourceJarRelativePath)));
            return sourceJar.isFile() ? sourceJar : null;
        }
        return null;
    }

    @Nullable
    private static File getJarFromJarUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "getJarFromJarUrl"));
        }
        if (!url.startsWith("jar://")) {
            return null;
        }
        String path = url.substring("jar://".length());
        int index = path.lastIndexOf("!/");
        if (index != -1) {
            path = path.substring(0, index);
        }
        return new File(FileUtil.toSystemDependentName((String)path));
    }

    private void removeModulesNotInGradleSettingsFile() {
        GradleSettingsFile gradleSettingsFile = GradleSettingsFile.get(this.myProject);
        final ArrayList modulesToRemove = Lists.newArrayList();
        final ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] modules = moduleManager.getModules();
        if (gradleSettingsFile == null) {
            if (modules.length == 1) {
                return;
            }
            boolean topLevelModuleFound = false;
            for (Module module : modules) {
                if (!topLevelModuleFound && PostProjectSetupTasksExecutor.isTopLevel(module)) {
                    topLevelModuleFound = true;
                    continue;
                }
                modulesToRemove.add(module);
            }
        } else {
            for (Module module : modules) {
                if (!PostProjectSetupTasksExecutor.isNonGradleModule(module) && !PostProjectSetupTasksExecutor.isOrphanGradleModule(module, gradleSettingsFile)) continue;
                modulesToRemove.add(module);
            }
        }
        if (!modulesToRemove.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ModifiableModuleModel moduleModel = moduleManager.getModifiableModel();
                    try {
                        for (Module module : modulesToRemove) {
                            PostProjectSetupTasksExecutor.removeDependencyLinks(module, moduleManager);
                            moduleModel.disposeModule(module);
                        }
                    }
                    finally {
                        moduleModel.commit();
                    }
                }
            });
        }
    }

    private static boolean isNonGradleModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "isNonGradleModule"));
        }
        ModuleType moduleType = ModuleType.get((Module)module);
        if (moduleType instanceof JavaModuleType) {
            String externalSystemId = module.getOptionValue("external.system.id");
            return !GradleConstants.SYSTEM_ID.getId().equals(externalSystemId);
        }
        return false;
    }

    private static boolean isOrphanGradleModule(@NotNull Module module, @NotNull GradleSettingsFile settingsFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "isOrphanGradleModule"));
        }
        if (settingsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsFile", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "isOrphanGradleModule"));
        }
        if (PostProjectSetupTasksExecutor.isTopLevel(module)) {
            return false;
        }
        AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
        if (facet == null) {
            return true;
        }
        String gradleProjectPath = ((AndroidGradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH;
        Iterable<String> allModules = settingsFile.getModules();
        return !Iterables.contains(allModules, (Object)gradleProjectPath);
    }

    private static boolean isTopLevel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "isTopLevel"));
        }
        AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
        if (facet == null) {
            String moduleRootDirPath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath())).getParent();
            return moduleRootDirPath.equals(module.getProject().getBasePath());
        }
        String gradleProjectPath = ((AndroidGradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH;
        return ":".equals(gradleProjectPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeDependencyLinks(@NotNull Module module, @NotNull ModuleManager moduleManager) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "removeDependencyLinks"));
        }
        if (moduleManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleManager", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "removeDependencyLinks"));
        }
        List dependents = moduleManager.getModuleDependentModules(module);
        for (Module dependent : dependents) {
            if (dependent.isDisposed()) continue;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)dependent);
            ModifiableRootModel modifiableModel = moduleRootManager.getModifiableModel();
            try {
                for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                    Module orderEntryModule;
                    if (!(orderEntry instanceof ModuleOrderEntry) || !module.equals(orderEntryModule = ((ModuleOrderEntry)orderEntry).getModule())) continue;
                    modifiableModel.removeOrderEntry(orderEntry);
                }
            }
            finally {
                modifiableModel.commit();
            }
        }
    }

    private void findAndShowVariantConflicts() {
        boolean atLeastOneSolved;
        List<Conflict> selectionConflicts;
        ConflictSet conflicts = ConflictSet.findConflicts(this.myProject);
        List<Conflict> structureConflicts = conflicts.getStructureConflicts();
        if (!structureConflicts.isEmpty() && SystemProperties.getBooleanProperty((String)"enable.project.profiles", (boolean)false)) {
            ProjectProfileSelectionDialog dialog = new ProjectProfileSelectionDialog(this.myProject, structureConflicts);
            dialog.show();
        }
        if (!(selectionConflicts = conflicts.getSelectionConflicts()).isEmpty() && (atLeastOneSolved = ConflictResolution.solveSelectionConflicts(selectionConflicts))) {
            conflicts = ConflictSet.findConflicts(this.myProject);
        }
        conflicts.showSelectionConflicts();
    }

    private void addSdkLinkIfNecessary() {
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(this.myProject);
        int sdkErrorCount = messages.getMessageCount("Failed to set up SDK");
        if (sdkErrorCount > 0) {
            String text = "Open Android SDK Manager and install all missing platforms.";
            Message hint = new Message("Failed to set up SDK", Message.Type.INFO, AbstractNavigatable.NOT_NAVIGATABLE, text);
            messages.add(hint, new OpenAndroidSdkManagerHyperlink());
        }
    }

    private static void checkSdkVersion(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "checkSdkVersion"));
        }
        if (project.isDisposed() || ourSdkVersionWarningShown) {
            return;
        }
        File androidHome = DefaultSdks.getDefaultAndroidHome();
        if (androidHome != null && !VersionCheck.isCompatibleVersion(androidHome)) {
            InstallSdkToolsHyperlink hyperlink = new InstallSdkToolsHyperlink(VersionCheck.MIN_TOOLS_REV);
            String message = "Version " + VersionCheck.MIN_TOOLS_REV + " is available.";
            AndroidGradleNotification.getInstance(project).showBalloon("Android SDK Tools", message, NotificationType.INFORMATION, hyperlink);
            ourSdkVersionWarningShown = true;
        }
    }

    private boolean hasCorrectJdkVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "hasCorrectJdkVersion"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && facet.getIdeaAndroidProject() != null) {
            return this.hasCorrectJdkVersion(module, facet.getIdeaAndroidProject());
        }
        return true;
    }

    private boolean hasCorrectJdkVersion(@NotNull Module module, @NotNull IdeaAndroidProject model) {
        Sdk jdk;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "hasCorrectJdkVersion"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "hasCorrectJdkVersion"));
        }
        AndroidProject androidProject = model.getDelegate();
        String compileTarget = androidProject.getCompileTarget();
        if (("android-L".equals(compileTarget) || "android-21".equals(compileTarget)) && (jdk = DefaultSdks.getDefaultJdk()) != null && !Jdks.isApplicableJdk(jdk, LanguageLevel.JDK_1_7)) {
            Message msg;
            ArrayList hyperlinks = Lists.newArrayList();
            ProjectSettingsService service = ProjectSettingsService.getInstance((Project)this.myProject);
            if (service instanceof AndroidProjectSettingsService) {
                hyperlinks.add(new OpenSdkSettingsHyperlink((AndroidProjectSettingsService)service));
            }
            String text = "compileSdkVersion " + compileTarget + " requires compiling with JDK 7";
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
            if (buildFile != null) {
                hyperlinks.add(new OpenFileHyperlink(buildFile.getPath()));
                msg = new Message(this.myProject, "Project Configuration", Message.Type.ERROR, buildFile, -1, -1, text);
            } else {
                msg = new Message("Project Configuration", Message.Type.ERROR, AbstractNavigatable.NOT_NAVIGATABLE, text);
            }
            ProjectSyncMessages messages = ProjectSyncMessages.getInstance(this.myProject);
            messages.add(msg, hyperlinks.toArray(new NotificationHyperlink[hyperlinks.size()]));
            this.myProject.putUserData(Projects.HAS_WRONG_JDK, (Object)true);
            return false;
        }
        return true;
    }

    public void setGenerateSourcesAfterSync(boolean generateSourcesAfterSync) {
        this.myGenerateSourcesAfterSync = generateSourcesAfterSync;
    }

    private static class InstallSdkToolsHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final FullRevision myVersion;

        InstallSdkToolsHyperlink(@NotNull FullRevision version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor$InstallSdkToolsHyperlink", "<init>"));
            }
            super("install.build.tools", "Install Tools " + version);
            this.myVersion = version;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor$InstallSdkToolsHyperlink", "execute"));
            }
            ArrayList requested = Lists.newArrayList();
            if (this.myVersion.getMajor() == 23) {
                FullRevision minBuildToolsRev = new FullRevision(20, 0, 0);
                requested.add(PkgDesc.Builder.newPlatformTool((FullRevision)minBuildToolsRev).create());
            }
            requested.add(PkgDesc.Builder.newTool((FullRevision)this.myVersion, (FullRevision)this.myVersion).create());
            SdkQuickfixWizard wizard = new SdkQuickfixWizard(project, null, requested);
            wizard.init();
            if (wizard.showAndGet()) {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
        }
    }

    private static class OpenSdkSettingsHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final AndroidProjectSettingsService mySettingsService;

        OpenSdkSettingsHyperlink(@NotNull AndroidProjectSettingsService settingsService) {
            if (settingsService == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsService", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor$OpenSdkSettingsHyperlink", "<init>"));
            }
            super("open.sdk.settings", "Open SDK Settings");
            this.mySettingsService = settingsService;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor$OpenSdkSettingsHyperlink", "execute"));
            }
            this.mySettingsService.openSdkSettings();
        }
    }
}

