/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathsList;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParameters
extends SimpleJavaParameters {
    private static final Logger LOG = Logger.getInstance(JavaParameters.class);
    private static final String JAVA_LIBRARY_PATH_PROPERTY = "java.library.path";
    public static final DataKey<JavaParameters> JAVA_PARAMETERS = DataKey.create("javaParameters");
    public static final int JDK_ONLY = 1;
    public static final int CLASSES_ONLY = 2;
    private static final int TESTS_ONLY = 4;
    public static final int JDK_AND_CLASSES = 3;
    public static final int JDK_AND_CLASSES_AND_TESTS = 7;
    public static final int CLASSES_AND_TESTS = 6;

    public String getJdkPath() throws CantRunException {
        Sdk jdk = this.getJdk();
        if (jdk == null) {
            throw new CantRunException(ExecutionBundle.message("no.jdk.specified..error.message", new Object[0]));
        }
        String jdkHome = jdk.getHomeDirectory().getPresentableUrl();
        if (jdkHome.isEmpty()) {
            throw new CantRunException(ExecutionBundle.message("home.directory.not.specified.for.jdk.error.message", new Object[0]));
        }
        return jdkHome;
    }

    public void configureByModule(Module module, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        this.setDefaultCharset(module.getProject());
        JavaParameters.configureEnumerator(OrderEnumerator.orderEntries(module).runtimeOnly().recursively(), classPathType, jdk).collectPaths(this.getClassPath());
        this.configureJavaLibraryPath(OrderEnumerator.orderEntries(module).recursively());
    }

    private void configureJavaLibraryPath(OrderEnumerator enumerator) {
        PathsList pathsList = new PathsList();
        enumerator.runtimeOnly().withoutSdk().roots(NativeLibraryOrderRootType.getInstance()).collectPaths(pathsList);
        if (!pathsList.getPathList().isEmpty()) {
            ParametersList vmParameters = this.getVMParametersList();
            if (vmParameters.hasProperty(JAVA_LIBRARY_PATH_PROPERTY)) {
                LOG.info("java.library.path property is already specified, native library paths from dependencies (" + pathsList.getPathsString() + ") won't be added");
            } else {
                vmParameters.addProperty(JAVA_LIBRARY_PATH_PROPERTY, pathsList.getPathsString());
            }
        }
    }

    @Nullable
    private static NotNullFunction<OrderEntry, VirtualFile[]> computeRootProvider(int classPathType, final Sdk jdk) {
        return (classPathType & 1) == 0 ? null : new NotNullFunction<OrderEntry, VirtualFile[]>(){

            @NotNull
            public VirtualFile[] fun(OrderEntry orderEntry) {
                if (orderEntry instanceof JdkOrderEntry) {
                    VirtualFile[] virtualFileArray = jdk.getRootProvider().getFiles(OrderRootType.CLASSES);
                    if (virtualFileArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/JavaParameters$1", "fun"));
                    }
                    return virtualFileArray;
                }
                VirtualFile[] virtualFileArray = orderEntry.getFiles(OrderRootType.CLASSES);
                if (virtualFileArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/JavaParameters$1", "fun"));
                }
                return virtualFileArray;
            }
        };
    }

    public void setDefaultCharset(Project project) {
        Charset encoding = EncodingProjectManager.getInstance(project).getDefaultCharset();
        if (encoding != null) {
            this.setCharset(encoding);
        }
    }

    public void configureByModule(Module module, int classPathType) throws CantRunException {
        this.configureByModule(module, classPathType, JavaParameters.getModuleJdk(module));
    }

    public static Sdk getModuleJdk(Module module) throws CantRunException {
        Sdk jdk = ModuleRootManager.getInstance(module).getSdk();
        if (jdk == null) {
            throw CantRunException.noJdkForModule(module);
        }
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null || !homeDirectory.isValid()) {
            throw CantRunException.jdkMisconfigured(jdk, module);
        }
        return jdk;
    }

    public void configureByProject(Project project, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        this.setDefaultCharset(project);
        JavaParameters.configureEnumerator(OrderEnumerator.orderEntries(project).runtimeOnly(), classPathType, jdk).collectPaths(this.getClassPath());
        this.configureJavaLibraryPath(OrderEnumerator.orderEntries(project));
    }

    private static OrderRootsEnumerator configureEnumerator(OrderEnumerator enumerator, int classPathType, Sdk jdk) {
        if ((classPathType & 1) == 0) {
            enumerator = enumerator.withoutSdk();
        }
        if ((classPathType & 4) == 0) {
            enumerator = enumerator.productionOnly();
        }
        OrderRootsEnumerator rootsEnumerator = enumerator.classes();
        NotNullFunction<OrderEntry, VirtualFile[]> provider = JavaParameters.computeRootProvider(classPathType, jdk);
        if (provider != null) {
            rootsEnumerator = rootsEnumerator.usingCustomRootProvider(provider);
        }
        return rootsEnumerator;
    }
}

