/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Url;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class WebBrowserService {
    public static WebBrowserService getInstance() {
        return ServiceManager.getService(WebBrowserService.class);
    }

    @NotNull
    public abstract Collection<Url> getUrlsToOpen(@NotNull OpenInBrowserRequest var1, boolean var2) throws WebBrowserUrlProvider.BrowserException;

    @NotNull
    public Collection<Url> getUrlsToOpen(@NotNull PsiElement element, boolean preferLocalUrl) throws WebBrowserUrlProvider.BrowserException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/browsers/WebBrowserService", "getUrlsToOpen"));
        }
        OpenInBrowserRequest request = OpenInBrowserRequest.create(element);
        Collection<Url> collection = request == null ? Collections.emptyList() : this.getUrlsToOpen(request, preferLocalUrl);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserService", "getUrlsToOpen"));
        }
        return collection;
    }
}

