/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VisualPosition {
    public final int line;
    public final int column;

    public VisualPosition(int line, int column) {
        if (line < 0) {
            throw new IllegalArgumentException("line must be non negative: " + line);
        }
        if (column < 0) {
            throw new IllegalArgumentException("column must be non negative: " + column);
        }
        this.line = line;
        this.column = column;
    }

    public boolean after(@NotNull VisualPosition other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/openapi/editor/VisualPosition", "after"));
        }
        if (this.line == other.line) {
            return this.column > other.column;
        }
        return this.line > other.line;
    }

    @NonNls
    public String toString() {
        return "VisualPosition: (" + this.line + ", " + this.column + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VisualPosition)) {
            return false;
        }
        VisualPosition that = (VisualPosition)o;
        if (this.column != that.column) {
            return false;
        }
        return this.line == that.line;
    }

    public int hashCode() {
        int result = this.line;
        result = 31 * result + this.column;
        return result;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

