/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Task
implements TaskInfo,
Progressive {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.Task");
    protected final Project myProject;
    protected String myTitle;
    private final boolean myCanBeCancelled;
    private String myCancelText;
    private String myCancelTooltipText;

    public Task(@Nullable Project project, @NotNull String title, boolean canBeCancelled) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/Task", "<init>"));
        }
        this.myCancelText = CommonBundle.getCancelButtonText();
        this.myCancelTooltipText = CommonBundle.getCancelButtonText();
        this.myProject = project;
        this.myTitle = title;
        this.myCanBeCancelled = canBeCancelled;
    }

    public void onCancel() {
    }

    public void onSuccess() {
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final void queue() {
        ProgressManager.getInstance().run(this);
    }

    @Override
    public String getProcessId() {
        return "<unknown>";
    }

    @Override
    @NotNull
    public final String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/Task", "getTitle"));
        }
        return string;
    }

    @NotNull
    public final Task setTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/Task", "setTitle"));
        }
        this.myTitle = title;
        Task task = this;
        if (task == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/Task", "setTitle"));
        }
        return task;
    }

    @Override
    public final String getCancelText() {
        return this.myCancelText;
    }

    @NotNull
    public final Task setCancelText(String cancelText) {
        this.myCancelText = cancelText;
        Task task = this;
        if (task == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/Task", "setCancelText"));
        }
        return task;
    }

    @Nullable
    public NotificationInfo getNotificationInfo() {
        return null;
    }

    @Nullable
    public NotificationInfo notifyFinished() {
        return this.getNotificationInfo();
    }

    public boolean isHeadless() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    @NotNull
    public final Task setCancelTooltipText(String cancelTooltipText) {
        this.myCancelTooltipText = cancelTooltipText;
        Task task = this;
        if (task == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/Task", "setCancelTooltipText"));
        }
        return task;
    }

    @Override
    public final String getCancelTooltipText() {
        return this.myCancelTooltipText;
    }

    @Override
    public final boolean isCancellable() {
        return this.myCanBeCancelled;
    }

    public abstract boolean isModal();

    @NotNull
    public final Modal asModal() {
        if (this.isModal()) {
            Modal modal = (Modal)this;
            if (modal == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/Task", "asModal"));
            }
            return modal;
        }
        throw new IllegalStateException("Not a modal task");
    }

    @NotNull
    public final Backgroundable asBackgroundable() {
        if (!this.isModal()) {
            Backgroundable backgroundable = (Backgroundable)this;
            if (backgroundable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/Task", "asBackgroundable"));
            }
            return backgroundable;
        }
        throw new IllegalStateException("Not a backgroundable task");
    }

    public static class NotificationInfo {
        private final String myNotificationName;
        private final String myNotificationTitle;
        private final String myNotificationText;
        private final boolean myShowWhenFocused;

        public NotificationInfo(@NotNull String notificationName, @NotNull String notificationTitle, @NotNull String notificationText) {
            if (notificationName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationName", "com/intellij/openapi/progress/Task$NotificationInfo", "<init>"));
            }
            if (notificationTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationTitle", "com/intellij/openapi/progress/Task$NotificationInfo", "<init>"));
            }
            if (notificationText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationText", "com/intellij/openapi/progress/Task$NotificationInfo", "<init>"));
            }
            this(notificationName, notificationTitle, notificationText, false);
        }

        public NotificationInfo(@NotNull String notificationName, @NotNull String notificationTitle, @NotNull String notificationText, boolean showWhenFocused) {
            if (notificationName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationName", "com/intellij/openapi/progress/Task$NotificationInfo", "<init>"));
            }
            if (notificationTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationTitle", "com/intellij/openapi/progress/Task$NotificationInfo", "<init>"));
            }
            if (notificationText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationText", "com/intellij/openapi/progress/Task$NotificationInfo", "<init>"));
            }
            this.myNotificationName = notificationName;
            this.myNotificationTitle = notificationTitle;
            this.myNotificationText = notificationText;
            this.myShowWhenFocused = showWhenFocused;
        }

        @NotNull
        public String getNotificationName() {
            String string = this.myNotificationName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/Task$NotificationInfo", "getNotificationName"));
            }
            return string;
        }

        @NotNull
        public String getNotificationTitle() {
            String string = this.myNotificationTitle;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/Task$NotificationInfo", "getNotificationTitle"));
            }
            return string;
        }

        @NotNull
        public String getNotificationText() {
            String string = this.myNotificationText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/Task$NotificationInfo", "getNotificationText"));
            }
            return string;
        }

        public boolean isShowWhenFocused() {
            return this.myShowWhenFocused;
        }
    }

    public static abstract class ConditionalModal
    extends Backgroundable {
        public ConditionalModal(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @NotNull PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/Task$ConditionalModal", "<init>"));
            }
            if (backgroundOption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundOption", "com/intellij/openapi/progress/Task$ConditionalModal", "<init>"));
            }
            super(project, title, canBeCancelled, backgroundOption);
        }

        @Override
        public final boolean isConditionalModal() {
            return true;
        }
    }

    public static abstract class Modal
    extends Task {
        public Modal(@Nullable Project project, @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/Task$Modal", "<init>"));
            }
            super(project, title, canBeCancelled);
        }

        @Override
        public final boolean isModal() {
            return true;
        }
    }

    public static abstract class Backgroundable
    extends Task
    implements PerformInBackgroundOption {
        protected final PerformInBackgroundOption myBackgroundOption;

        public Backgroundable(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @Nullable PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/Task$Backgroundable", "<init>"));
            }
            super(project, title, canBeCancelled);
            this.myBackgroundOption = backgroundOption;
            if (StringUtil.isEmptyOrSpaces((String)title)) {
                LOG.warn("Empty title for backgroundable task.", new Throwable());
            }
        }

        public Backgroundable(@Nullable Project project, @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/Task$Backgroundable", "<init>"));
            }
            this(project, title, canBeCancelled, null);
        }

        public Backgroundable(@Nullable Project project, @NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/Task$Backgroundable", "<init>"));
            }
            this(project, title, true);
        }

        @Override
        public boolean shouldStartInBackground() {
            return this.myBackgroundOption == null || this.myBackgroundOption.shouldStartInBackground();
        }

        @Override
        public void processSentToBackground() {
            if (this.myBackgroundOption != null) {
                this.myBackgroundOption.processSentToBackground();
            }
        }

        @Override
        public final boolean isModal() {
            return false;
        }

        public boolean isConditionalModal() {
            return false;
        }

        @NotNull
        public DumbModeAction getDumbModeAction() {
            DumbModeAction dumbModeAction = DumbModeAction.NOTHING;
            if (dumbModeAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/Task$Backgroundable", "getDumbModeAction"));
            }
            return dumbModeAction;
        }
    }
}

