/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.ProjectProfileManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultProjectProfileManager
extends ProjectProfileManager
implements JDOMExternalizable {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.profile.DefaultProjectProfileManager");
    @NonNls
    protected static final String PROFILES = "profiles";
    @NonNls
    public static final String SCOPES = "scopes";
    @NonNls
    protected static final String SCOPE = "scope";
    @NonNls
    public static final String PROFILE = "profile";
    @NonNls
    protected static final String NAME = "name";
    private static final String VERSION = "1.0";
    @NotNull
    protected final Project myProject;
    public String PROJECT_PROFILE;
    public boolean USE_PROJECT_PROFILE;
    private final ApplicationProfileManager myApplicationProfileManager;
    private final Map<String, Profile> myProfiles;
    protected final DependencyValidationManager myHolder;
    private final List<ProfileChangeAdapter> myProfilesListener;
    @NonNls
    private static final String PROJECT_DEFAULT_PROFILE_NAME = "Project Default";

    public DefaultProjectProfileManager(@NotNull Project project, @NotNull ApplicationProfileManager applicationProfileManager, @NotNull DependencyValidationManager holder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/DefaultProjectProfileManager", "<init>"));
        }
        if (applicationProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationProfileManager", "com/intellij/profile/DefaultProjectProfileManager", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/profile/DefaultProjectProfileManager", "<init>"));
        }
        this.USE_PROJECT_PROFILE = true;
        this.myProfiles = new HashMap<String, Profile>();
        this.myProfilesListener = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myHolder = holder;
        this.myApplicationProfileManager = applicationProfileManager;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/DefaultProjectProfileManager", "getProject"));
        }
        return project;
    }

    @Override
    public synchronized Profile getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/profile/DefaultProjectProfileManager", "getProfile"));
        }
        return this.myProfiles.containsKey(name) ? this.myProfiles.get(name) : this.myApplicationProfileManager.getProfile(name, returnRootProfileIfNamedIsAbsent);
    }

    @Override
    public synchronized void updateProfile(@NotNull Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PROFILE, "com/intellij/profile/DefaultProjectProfileManager", "updateProfile"));
        }
        this.myProfiles.put(profile.getName(), profile);
        for (ProfileChangeAdapter profileChangeAdapter : this.myProfilesListener) {
            profileChangeAdapter.profileChanged(profile);
        }
    }

    public synchronized void readExternal(Element element) throws InvalidDataException {
        this.myProfiles.clear();
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        Element profilesElement = element.getChild(PROFILES);
        if (profilesElement != null) {
            for (Element o : profilesElement.getChildren(PROFILE)) {
                Profile profile = this.myApplicationProfileManager.createProfile();
                profile.setProfileManager(this);
                profile.readExternal(o);
                String name = profile.getName();
                if (this.myApplicationProfileManager.getProfile(name) != null) {
                    // empty if block
                }
                this.myProfiles.put(name, profile);
            }
        }
        if (element.getChild("version") == null || !Comparing.strEqual((String)element.getChild("version").getAttributeValue("value"), (String)VERSION)) {
            boolean toConvert = true;
            for (Element o : element.getChildren("option")) {
                if (!Comparing.strEqual((String)o.getAttributeValue(NAME), (String)"USE_PROJECT_LEVEL_SETTINGS")) continue;
                toConvert = Boolean.parseBoolean(o.getAttributeValue("value"));
                break;
            }
            if (toConvert) {
                this.convert(element);
            }
        }
    }

    protected void convert(Element element) throws InvalidDataException {
    }

    public synchronized void writeExternal(Element element) throws WriteExternalException {
        ArrayList<String> sortedProfiles = new ArrayList<String>(this.myProfiles.keySet());
        Collections.sort(sortedProfiles);
        Element profiles = null;
        for (String profile : sortedProfiles) {
            boolean hasSmthToSave;
            Profile projectProfile = this.myProfiles.get(profile);
            if (projectProfile == null) continue;
            Element profileElement = new Element(PROFILE);
            projectProfile.writeExternal(profileElement);
            boolean bl = hasSmthToSave = sortedProfiles.size() > 1 || this.isDefaultProfileUsed();
            if (!hasSmthToSave) {
                for (Element child : profileElement.getChildren()) {
                    if (child.getName().equals("option")) continue;
                    hasSmthToSave = true;
                    break;
                }
            }
            if (!hasSmthToSave) continue;
            if (profiles == null) {
                profiles = new Element(PROFILES);
                element.addContent(profiles);
            }
            profiles.addContent(profileElement);
        }
        if (profiles != null || this.isDefaultProfileUsed()) {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
            Element version = new Element("version");
            version.setAttribute("value", VERSION);
            element.addContent(version);
        }
    }

    private boolean isDefaultProfileUsed() {
        return this.PROJECT_PROFILE != null && !Comparing.strEqual((String)this.PROJECT_PROFILE, (String)PROJECT_DEFAULT_PROFILE_NAME);
    }

    @Override
    @NotNull
    public NamedScopesHolder getScopesManager() {
        DependencyValidationManager dependencyValidationManager = this.myHolder;
        if (dependencyValidationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/DefaultProjectProfileManager", "getScopesManager"));
        }
        return dependencyValidationManager;
    }

    @Override
    @NotNull
    public synchronized Collection<Profile> getProfiles() {
        this.getProjectProfileImpl();
        Collection<Profile> collection = this.myProfiles.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/DefaultProjectProfileManager", "getProfiles"));
        }
        return collection;
    }

    @Override
    @NotNull
    public synchronized String[] getAvailableProfileNames() {
        String[] stringArray = ArrayUtil.toStringArray(this.myProfiles.keySet());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/DefaultProjectProfileManager", "getAvailableProfileNames"));
        }
        return stringArray;
    }

    @Override
    public synchronized void deleteProfile(String name) {
        this.myProfiles.remove(name);
    }

    @Override
    public synchronized String getProjectProfile() {
        return this.PROJECT_PROFILE;
    }

    @Override
    public synchronized void setProjectProfile(@Nullable String newProfile) {
        String oldProfile = this.PROJECT_PROFILE;
        this.PROJECT_PROFILE = newProfile;
        boolean bl = this.USE_PROJECT_PROFILE = newProfile != null;
        if (oldProfile != null) {
            for (ProfileChangeAdapter adapter : this.myProfilesListener) {
                adapter.profileActivated(this.getProfile(oldProfile), newProfile != null ? this.getProfile(newProfile) : null);
            }
        }
    }

    @NotNull
    public synchronized Profile getProjectProfileImpl() {
        if (!this.USE_PROJECT_PROFILE) {
            Profile profile = this.myApplicationProfileManager.getRootProfile();
            if (profile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/DefaultProjectProfileManager", "getProjectProfileImpl"));
            }
            return profile;
        }
        if (this.PROJECT_PROFILE == null || this.myProfiles.isEmpty()) {
            this.setProjectProfile(PROJECT_DEFAULT_PROFILE_NAME);
            Profile projectProfile = this.myApplicationProfileManager.createProfile();
            projectProfile.copyFrom(this.myApplicationProfileManager.getRootProfile());
            projectProfile.setLocal(false);
            projectProfile.setName(PROJECT_DEFAULT_PROFILE_NAME);
            this.myProfiles.put(PROJECT_DEFAULT_PROFILE_NAME, projectProfile);
        } else if (!this.myProfiles.containsKey(this.PROJECT_PROFILE)) {
            String projectProfileAttempt = this.myProfiles.keySet().iterator().next();
            this.setProjectProfile(projectProfileAttempt);
        }
        Profile profile = this.myProfiles.get(this.PROJECT_PROFILE);
        profile.setProfileManager(this);
        Profile profile2 = profile;
        if (profile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/DefaultProjectProfileManager", "getProjectProfileImpl"));
        }
        return profile2;
    }

    public void addProfilesListener(final @NotNull ProfileChangeAdapter profilesListener, @NotNull Disposable parent) {
        if (profilesListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilesListener", "com/intellij/profile/DefaultProjectProfileManager", "addProfilesListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/profile/DefaultProjectProfileManager", "addProfilesListener"));
        }
        this.myProfilesListener.add(profilesListener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DefaultProjectProfileManager.this.myProfilesListener.remove(profilesListener);
            }
        });
    }

    public void removeProfilesListener(@NotNull ProfileChangeAdapter profilesListener) {
        if (profilesListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilesListener", "com/intellij/profile/DefaultProjectProfileManager", "removeProfilesListener"));
        }
        this.myProfilesListener.remove(profilesListener);
    }

    protected void fireProfilesInitialized() {
        for (ProfileChangeAdapter profileChangeAdapter : this.myProfilesListener) {
            profileChangeAdapter.profilesInitialized();
        }
    }

    protected void fireProfilesShutdown() {
        for (ProfileChangeAdapter profileChangeAdapter : this.myProfilesListener) {
            profileChangeAdapter.profilesShutdown();
        }
    }

    public static class ProfileStateSplitter
    implements StateSplitter {
        @Override
        public List<Pair<Element, String>> splitState(Element e) {
            Element[] elements;
            UniqueNameGenerator generator = new UniqueNameGenerator();
            ArrayList<Pair<Element, String>> result = new ArrayList<Pair<Element, String>>();
            for (Element element : elements = JDOMUtil.getElements((Element)e)) {
                Element[] profiles;
                if (!element.getName().equals(DefaultProjectProfileManager.PROFILES)) continue;
                element.detach();
                for (Element profile : profiles = JDOMUtil.getElements((Element)element)) {
                    Element[] options;
                    String profileName = null;
                    for (Element option : options = JDOMUtil.getElements((Element)profile)) {
                        if (!option.getName().equals("option") || !option.getAttributeValue(DefaultProjectProfileManager.NAME).equals("myName")) continue;
                        profileName = option.getAttributeValue("value");
                    }
                    assert (profileName != null);
                    String name = generator.generateUniqueName(FileUtil.sanitizeFileName(profileName)) + ".xml";
                    result.add((Pair<Element, String>)Pair.create((Object)profile, (Object)name));
                }
            }
            if (!e.getContent().isEmpty()) {
                result.add((Pair<Element, String>)Pair.create((Object)e, (Object)(generator.generateUniqueName("profiles_settings") + ".xml")));
            }
            return result;
        }

        @Override
        public void mergeStatesInto(Element target, Element[] elements) {
            Element profiles = new Element(DefaultProjectProfileManager.PROFILES);
            target.addContent(profiles);
            for (Element element : elements) {
                Element[] states;
                if (element.getName().equals(DefaultProjectProfileManager.PROFILE)) {
                    element.detach();
                    profiles.addContent(element);
                    continue;
                }
                for (Element state : states = JDOMUtil.getElements((Element)element)) {
                    state.detach();
                    target.addContent(state);
                }
            }
        }
    }
}

