/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.IdeaTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.builders.JavaModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.JavaCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.JavaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public abstract class JavaCodeInsightFixtureTestCase
extends UsefulTestCase {
    protected JavaCodeInsightTestFixture myFixture;
    protected Module myModule;

    protected JavaCodeInsightFixtureTestCase() {
        IdeaTestCase.initPlatformPrefix();
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestFixtureBuilder projectBuilder = IdeaTestFixtureFactory.getFixtureFactory().createFixtureBuilder(this.getName());
        this.myFixture = JavaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture((IdeaProjectTestFixture)projectBuilder.getFixture());
        JavaModuleFixtureBuilder moduleFixtureBuilder = (JavaModuleFixtureBuilder)projectBuilder.addModule(JavaModuleFixtureBuilder.class);
        if (this.toAddSourceRoot()) {
            moduleFixtureBuilder.addSourceContentRoot(this.myFixture.getTempDirPath());
        } else {
            moduleFixtureBuilder.addContentRoot(this.myFixture.getTempDirPath());
        }
        this.tuneFixture(moduleFixtureBuilder);
        this.myFixture.setUp();
        this.myFixture.setTestDataPath(this.getTestDataPath());
        this.myModule = moduleFixtureBuilder.getFixture().getModule();
    }

    protected boolean toAddSourceRoot() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        this.myModule = null;
        try {
            this.myFixture.tearDown();
        }
        finally {
            this.myFixture = null;
            super.tearDown();
        }
    }

    @NonNls
    protected String getBasePath() {
        return "";
    }

    @NonNls
    protected String getTestDataPath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/') + this.getBasePath();
    }

    protected void tuneFixture(JavaModuleFixtureBuilder moduleBuilder) throws Exception {
    }

    protected Project getProject() {
        return this.myFixture.getProject();
    }

    protected PsiManager getPsiManager() {
        return PsiManager.getInstance(this.getProject());
    }

    public PsiElementFactory getElementFactory() {
        return JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
    }
}

