/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class DecHelper {
    public static boolean checkStatementExceptions(List<Statement> lst) {
        HashSet<Statement> all = new HashSet<Statement>(lst);
        HashSet<Statement> handlers = new HashSet<Statement>();
        Set<Statement> intersection = null;
        for (Statement stat : lst) {
            Set<Statement> setNew = stat.getNeighboursSet(2, 1);
            if (intersection == null) {
                intersection = setNew;
                continue;
            }
            HashSet<Statement> interclone = new HashSet<Statement>(intersection);
            interclone.removeAll(setNew);
            intersection.retainAll(setNew);
            setNew.removeAll(intersection);
            handlers.addAll(interclone);
            handlers.addAll(setNew);
        }
        for (Statement stat : handlers) {
            if (all.contains(stat) && all.containsAll(stat.getNeighbours(2, 0))) continue;
            return false;
        }
        for (int i = 1; i < lst.size(); ++i) {
            Statement stat;
            stat = lst.get(i);
            if (stat.getPredecessorEdges(2).isEmpty() || handlers.contains(stat)) continue;
            return false;
        }
        return true;
    }

    public static boolean isChoiceStatement(Statement head, List<Statement> lst) {
        boolean repeat;
        Statement post = null;
        Set<Statement> setDest = head.getNeighboursSet(1, 1);
        if (setDest.contains(head)) {
            return false;
        }
        block0: do {
            lst.clear();
            repeat = false;
            setDest.remove(post);
            for (Statement stat : setDest) {
                StatEdge edge;
                List<StatEdge> lstEdges;
                if (stat.getLastBasicType() != 2) {
                    if (post == null) {
                        post = stat;
                        repeat = true;
                        continue block0;
                    }
                    return false;
                }
                Set<Statement> setPred = stat.getNeighboursSet(1, 0);
                setPred.remove(head);
                if (setPred.contains(stat)) {
                    return false;
                }
                if (!setDest.containsAll(setPred) || setPred.size() > 1) {
                    if (post == null) {
                        post = stat;
                        repeat = true;
                        continue block0;
                    }
                    return false;
                }
                if (setPred.size() == 1) {
                    Statement pred = setPred.iterator().next();
                    while (lst.contains(pred)) {
                        Set<Statement> setPredTemp = pred.getNeighboursSet(1, 0);
                        setPredTemp.remove(head);
                        if (setPredTemp.isEmpty()) break;
                        pred = setPredTemp.iterator().next();
                        if (pred != stat) continue;
                        return false;
                    }
                }
                if ((lstEdges = stat.getSuccessorEdges(0x40000000)).size() > 1) {
                    Set<Statement> setSucc = stat.getNeighboursSet(0x40000000, 1);
                    setSucc.retainAll(setDest);
                    if (setSucc.size() > 0) {
                        return false;
                    }
                    if (post == null) {
                        post = stat;
                        repeat = true;
                        continue block0;
                    }
                    return false;
                }
                if (lstEdges.size() == 1 && (edge = lstEdges.get(0)).getType() == 1) {
                    Statement statd = edge.getDestination();
                    if (head == statd) {
                        return false;
                    }
                    if (!setDest.contains(statd) && post != statd) {
                        if (post != null) {
                            return false;
                        }
                        Set<Statement> set = statd.getNeighboursSet(1, 0);
                        if (set.size() > 1) {
                            post = statd;
                            repeat = true;
                            continue block0;
                        }
                        return false;
                    }
                }
                lst.add(stat);
            }
        } while (repeat);
        lst.add(head);
        lst.remove(post);
        lst.add(0, post);
        return true;
    }

    public static HashSet<Statement> getUniquePredExceptions(Statement head) {
        HashSet<Statement> setHandlers = new HashSet<Statement>(head.getNeighbours(2, 1));
        Iterator<Statement> it = setHandlers.iterator();
        while (it.hasNext()) {
            if (it.next().getPredecessorEdges(2).size() <= 1) continue;
            it.remove();
        }
        return setHandlers;
    }

    public static List<Exprent> copyExprentList(List<Exprent> lst) {
        ArrayList<Exprent> ret = new ArrayList<Exprent>();
        for (Exprent expr : lst) {
            ret.add(expr.copy());
        }
        return ret;
    }
}

