/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.renamer;

import java.util.HashSet;
import org.jetbrains.java.decompiler.main.extern.IIdentifierRenamer;

public class ConverterHelper
implements IIdentifierRenamer {
    private static HashSet<String> setReserved = new HashSet();
    private int class_counter = 0;
    private int field_counter = 0;
    private int method_counter = 0;
    private HashSet<String> setNonStandardClassNames = new HashSet();

    @Override
    public boolean toBeRenamed(int element_type, String classname, String element, String descriptor) {
        String value = element_type == 1 ? classname : element;
        return value == null || value.length() == 0 || value.length() <= 2 || setReserved.contains(value) || Character.isDigit(value.charAt(0));
    }

    @Override
    public String getNextClassname(String fullname, String shortname) {
        if (shortname == null) {
            return "class_" + this.class_counter++;
        }
        int index = 0;
        while (Character.isDigit(shortname.charAt(index))) {
            ++index;
        }
        if (index == 0 || index == shortname.length()) {
            return "class_" + this.class_counter++;
        }
        String name = shortname.substring(index);
        if (this.setNonStandardClassNames.contains(name)) {
            return "Inner" + name + "_" + this.class_counter++;
        }
        this.setNonStandardClassNames.add(name);
        return "Inner" + name;
    }

    @Override
    public String getNextFieldname(String classname, String field, String descriptor) {
        return "field_" + this.field_counter++;
    }

    @Override
    public String getNextMethodname(String classname, String method, String descriptor) {
        return "method_" + this.method_counter++;
    }

    public static String getSimpleClassName(String fullname) {
        return fullname.substring(fullname.lastIndexOf(47) + 1);
    }

    public static String replaceSimpleClassName(String fullname, String newname) {
        return fullname.substring(0, fullname.lastIndexOf(47) + 1) + newname;
    }

    static {
        setReserved.add("abstract");
        setReserved.add("do");
        setReserved.add("if");
        setReserved.add("package");
        setReserved.add("synchronized");
        setReserved.add("boolean");
        setReserved.add("double");
        setReserved.add("implements");
        setReserved.add("private");
        setReserved.add("this");
        setReserved.add("break");
        setReserved.add("else");
        setReserved.add("import");
        setReserved.add("protected");
        setReserved.add("throw");
        setReserved.add("byte");
        setReserved.add("extends");
        setReserved.add("instanceof");
        setReserved.add("public");
        setReserved.add("throws");
        setReserved.add("case");
        setReserved.add("false");
        setReserved.add("int");
        setReserved.add("return");
        setReserved.add("transient");
        setReserved.add("catch");
        setReserved.add("final");
        setReserved.add("interface");
        setReserved.add("short");
        setReserved.add("true");
        setReserved.add("char");
        setReserved.add("finally");
        setReserved.add("long");
        setReserved.add("static");
        setReserved.add("try");
        setReserved.add("class");
        setReserved.add("float");
        setReserved.add("native");
        setReserved.add("strictfp");
        setReserved.add("void");
        setReserved.add("const");
        setReserved.add("for");
        setReserved.add("new");
        setReserved.add("super");
        setReserved.add("volatile");
        setReserved.add("continue");
        setReserved.add("goto");
        setReserved.add("null");
        setReserved.add("switch");
        setReserved.add("while");
        setReserved.add("default");
        setReserved.add("assert");
        setReserved.add("enum");
    }
}

