/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references.extensions;

import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class ExtensionPointDocumentationProvider
extends DocumentationProviderEx {
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(originalElement);
        if (extensionPoint == null) {
            return null;
        }
        XmlFile epDeclarationFile = (XmlFile)extensionPoint.getXmlTag().getContainingFile();
        Module epModule = ModuleUtilCore.findModuleForFile((VirtualFile)epDeclarationFile.getVirtualFile(), (Project)element.getProject());
        PsiClass epClass = ExtensionPointDocumentationProvider.getExtensionPointClass(extensionPoint);
        String epPrefix = extensionPoint.getNamePrefix();
        return (epModule == null ? "" : "[" + epModule.getName() + "]") + (epPrefix == null ? "" : " " + epPrefix) + "\n" + "<b>" + extensionPoint.getEffectiveName() + "</b>" + " [" + epDeclarationFile.getName() + "]\n" + (epClass == null ? "<unknown>" : epClass.getQualifiedName());
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(originalElement);
        if (extensionPoint == null) {
            return null;
        }
        PsiClass epClass = ExtensionPointDocumentationProvider.getExtensionPointClass(extensionPoint);
        if (epClass != null) {
            return JavaDocumentationProvider.generateExternalJavadoc((PsiElement)epClass);
        }
        return null;
    }

    @Nullable
    private static ExtensionPoint findExtensionPoint(@Nullable PsiElement element) {
        DomElement domElement;
        if (element == null) {
            return null;
        }
        if (element.getLanguage() == XMLLanguage.INSTANCE && (element instanceof XmlTag || element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_NAME) && DescriptorUtil.isPluginXml(element.getContainingFile()) && (domElement = DomUtil.getDomElement((PsiElement)element)) instanceof Extension) {
            return ((Extension)domElement).getExtensionPoint();
        }
        return null;
    }

    @Nullable
    private static PsiClass getExtensionPointClass(ExtensionPoint extensionPoint) {
        return DomUtil.hasXml(extensionPoint.getInterface()) ? (PsiClass)extensionPoint.getInterface().getValue() : (PsiClass)extensionPoint.getBeanClass().getValue();
    }
}

