/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.run.IdeaLicenseHelper;
import org.jetbrains.idea.devkit.run.PluginRunConfigurationEditor;

public class PluginRunConfiguration
extends RunConfigurationBase
implements ModuleRunConfiguration {
    private Module myModule;
    private String myModuleName;
    public String VM_PARAMETERS;
    public String PROGRAM_PARAMETERS;
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String MODULE = "module";
    @NonNls
    private static final String ALTERNATIVE_PATH_ELEMENT = "alternative-path";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String ALTERNATIVE_PATH_ENABLED_ATTR = "alternative-path-enabled";
    private String ALTERNATIVE_JRE_PATH = null;
    private boolean ALTERNATIVE_JRE_PATH_ENABLED = false;

    public PluginRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        PluginRunConfigurationEditor pluginRunConfigurationEditor = new PluginRunConfigurationEditor(this);
        if (pluginRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/run/PluginRunConfiguration", "getConfigurationEditor"));
        }
        return pluginRunConfigurationEditor;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/devkit/run/PluginRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/idea/devkit/run/PluginRunConfiguration", "getState"));
        }
        if (this.getModule() == null) {
            throw new ExecutionException(DevKitBundle.message("run.configuration.no.module.specified", new Object[0]));
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.getModule());
        Sdk jdk = rootManager.getSdk();
        if (jdk == null) {
            throw CantRunException.noJdkForModule((Module)this.getModule());
        }
        final Sdk ideaJdk = IdeaJdk.findIdeaJdk(jdk);
        if (ideaJdk == null) {
            throw new ExecutionException(DevKitBundle.message("sdk.type.incorrect.common", new Object[0]));
        }
        String sandboxHome = ((Sandbox)ideaJdk.getSdkAdditionalData()).getSandboxHome();
        if (sandboxHome == null) {
            throw new ExecutionException(DevKitBundle.message("sandbox.no.configured", new Object[0]));
        }
        try {
            sandboxHome = new File(sandboxHome).getCanonicalPath();
        }
        catch (IOException e) {
            throw new ExecutionException(DevKitBundle.message("sandbox.no.configured", new Object[0]));
        }
        final String canonicalSandbox = sandboxHome;
        IdeaLicenseHelper.copyIDEALicense(sandboxHome, ideaJdk);
        JavaCommandLineState state = new JavaCommandLineState(env){

            protected JavaParameters createJavaParameters() throws ExecutionException {
                String buildNumber;
                JavaParameters params = new JavaParameters();
                ParametersList vm = params.getVMParametersList();
                PluginRunConfiguration.fillParameterList(vm, PluginRunConfiguration.this.VM_PARAMETERS);
                PluginRunConfiguration.fillParameterList(params.getProgramParametersList(), PluginRunConfiguration.this.PROGRAM_PARAMETERS);
                Sdk usedIdeaJdk = ideaJdk;
                if (PluginRunConfiguration.this.isAlternativeJreEnabled() && !StringUtil.isEmptyOrSpaces((String)PluginRunConfiguration.this.getAlternativeJrePath())) {
                    try {
                        usedIdeaJdk = (Sdk)usedIdeaJdk.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new ExecutionException(e.getMessage());
                    }
                    SdkModificator sdkToSetUp = usedIdeaJdk.getSdkModificator();
                    sdkToSetUp.setHomePath(PluginRunConfiguration.this.getAlternativeJrePath());
                    sdkToSetUp.commitChanges();
                }
                String libPath = usedIdeaJdk.getHomePath() + File.separator + "lib";
                vm.add("-Xbootclasspath/a:" + libPath + File.separator + "boot.jar");
                vm.defineProperty("idea.config.path", canonicalSandbox + File.separator + "config");
                vm.defineProperty("idea.system.path", canonicalSandbox + File.separator + "system");
                vm.defineProperty("idea.plugins.path", canonicalSandbox + File.separator + "plugins");
                if (SystemInfo.isMac) {
                    vm.defineProperty("idea.smooth.progress", "false");
                    vm.defineProperty("apple.laf.useScreenMenuBar", "true");
                }
                if (SystemInfo.isXWindow && (PluginRunConfiguration.this.VM_PARAMETERS == null || !PluginRunConfiguration.this.VM_PARAMETERS.contains("-Dsun.awt.disablegrab"))) {
                    vm.defineProperty("sun.awt.disablegrab", "true");
                }
                if (!vm.hasProperty("idea.platform.prefix") && (buildNumber = IdeaJdk.getBuildNumber(usedIdeaJdk.getHomePath())) != null) {
                    String prefix = null;
                    if (buildNumber.startsWith("IC")) {
                        prefix = "Idea";
                    } else if (buildNumber.startsWith("PY")) {
                        prefix = "Python";
                    } else if (buildNumber.startsWith("PC")) {
                        prefix = "PyCharmCore";
                    } else if (buildNumber.startsWith("RM")) {
                        prefix = "Ruby";
                    } else if (buildNumber.startsWith("PS")) {
                        prefix = "PhpStorm";
                    } else if (buildNumber.startsWith("WS")) {
                        prefix = "WebStorm";
                    } else if (buildNumber.startsWith("OC")) {
                        prefix = "AppCode";
                    } else if (buildNumber.startsWith("CL")) {
                        prefix = "CLion";
                    } else if (buildNumber.startsWith("DB")) {
                        prefix = "0xDBE";
                    }
                    if (prefix != null) {
                        vm.defineProperty("idea.platform.prefix", prefix);
                    }
                }
                params.setWorkingDirectory(usedIdeaJdk.getHomePath() + File.separator + "bin" + File.separator);
                params.setJdk(usedIdeaJdk);
                params.getClassPath().addFirst(libPath + File.separator + "log4j.jar");
                params.getClassPath().addFirst(libPath + File.separator + "jdom.jar");
                params.getClassPath().addFirst(libPath + File.separator + "trove4j.jar");
                params.getClassPath().addFirst(libPath + File.separator + "openapi.jar");
                params.getClassPath().addFirst(libPath + File.separator + "util.jar");
                params.getClassPath().addFirst(libPath + File.separator + "extensions.jar");
                params.getClassPath().addFirst(libPath + File.separator + "bootstrap.jar");
                params.getClassPath().addFirst(libPath + File.separator + "idea.jar");
                params.getClassPath().addFirst(libPath + File.separator + "idea_rt.jar");
                params.getClassPath().addFirst(((JavaSdkType)usedIdeaJdk.getSdkType()).getToolsPath(usedIdeaJdk));
                params.setMainClass("com.intellij.idea.Main");
                return params;
            }
        };
        return state;
    }

    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String ALTERNATIVE_JRE_PATH) {
        this.ALTERNATIVE_JRE_PATH = ALTERNATIVE_JRE_PATH;
    }

    public boolean isAlternativeJreEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJreEnabled(boolean ALTERNATIVE_JRE_PATH_ENABLED) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = ALTERNATIVE_JRE_PATH_ENABLED;
    }

    private static void fillParameterList(ParametersList list, @Nullable String value) {
        if (value == null) {
            return;
        }
        for (String parameter : value.split(" ")) {
            if (parameter == null || parameter.length() <= 0) continue;
            list.add(parameter);
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.getModule() == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("run.configuration.no.module.specified", new Object[0]));
        }
        String moduleName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return PluginRunConfiguration.this.getModule().getName();
            }
        });
        if (ModuleManager.getInstance((Project)this.getProject()).findModuleByName(moduleName) == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("run.configuration.no.module.specified", new Object[0]));
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.getModule());
        Sdk sdk = rootManager.getSdk();
        if (sdk == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("sdk.no.specified", moduleName));
        }
        if (IdeaJdk.findIdeaJdk(sdk) == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("sdk.type.incorrect", moduleName));
        }
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray;
        Module module = this.getModule();
        if (module != null) {
            Module[] moduleArray2 = new Module[1];
            moduleArray = moduleArray2;
            moduleArray2[0] = module;
        } else {
            moduleArray = Module.EMPTY_ARRAY;
        }
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/run/PluginRunConfiguration", "getModules"));
        }
        return moduleArray;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element module = element.getChild(MODULE);
        if (module != null) {
            this.myModuleName = module.getAttributeValue(NAME);
        }
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        Element altElement = element.getChild(ALTERNATIVE_PATH_ELEMENT);
        if (altElement != null) {
            this.ALTERNATIVE_JRE_PATH = altElement.getAttributeValue(PATH);
            String enabledAttr = altElement.getAttributeValue(ALTERNATIVE_PATH_ENABLED_ATTR);
            this.ALTERNATIVE_JRE_PATH_ENABLED = enabledAttr != null && Boolean.parseBoolean(enabledAttr);
        }
        super.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Element moduleElement = new Element(MODULE);
        moduleElement.setAttribute(NAME, (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                Module module = PluginRunConfiguration.this.getModule();
                return module != null ? module.getName() : (PluginRunConfiguration.this.myModuleName != null ? PluginRunConfiguration.this.myModuleName : "");
            }
        }));
        element.addContent(moduleElement);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        if (!StringUtil.isEmptyOrSpaces((String)this.ALTERNATIVE_JRE_PATH)) {
            Element altElement = new Element(ALTERNATIVE_PATH_ELEMENT);
            altElement.setAttribute(PATH, this.ALTERNATIVE_JRE_PATH);
            altElement.setAttribute(ALTERNATIVE_PATH_ENABLED_ATTR, String.valueOf(this.ALTERNATIVE_JRE_PATH_ENABLED));
            element.addContent(altElement);
        }
        super.writeExternal(element);
    }

    @Nullable
    public Module getModule() {
        if (this.myModule == null && this.myModuleName != null) {
            this.myModule = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(this.myModuleName);
        }
        if (this.myModule != null && this.myModule.isDisposed()) {
            this.myModule = null;
        }
        return this.myModule;
    }

    public void setModule(Module module) {
        this.myModule = module;
    }
}

