/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaSdkUtil {
    public static List<File> getJdkClassesRoots(File home, boolean isJre) {
        String[] additionalJars;
        File[] jarDirs;
        FileFilter jarFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isDirectory() && f.getName().endsWith(".jar");
            }
        };
        if (SystemInfo.isMac && !home.getName().startsWith("mockJDK")) {
            File libEndorsedDir;
            File libExtDir;
            File classesDir;
            File libDir;
            File openJdkRtJar = new File(home, "jre/lib/rt.jar");
            if (openJdkRtJar.exists() && !openJdkRtJar.isDirectory()) {
                libDir = new File(home, "lib");
                classesDir = openJdkRtJar.getParentFile();
                libExtDir = new File(openJdkRtJar.getParentFile(), "ext");
                libEndorsedDir = new File(libDir, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir, classesDir, libExtDir};
            } else {
                libDir = new File(home, "lib");
                classesDir = new File(home, "../Classes");
                libExtDir = new File(libDir, "ext");
                libEndorsedDir = new File(libDir, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir, classesDir, libExtDir};
            }
        } else {
            File libDir = isJre ? new File(home, "lib") : new File(home, "jre/lib");
            File libExtDir = new File(libDir, "ext");
            File libEndorsedDir = new File(libDir, "endorsed");
            jarDirs = new File[]{libEndorsedDir, libDir, libExtDir};
        }
        THashSet pathFilter = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        ArrayList rootFiles = ContainerUtil.newArrayList();
        for (File jarDir : jarDirs) {
            File[] jarFiles;
            if (jarDir == null || !jarDir.isDirectory()) continue;
            for (File jarFile : jarFiles = jarDir.listFiles(jarFileFilter)) {
                String canonicalPath;
                String jarFileName = jarFile.getName();
                if (jarFileName.equals("alt-rt.jar") || jarFileName.equals("alt-string.jar") || (canonicalPath = JavaSdkUtil.getCanonicalPath(jarFile)) == null || !pathFilter.add(canonicalPath)) continue;
                rootFiles.add(jarFile);
            }
        }
        for (String relativePath : additionalJars = new String[]{"jre/bin/default/jclSC170/vm.jar", "jre/lib/i386/default/jclSC170/vm.jar", "jre/lib/amd64/default/jclSC170/vm.jar", "jre/bin/default/jclSC160/vm.jar", "jre/lib/i386/default/jclSC160/vm.jar", "jre/lib/amd64/default/jclSC160/vm.jar", "lib/classes.zip"}) {
            File jar = new File(home, relativePath);
            if (!jar.isFile()) continue;
            rootFiles.add(jar);
        }
        File classesDir = new File(home, "classes");
        if (rootFiles.isEmpty() && classesDir.isDirectory()) {
            rootFiles.add(classesDir);
        }
        return rootFiles;
    }

    @Nullable
    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }
}

