/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.psi.SearchUtils;
import icons.AndroidIcons;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jetbrains.android.inspections.lint.SuppressLintIntentionAction;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityMenuAction
extends FlatComboAction {
    private final RenderContext myRenderContext;

    public ActivityMenuAction(RenderContext renderContext) {
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(AndroidIcons.Activity);
        presentation.setDescription("Associate with Activity...");
        this.updatePresentation(presentation);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            String activity = configuration.getActivity();
            String label = ActivityMenuAction.getActivityLabel(activity, true);
            presentation.setText(label);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    @NotNull
    public static String getActivityLabel(@Nullable String fqcn, boolean brief) {
        if (fqcn == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ActivityMenuAction", "getActivityLabel"));
            }
            return "";
        }
        if (brief) {
            int innerClass;
            String label = fqcn;
            int packageIndex = label.lastIndexOf(46);
            if (packageIndex != -1) {
                label = label.substring(packageIndex + 1);
            }
            if ((innerClass = label.lastIndexOf(36)) != -1) {
                label = label.substring(innerClass + 1);
            }
            if (label.endsWith("Activity") && label.length() > 12) {
                label = label.substring(0, label.length() - 8);
            } else if (label.endsWith("Fragment") && label.length() > 12) {
                label = label.substring(0, label.length() - 8);
            }
            String string = label;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ActivityMenuAction", "getActivityLabel"));
            }
            return string;
        }
        String string = fqcn;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ActivityMenuAction", "getActivityLabel"));
        }
        return string;
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup("Activity", true);
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null) {
            Module module = this.myRenderContext.getModule();
            assert (module != null);
            String activity = configuration.getActivity();
            String currentFqcn = null;
            String pkg = ManifestInfo.get(module, false).getPackage();
            if (activity != null && !activity.isEmpty()) {
                int dotIndex = activity.indexOf(46);
                if (dotIndex <= 0) {
                    if (pkg != null) {
                        activity = pkg + (dotIndex == -1 ? "." : "") + activity;
                    }
                    currentFqcn = activity;
                } else {
                    currentFqcn = activity;
                }
                String title = String.format("Open %1$s", activity.substring(activity.lastIndexOf(46) + 1).replace('$', '.'));
                group.add((AnAction)new ShowActivityAction(this.myRenderContext, title, activity));
                group.addSeparator();
            }
            boolean haveSpecificActivities = false;
            VirtualFile file = configuration.getFile();
            if (file != null) {
                String layoutName = ResourceHelper.getResourceName(file);
                Project project = module.getProject();
                String rLayoutFqcn = StringUtil.notNullize((String)pkg) + '.' + "R" + '.' + ResourceType.LAYOUT.getName();
                PsiClass layoutClass = JavaPsiFacade.getInstance((Project)project).findClass(rLayoutFqcn, GlobalSearchScope.projectScope((Project)project));
                if (layoutClass != null) {
                    PsiFile containingFile;
                    PsiReference reference;
                    PsiElement element;
                    Iterable allReferences;
                    Iterator iterator;
                    PsiClass activityBase = JavaPsiFacade.getInstance((Project)project).findClass("android.app.Activity", GlobalSearchScope.allScope((Project)project));
                    PsiField field = layoutClass.findFieldByName(layoutName, false);
                    if (field != null && activityBase != null && (iterator = (allReferences = SearchUtils.findAllReferences((PsiElement)field, (SearchScope)GlobalSearchScope.projectScope((Project)project))).iterator()).hasNext() && (element = (reference = (PsiReference)iterator.next()).getElement()) != null && (containingFile = element.getContainingFile()) instanceof PsiJavaFile) {
                        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
                        for (PsiClass cls : javaFile.getClasses()) {
                            String fqcn;
                            if (!cls.isInheritor(activityBase, false) || (fqcn = cls.getQualifiedName()) == null || fqcn.equals(currentFqcn)) continue;
                            String className = cls.getName();
                            String title = String.format("Associate with %1$s", className);
                            group.add((AnAction)new ChooseActivityAction(this.myRenderContext, title, fqcn));
                            haveSpecificActivities = true;
                        }
                    }
                }
            }
            if (haveSpecificActivities) {
                group.addSeparator();
            }
            group.add((AnAction)new ChooseActivityAction(this.myRenderContext, "Associate with other Activity...", null));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ActivityMenuAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    private static class ShowActivityAction
    extends AnAction {
        private final RenderContext myRenderContext;
        private final String myActivity;

        public ShowActivityAction(@NotNull RenderContext renderContext, @NotNull String title, @NotNull String activity) {
            if (renderContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/configurations/ActivityMenuAction$ShowActivityAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/configurations/ActivityMenuAction$ShowActivityAction", "<init>"));
            }
            if (activity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/android/tools/idea/configurations/ActivityMenuAction$ShowActivityAction", "<init>"));
            }
            super(title);
            this.myRenderContext = renderContext;
            this.myActivity = activity;
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile file;
            PsiFile containingFile;
            Module module = this.myRenderContext.getModule();
            if (module == null) {
                return;
            }
            Project project = module.getProject();
            PsiClass clz = JavaPsiFacade.getInstance((Project)project).findClass(this.myActivity.replace('$', '.'), GlobalSearchScope.allScope((Project)project));
            if (clz != null && (containingFile = clz.getContainingFile()) != null && (file = containingFile.getVirtualFile()) != null) {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, clz.getTextOffset());
                FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
            }
        }
    }

    private static class ChooseActivityAction
    extends AnAction {
        private final RenderContext myRenderContext;
        private String myActivity;

        public ChooseActivityAction(@NotNull RenderContext renderContext, @NotNull String title, @Nullable String activity) {
            if (renderContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/configurations/ActivityMenuAction$ChooseActivityAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/configurations/ActivityMenuAction$ChooseActivityAction", "<init>"));
            }
            super(title);
            this.myRenderContext = renderContext;
            this.myActivity = activity;
        }

        public void actionPerformed(AnActionEvent e) {
            Configuration configuration;
            final Module module = this.myRenderContext.getModule();
            if (module == null) {
                return;
            }
            if (this.myActivity == null) {
                ChooseClassDialog dialog = new ChooseClassDialog(module, "Activities", false, "android.app.Activity");
                dialog.show();
                if (!dialog.isOK()) {
                    return;
                }
                this.myActivity = dialog.getClassName();
                if (this.myActivity == null) {
                    return;
                }
            }
            if ((configuration = this.myRenderContext.getConfiguration()) != null) {
                String theme;
                configuration.setActivity(this.myActivity);
                final XmlFile file = this.myRenderContext.getXmlFile();
                assert (file != null);
                WriteCommandAction<Void> action = new WriteCommandAction<Void>(module.getProject(), "Choose Activity", new PsiFile[]{file}){

                    protected void run(Result<Void> result) throws Throwable {
                        String activity = ChooseActivityAction.this.myActivity;
                        String pkg = ManifestInfo.get(module, false).getPackage();
                        if (pkg != null && activity.startsWith(pkg) && activity.length() > pkg.length() && activity.charAt(pkg.length()) == '.') {
                            activity = activity.substring(pkg.length());
                        }
                        SuppressLintIntentionAction.ensureNamespaceImported(ChooseActivityAction.this.myRenderContext.getModule().getProject(), file, "http://schemas.android.com/tools");
                        XmlTag rootTag = file.getRootTag();
                        if (rootTag != null) {
                            rootTag.setAttribute("context", "http://schemas.android.com/tools", activity);
                        }
                    }
                };
                action.execute();
                ManifestInfo manifestInfo = ManifestInfo.get(module);
                ManifestInfo.ActivityAttributes attributes = manifestInfo.getActivityAttributes(this.myActivity);
                if (attributes != null && (theme = attributes.getTheme()) != null) {
                    assert (theme.startsWith("@")) : theme;
                    configuration.setTheme(theme);
                }
            }
        }
    }
}

