/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.lint.detector.api.ClassContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class AarResourceClassGenerator {
    @NotNull
    private final LocalResourceRepository myAarResources;
    @NotNull
    private final AppResourceRepository myAppResources;

    private AarResourceClassGenerator(@NotNull AppResourceRepository appResources, @NotNull LocalResourceRepository aarResources) {
        if (appResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appResources", "com/android/tools/idea/rendering/AarResourceClassGenerator", "<init>"));
        }
        if (aarResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aarResources", "com/android/tools/idea/rendering/AarResourceClassGenerator", "<init>"));
        }
        this.myAppResources = appResources;
        this.myAarResources = aarResources;
    }

    @Nullable
    public static AarResourceClassGenerator create(@NotNull AppResourceRepository appResources, @NotNull LocalResourceRepository aarResources) {
        if (appResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appResources", "com/android/tools/idea/rendering/AarResourceClassGenerator", "create"));
        }
        if (aarResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aarResources", "com/android/tools/idea/rendering/AarResourceClassGenerator", "create"));
        }
        return new AarResourceClassGenerator(appResources, aarResources);
    }

    @Nullable
    public byte[] generate(String fqcn) {
        String className = ClassContext.getInternalName((String)fqcn);
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 49, className, null, "java/lang/Object", null);
        int index = className.lastIndexOf(36);
        if (index != -1) {
            String typeName = className.substring(index + 1);
            ResourceType type = ResourceType.getEnum((String)typeName);
            if (type == null) {
                return null;
            }
            cw.visitInnerClass(className, className.substring(0, index), typeName, 25);
            if (type == ResourceType.STYLEABLE) {
                type = ResourceType.DECLARE_STYLEABLE;
                Collection keys = this.myAarResources.getItemsOfType(type);
                for (String key : keys) {
                    List items = this.myAarResources.getResourceItem(type, key);
                    if (items == null || items.isEmpty()) continue;
                    ResourceItem item = (ResourceItem)items.get(0);
                    cw.visitField(25, key, "[I", null, null);
                    ResourceValue resourceValue = item.getResourceValue(false);
                    assert (resourceValue instanceof DeclareStyleableResourceValue);
                    DeclareStyleableResourceValue dv = (DeclareStyleableResourceValue)resourceValue;
                    Map attributes = dv.getAllAttributes();
                    if (attributes == null) continue;
                    int idx = 0;
                    for (AttrResourceValue value : attributes.values()) {
                        Integer initialValue = idx++;
                        StringBuilder sb = new StringBuilder(30);
                        sb.append(key);
                        sb.append('_');
                        if (value.isFramework()) {
                            sb.append("android_");
                        }
                        String v = value.getName();
                        int n = v.length();
                        for (int i = 0; i < n; ++i) {
                            char c = v.charAt(i);
                            if (c == '.' || c == ':' || c == '-') {
                                sb.append('_');
                                continue;
                            }
                            sb.append(c);
                        }
                        cw.visitField(25, sb.toString(), "I", null, (Object)initialValue).visitEnd();
                    }
                }
                MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
                mv.visitCode();
                for (String key : keys) {
                    List items = this.myAarResources.getResourceItem(type, key);
                    if (items == null || items.isEmpty()) continue;
                    ResourceItem item = (ResourceItem)items.get(0);
                    ResourceValue resourceValue = item.getResourceValue(false);
                    assert (resourceValue instanceof DeclareStyleableResourceValue);
                    DeclareStyleableResourceValue dv = (DeclareStyleableResourceValue)resourceValue;
                    Map attributes = dv.getAllAttributes();
                    if (attributes == null) continue;
                    mv.visitIntInsn(16, attributes.size());
                    mv.visitIntInsn(188, 10);
                    int idx = 0;
                    for (AttrResourceValue value : attributes.values()) {
                        mv.visitInsn(89);
                        switch (idx) {
                            case 0: {
                                mv.visitInsn(3);
                                break;
                            }
                            case 1: {
                                mv.visitInsn(4);
                                break;
                            }
                            case 2: {
                                mv.visitInsn(5);
                                break;
                            }
                            case 3: {
                                mv.visitInsn(6);
                                break;
                            }
                            case 4: {
                                mv.visitInsn(7);
                                break;
                            }
                            case 5: {
                                mv.visitInsn(8);
                                break;
                            }
                            default: {
                                mv.visitIntInsn(16, idx);
                            }
                        }
                        Integer initialValue = this.myAppResources.getResourceId(ResourceType.ATTR, value.getName());
                        mv.visitLdcInsn((Object)initialValue);
                        mv.visitInsn(79);
                        ++idx;
                    }
                    mv.visitFieldInsn(179, className, key, "[I");
                }
                mv.visitInsn(177);
                mv.visitMaxs(4, 0);
                mv.visitEnd();
            } else {
                Collection keys = this.myAarResources.getItemsOfType(type);
                for (String key : keys) {
                    Integer initialValue = this.myAppResources.getResourceId(type, key);
                    cw.visitField(25, AndroidResourceUtil.getFieldNameByResourceName(key), "I", null, (Object)initialValue).visitEnd();
                }
            }
        } else {
            for (ResourceType t : this.myAarResources.getAvailableResourceTypes()) {
                cw.visitInnerClass(className + "$" + t.getName(), className, t.getName(), 25);
            }
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }
}

