/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.builder.model.SourceProvider;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceFileActionGroup;
import org.jetbrains.android.actions.CreateResourceFileDialog;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceFileAction
extends CreateResourceActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.actions.CreateResourceFileAction");
    private final Map<String, CreateTypedResourceFileAction> mySubactions = new HashMap<String, CreateTypedResourceFileAction>();
    private String myRootElement;
    private boolean myNavigate;

    @NotNull
    public static CreateResourceFileAction getInstance() {
        AnAction action = ActionManager.getInstance().getAction("Android.CreateResourcesActionGroup");
        assert (action instanceof CreateResourceFileActionGroup);
        CreateResourceFileAction createResourceFileAction = ((CreateResourceFileActionGroup)action).getCreateResourceFileAction();
        if (createResourceFileAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "getInstance"));
        }
        return createResourceFileAction;
    }

    public CreateResourceFileAction() {
        super(AndroidBundle.message("new.resource.action.title", new Object[0]), AndroidBundle.message("new.resource.action.description", new Object[0]), StdFileTypes.XML.getIcon());
    }

    public void add(CreateTypedResourceFileAction action) {
        this.mySubactions.put(action.getResourceType(), action);
    }

    public Collection<CreateTypedResourceFileAction> getSubactions() {
        return this.mySubactions.values();
    }

    @Override
    protected boolean isAvailable(DataContext context) {
        if (!super.isAvailable(context)) {
            return false;
        }
        return CreateResourceFileAction.isOutsideResourceTypeFolder(context);
    }

    static boolean isOutsideResourceTypeFolder(@NotNull DataContext context) {
        Module module;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/actions/CreateResourceFileAction", "isOutsideResourceTypeFolder"));
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (file != null) {
            if (!file.isDirectory()) {
                file = file.getParent();
            }
            if (file != null && ResourceFolderType.getFolderType((String)file.getName()) != null) {
                return false;
            }
        }
        if ((module = (Module)LangDataKeys.MODULE.getData(context)) != null) {
            return AndroidFacet.getInstance(module) != null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        return element != null && AndroidFacet.getInstance(element) != null;
    }

    @Nullable
    public static XmlFile createFileResource(@NotNull AndroidFacet facet, @NotNull ResourceFolderType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle, boolean navigate) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/actions/CreateResourceFileAction", "createFileResource"));
        }
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/actions/CreateResourceFileAction", "createFileResource"));
        }
        PsiElement[] elements = CreateResourceFileAction.doCreateFileResource(facet, resType, resName, rootElement, config, chooseResName, dialogTitle, navigate);
        if (elements.length == 0) {
            return null;
        }
        assert (elements.length == 1 && elements[0] instanceof XmlFile);
        return (XmlFile)elements[0];
    }

    @Deprecated
    @Nullable
    public static XmlFile createFileResource(@NotNull AndroidFacet facet, @NotNull ResourceType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/actions/CreateResourceFileAction", "createFileResource"));
        }
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/actions/CreateResourceFileAction", "createFileResource"));
        }
        ResourceFolderType folderType = ResourceFolderType.getTypeByName((String)resType.getName());
        assert (folderType != null) : resType;
        return CreateResourceFileAction.createFileResource(facet, folderType, resName, rootElement, config, chooseResName, dialogTitle, true);
    }

    @Nullable
    public static XmlFile createFileResource(@NotNull AndroidFacet facet, @NotNull ResourceFolderType folderType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/actions/CreateResourceFileAction", "createFileResource"));
        }
        if (folderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderType", "org/jetbrains/android/actions/CreateResourceFileAction", "createFileResource"));
        }
        return CreateResourceFileAction.createFileResource(facet, folderType, resName, rootElement, config, chooseResName, dialogTitle, true);
    }

    @NotNull
    private static PsiElement[] doCreateFileResource(@NotNull AndroidFacet facet, @NotNull ResourceFolderType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle, boolean navigate) {
        PsiDirectory psiResDir;
        VirtualFile resourceDir;
        AndroidFacet selectedFacet;
        String subdirName;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/actions/CreateResourceFileAction", "doCreateFileResource"));
        }
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/actions/CreateResourceFileAction", "doCreateFileResource"));
        }
        final CreateResourceFileAction action = CreateResourceFileAction.getInstance();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            subdirName = resType.getName();
            Module selectedModule = facet.getModule();
            selectedFacet = facet;
            resourceDir = facet.getPrimaryResourceDir();
        } else {
            Collection<VirtualFile> resDirectories;
            MyDialog dialog = new MyDialog(facet, action.mySubactions.values(), resType, resName, rootElement, config, chooseResName, action, facet.getModule(), true, null);
            dialog.setNavigate(navigate);
            if (dialogTitle != null) {
                dialog.setTitle(dialogTitle);
            }
            dialog.show();
            if (!dialog.isOK()) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "doCreateFileResource"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            if (chooseResName) {
                resName = dialog.getFileName();
            }
            subdirName = dialog.getSubdirName();
            Module selectedModule = dialog.getSelectedModule();
            selectedFacet = AndroidFacet.getInstance(selectedModule);
            assert (selectedFacet != null);
            SourceProvider provider = dialog.getSourceProvider();
            resourceDir = provider != null ? ((resDirectories = IdeaSourceProvider.create(provider).getResDirectories()).isEmpty() ? resDirectories.iterator().next() : selectedFacet.getPrimaryResourceDir()) : selectedFacet.getPrimaryResourceDir();
        }
        final Project project = facet.getModule().getProject();
        PsiDirectory psiDirectory = psiResDir = resourceDir != null ? PsiManager.getInstance((Project)project).findDirectory(resourceDir) : null;
        if (psiResDir == null) {
            Messages.showErrorDialog((Project)project, (String)("Cannot find resource directory for module " + selectedFacet.getModule().getName()), (String)CommonBundle.getErrorTitle());
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "doCreateFileResource"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        final String finalResName = resName;
        PsiElement[] elements = (PsiElement[])ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiElement[]>(){

            @Nullable
            public PsiElement[] compute() {
                CreateResourceActionBase.MyInputValidator validator = action.createValidator(project, psiResDir, subdirName);
                return validator.checkInput(finalResName) && validator.canClose(finalResName) ? validator.getCreatedElements() : null;
            }
        });
        PsiElement[] psiElementArray = elements != null ? elements : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "doCreateFileResource"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiElement[] invokeDialog(@NotNull Project project, final @NotNull DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/CreateResourceFileAction", "invokeDialog"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/jetbrains/android/actions/CreateResourceFileAction", "invokeDialog"));
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "invokeDialog"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        LOG.assertTrue(facet != null);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        ResourceFolderType folderType = CreateResourceFileAction.getUniqueFolderType(files);
        FolderConfiguration config = null;
        if (files != null && files.length > 0) {
            config = files.length == 1 ? FolderConfiguration.getConfigForFolder((String)files[0].getName()) : null;
        }
        MyDialog dialog = new MyDialog(facet, this.mySubactions.values(), folderType, null, null, config, true, this, facet.getModule(), false, CreateResourceFileAction.findResourceDirectory(dataContext)){

            @Override
            protected InputValidator createValidator(@NotNull String subdirName) {
                if (subdirName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subdirName", "org/jetbrains/android/actions/CreateResourceFileAction$2", "createValidator"));
                }
                Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
                assert (module != null);
                PsiDirectory resourceDirectory = this.getResourceDirectory(dataContext, true);
                return CreateResourceFileAction.this.createValidator(module.getProject(), resourceDirectory, subdirName);
            }
        };
        dialog.show();
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "invokeDialog"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    static ResourceFolderType getUniqueFolderType(@Nullable VirtualFile[] files) {
        ResourceFolderType folderType = null;
        if (files != null && files.length > 0) {
            for (VirtualFile file : files) {
                ResourceFolderType type;
                if (!file.isDirectory()) {
                    file = file.getParent();
                }
                if (file == null || (type = ResourceFolderType.getFolderType((String)file.getName())) == null) continue;
                if (type != folderType && folderType != null) {
                    folderType = null;
                    break;
                }
                folderType = type;
            }
        }
        return folderType;
    }

    @NotNull
    private CreateResourceActionBase.MyInputValidator createValidator(Project project, final PsiDirectory resDir, final String subdirName) {
        PsiDirectory resSubdir = resDir.findSubdirectory(subdirName);
        if (resSubdir == null) {
            resSubdir = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                public PsiDirectory compute() {
                    return resDir.createSubdirectory(subdirName);
                }
            });
        }
        CreateResourceActionBase.MyInputValidator myInputValidator = new CreateResourceActionBase.MyInputValidator(project, resSubdir);
        if (myInputValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "createValidator"));
        }
        return myInputValidator;
    }

    @Override
    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        CreateTypedResourceFileAction action = this.getActionByDir(directory);
        if (action == null) {
            throw new IllegalArgumentException("Incorrect directory");
        }
        if (this.myRootElement != null && this.myRootElement.length() > 0) {
            PsiElement[] psiElementArray = action.doCreateAndNavigate(newName, directory, this.myRootElement, false, this.myNavigate);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "create"));
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = action.create(newName, directory);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "create"));
        }
        return psiElementArray;
    }

    private CreateTypedResourceFileAction getActionByDir(PsiDirectory directory) {
        String baseDirName = directory.getName();
        int index = baseDirName.indexOf("-");
        if (index >= 0) {
            baseDirName = baseDirName.substring(0, index);
        }
        return this.mySubactions.get(baseDirName);
    }

    @Override
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    @Override
    protected String getCommandName() {
        return AndroidBundle.message("new.resource.command.name", new Object[0]);
    }

    @Override
    @Nullable
    protected String getActionName(PsiDirectory directory, String newName) {
        return CreateResourceFileAction.doGetActionName(directory, newName);
    }

    static String doGetActionName(PsiDirectory directory, String newName) {
        if (FileUtilRt.getExtension((String)newName).length() == 0) {
            newName = newName + ".xml";
        }
        return AndroidBundle.message("new.resource.action.name", directory.getName() + File.separator + newName);
    }

    private static class MyDialog
    extends CreateResourceFileDialog {
        private final CreateResourceFileAction myAction;
        private boolean myNavigate;

        protected MyDialog(@NotNull AndroidFacet facet, Collection<CreateTypedResourceFileAction> actions, @Nullable ResourceFolderType predefinedResourceType, @Nullable String predefinedFileName, @Nullable String predefinedRootElement, @Nullable FolderConfiguration predefinedConfig, boolean chooseFileName, @NotNull CreateResourceFileAction action, @NotNull Module module, boolean chooseModule, @Nullable PsiDirectory resDirectory) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/actions/CreateResourceFileAction$MyDialog", "<init>"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/android/actions/CreateResourceFileAction$MyDialog", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/actions/CreateResourceFileAction$MyDialog", "<init>"));
            }
            super(facet, actions, predefinedResourceType, predefinedFileName, predefinedRootElement, predefinedConfig, chooseFileName, module, chooseModule, resDirectory);
            this.myNavigate = true;
            this.myAction = action;
        }

        @Override
        protected void doOKAction() {
            this.myAction.myRootElement = this.getRootElement();
            this.myAction.myNavigate = this.myNavigate;
            super.doOKAction();
        }

        public void setNavigate(boolean navigate) {
            this.myNavigate = navigate;
        }
    }
}

