/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.logcat;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.logcat.AndroidLogcatReceiver;
import org.jetbrains.android.run.LoggingReceiver;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLogcatUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.AndroidDebugRunner");
    private static Map<String, Log.LogLevel> ourLogLevels;

    private AndroidLogcatUtil() {
    }

    @Nullable
    public static synchronized Log.LogLevel getLogLevel(String s) {
        if (ourLogLevels == null) {
            ourLogLevels = new HashMap<String, Log.LogLevel>();
            for (Log.LogLevel level : Log.LogLevel.values()) {
                ourLogLevels.put(level.name(), level);
            }
        }
        return ourLogLevels.get(s);
    }

    private static void startLogging(IDevice device, AndroidOutputReceiver receiver) throws IOException, ShellCommandUnresponsiveException, AdbCommandRejectedException, TimeoutException {
        AndroidUtils.executeCommandOnDevice(device, "logcat -v long", receiver, true);
    }

    public static void clearLogcat(final Project project, IDevice device) {
        try {
            AndroidUtils.executeCommandOnDevice(device, "logcat -c", new LoggingReceiver(LOG), false);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)("Error: " + e.getMessage()), (String)AndroidBundle.message("android.logcat.error.dialog.title", new Object[0]));
                }
            });
        }
    }

    @Nullable
    public static Pair<Reader, Writer> startLoggingThread(final Project project, final IDevice device, final boolean clearLogcat, final @NotNull LogConsoleBase console) {
        PipedReader logReader;
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/android/logcat/AndroidLogcatUtil", "startLoggingThread"));
        }
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                console.clear();
            }
        });
        PipedWriter logWriter = new PipedWriter();
        final AndroidLogcatReceiver receiver = new AndroidLogcatReceiver(device, logWriter);
        try {
            logReader = new PipedReader(logWriter){

                @Override
                public void close() throws IOException {
                    super.close();
                    receiver.cancel();
                }

                @Override
                public synchronized boolean ready() {
                    try {
                        return super.ready();
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                        return false;
                    }
                }
            };
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            console.writeToConsole("Unable to run logcat. IOException: " + e.getMessage() + '\n', ProcessOutputTypes.STDERR);
            return null;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        if (clearLogcat) {
                            AndroidLogcatUtil.clearLogcat(project, device);
                        }
                        try {
                            AndroidLogcatUtil.startLogging(device, receiver);
                        }
                        catch (Exception e) {
                            LOG.info((Throwable)e);
                            console.writeToConsole(e.getMessage() + '\n', ProcessOutputTypes.STDERR);
                        }
                    }
                });
            }
        });
        return new Pair((Object)logReader, (Object)logWriter);
    }
}

