/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run.testing;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.configuration.MethodListDlg;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.android.run.AndroidInheritingClassBrowser;
import org.jetbrains.android.run.AndroidInheritingClassVisibilityChecker;
import org.jetbrains.android.run.ConfigurationSpecificEditor;
import org.jetbrains.android.run.testing.AndroidTestClassBrowser;
import org.jetbrains.android.run.testing.AndroidTestClassVisibilityChecker;
import org.jetbrains.android.run.testing.AndroidTestRunConfiguration;
import org.jetbrains.android.util.AndroidBundle;

class TestRunParameters
implements ConfigurationSpecificEditor<AndroidTestRunConfiguration> {
    private JRadioButton myAllInPackageButton;
    private JRadioButton myClassButton;
    private JRadioButton myTestMethodButton;
    private JRadioButton myAllInModuleButton;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myPackageComponent;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myClassComponent;
    private LabeledComponent<TextFieldWithBrowseButton> myMethodComponent;
    private JPanel myPanel;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myRunnerComponent;
    private JBLabel myLabelTest;
    private final JRadioButton[] myTestingType2RadioButton = new JRadioButton[4];
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private JComponent anchor;

    TestRunParameters(Project project, ConfigurationModuleSelector moduleSelector) {
        this.myProject = project;
        this.myModuleSelector = moduleSelector;
        this.$$$setupUI$$$();
        this.myPackageComponent.setComponent((JComponent)new EditorTextFieldWithBrowseButton(project, false));
        TestRunParameters.bind(this.myPackageComponent, new MyPackageBrowser());
        this.myClassComponent.setComponent((JComponent)new EditorTextFieldWithBrowseButton(project, true, (JavaCodeFragment.VisibilityChecker)new AndroidTestClassVisibilityChecker(moduleSelector)));
        TestRunParameters.bind(this.myClassComponent, new AndroidTestClassBrowser(project, moduleSelector, AndroidBundle.message("android.browse.test.class.dialog.title", new Object[0]), false));
        this.myRunnerComponent.setComponent((JComponent)new EditorTextFieldWithBrowseButton(project, true, (JavaCodeFragment.VisibilityChecker)new AndroidInheritingClassVisibilityChecker(this.myProject, moduleSelector, "android.app.Instrumentation")));
        TestRunParameters.bind(this.myRunnerComponent, new AndroidInheritingClassBrowser(project, moduleSelector, "android.app.Instrumentation", AndroidBundle.message("android.browse.instrumentation.class.dialog.title", new Object[0]), true));
        TestRunParameters.bind(this.myMethodComponent, new MyMethodBrowser());
        this.addTestingType(0, this.myAllInModuleButton);
        this.addTestingType(1, this.myAllInPackageButton);
        this.addTestingType(2, this.myClassButton);
        this.addTestingType(3, this.myTestMethodButton);
        this.setAnchor((JComponent)this.myPackageComponent.getLabel());
    }

    private void addTestingType(final int type, JRadioButton button) {
        this.myTestingType2RadioButton[type] = button;
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestRunParameters.this.updateLabelComponents(type);
            }
        });
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myPackageComponent.setAnchor(anchor);
        this.myClassComponent.setAnchor(anchor);
        this.myMethodComponent.setAnchor(anchor);
        this.myLabelTest.setAnchor(anchor);
    }

    private static void bind(LabeledComponent<? extends ComponentWithBrowseButton<?>> labeledComponent, BrowseModuleValueActionListener browser) {
        browser.setField((ComponentWithBrowseButton)labeledComponent.getComponent());
    }

    private void updateButtonsAndLabelComponents(int type) {
        this.myAllInModuleButton.setSelected(type == 0);
        this.myAllInPackageButton.setSelected(type == 1);
        this.myClassButton.setSelected(type == 2);
        this.myTestMethodButton.setSelected(type == 3);
        this.updateLabelComponents(type);
    }

    private void updateLabelComponents(int type) {
        this.myPackageComponent.setVisible(type == 1);
        this.myClassComponent.setVisible(type == 2 || type == 3);
        this.myMethodComponent.setVisible(type == 3);
    }

    private int getTestingType() {
        int myTestingType2RadioButtonLength = this.myTestingType2RadioButton.length;
        for (int i = 0; i < myTestingType2RadioButtonLength; ++i) {
            JRadioButton button = this.myTestingType2RadioButton[i];
            if (!button.isSelected()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void applyTo(AndroidTestRunConfiguration configuration) {
        configuration.TESTING_TYPE = this.getTestingType();
        configuration.CLASS_NAME = ((EditorTextFieldWithBrowseButton)this.myClassComponent.getComponent()).getText();
        configuration.METHOD_NAME = ((TextFieldWithBrowseButton)this.myMethodComponent.getComponent()).getText();
        configuration.PACKAGE_NAME = ((EditorTextFieldWithBrowseButton)this.myPackageComponent.getComponent()).getText();
        configuration.INSTRUMENTATION_RUNNER_CLASS = ((EditorTextFieldWithBrowseButton)this.myRunnerComponent.getComponent()).getText();
    }

    @Override
    public void resetFrom(AndroidTestRunConfiguration configuration) {
        this.updateButtonsAndLabelComponents(configuration.TESTING_TYPE);
        ((EditorTextFieldWithBrowseButton)this.myPackageComponent.getComponent()).setText(configuration.PACKAGE_NAME);
        ((EditorTextFieldWithBrowseButton)this.myClassComponent.getComponent()).setText(configuration.CLASS_NAME);
        ((TextFieldWithBrowseButton)this.myMethodComponent.getComponent()).setText(configuration.METHOD_NAME);
        ((EditorTextFieldWithBrowseButton)this.myRunnerComponent.getComponent()).setText(configuration.INSTRUMENTATION_RUNNER_CLASS);
    }

    @Override
    public Component getComponent() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        LabeledComponent labeledComponent4;
        JRadioButton jRadioButton;
        JBLabel jBLabel;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myAllInPackageButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.all.in.package.radio"));
        jRadioButton4.setActionCommand(ResourceBundle.getBundle("messages/ExecutionBundle").getString("jnit.configuration.all.tests.in.package.radio"));
        jPanel.add((Component)jRadioButton4, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClassButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.class.radio"));
        jRadioButton3.setActionCommand(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.test.class.radio"));
        jRadioButton3.setSelected(false);
        ((Component)jRadioButton3).setEnabled(true);
        jPanel.add((Component)jRadioButton3, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestMethodButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.method.radio"));
        jRadioButton2.setActionCommand(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.test.method.radio"));
        jRadioButton2.setSelected(false);
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLabelTest = jBLabel = new JBLabel();
        jBLabel.setIconTextGap(4);
        jBLabel.setHorizontalAlignment(2);
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.configure.junit.test.label"));
        jBLabel.setHorizontalTextPosition(2);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAllInModuleButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.all.in.module.radio"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPackageComponent = labeledComponent4 = new LabeledComponent();
        labeledComponent4.setText(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.package.label"));
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setComponentClass("javax.swing.JPanel");
        jPanel.add((Component)labeledComponent4, new GridConstraints(1, 0, 1, 6, 0, 1, 3, 0, null, null, null));
        this.myClassComponent = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setText(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.class.label"));
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setComponentClass("javax.swing.JPanel");
        jPanel.add((Component)labeledComponent3, new GridConstraints(2, 0, 1, 6, 0, 1, 3, 0, null, null, null));
        this.myMethodComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setText(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.method.label"));
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton$NoPathCompletion");
        jPanel.add((Component)labeledComponent2, new GridConstraints(3, 0, 1, 6, 0, 1, 3, 0, null, null, null));
        this.myRunnerComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setText(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.test.run.configuration.instrumentation.label"));
        labeledComponent.setLabelLocation("North");
        labeledComponent.setEnabled(true);
        labeledComponent.setComponentClass("javax.swing.JPanel");
        jPanel.add((Component)labeledComponent, new GridConstraints(4, 0, 1, 6, 0, 1, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyMethodBrowser
    extends BrowseModuleValueActionListener {
        public MyMethodBrowser() {
            super(TestRunParameters.this.myProject);
        }

        protected String showDialog() {
            PsiMethod method;
            String className = ((EditorTextFieldWithBrowseButton)TestRunParameters.this.myClassComponent.getComponent()).getText();
            if (className.trim().length() == 0) {
                Messages.showMessageDialog((Component)this.getField(), (String)ExecutionBundle.message((String)"set.class.name.message", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"cannot.browse.method.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                return null;
            }
            PsiClass testClass = TestRunParameters.this.myModuleSelector.findClass(className);
            if (testClass == null) {
                Messages.showMessageDialog((Component)this.getField(), (String)ExecutionBundle.message((String)"class.does.not.exists.error.message", (Object[])new Object[]{className}), (String)ExecutionBundle.message((String)"cannot.browse.method.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                return null;
            }
            MethodListDlg dialog = new MethodListDlg(testClass, (Condition)new JUnitUtil.TestMethodFilter(testClass), this.getField());
            dialog.show();
            if (dialog.isOK() && (method = dialog.getSelected()) != null) {
                return method.getName();
            }
            return null;
        }
    }

    private class MyPackageBrowser
    extends BrowseModuleValueActionListener {
        protected MyPackageBrowser() {
            super(TestRunParameters.this.myProject);
        }

        protected String showDialog() {
            Module module = TestRunParameters.this.myModuleSelector.getModule();
            if (module == null) {
                Messages.showErrorDialog((Component)TestRunParameters.this.myPanel, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]));
                return null;
            }
            PackageChooserDialog dialog = new PackageChooserDialog(ExecutionBundle.message((String)"choose.package.dialog.title", (Object[])new Object[0]), module);
            dialog.selectPackage(((EditorTextFieldWithBrowseButton)TestRunParameters.this.myPackageComponent.getComponent()).getText());
            dialog.show();
            PsiPackage aPackage = dialog.getSelectedPackage();
            return aPackage != null ? aPackage.getQualifiedName() : null;
        }
    }
}

