/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.diff.ElementWithBranchComparer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class FileWithBranchComparer
extends ElementWithBranchComparer {
    @NotNull
    private final Ref<byte[]> content;
    @NotNull
    private final StringBuilder remoteTitleBuilder;
    @NotNull
    private final Ref<Boolean> success;

    public FileWithBranchComparer(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull String branchUrl, long branchRevision) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/diff/FileWithBranchComparer", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/idea/svn/diff/FileWithBranchComparer", "<init>"));
        }
        if (branchUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchUrl", "org/jetbrains/idea/svn/diff/FileWithBranchComparer", "<init>"));
        }
        super(project, virtualFile, branchUrl, branchRevision);
        this.content = new Ref();
        this.remoteTitleBuilder = new StringBuilder();
        this.success = new Ref();
    }

    @Override
    protected void beforeCompare() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setIndeterminate(true);
        }
    }

    @Override
    protected void compare() throws SVNException, VcsException {
        this.remoteTitleBuilder.append(this.myElementUrl);
        this.content.set((Object)SvnUtil.getFileContents(this.myVcs, SvnTarget.fromURL((SVNURL)this.myElementUrl), SVNRevision.HEAD, SVNRevision.UNDEFINED));
        this.success.set((Object)true);
    }

    @Override
    protected void showResult() {
        if (!this.success.isNull()) {
            SimpleDiffRequest req = new SimpleDiffRequest(this.myProject, SvnBundle.message("compare.with.branch.diff.title", new Object[0]));
            req.setContents((DiffContent)new SimpleContent(CharsetToolkit.bytesToString((byte[])((byte[])this.content.get()), (Charset)this.myVirtualFile.getCharset())), (DiffContent)new FileContent(this.myProject, this.myVirtualFile));
            req.setContentTitles(this.remoteTitleBuilder.toString(), this.myVirtualFile.getPresentableUrl());
            DiffManager.getInstance().getDiffTool().show((DiffRequest)req);
        }
    }

    @Override
    public String getTitle() {
        return SvnBundle.message("compare.with.branch.progress.loading.content", new Object[0]);
    }
}

