/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.TaskDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.integrate.CheckRepositorySupportsMergeInfoTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.MergeInitChecksTask;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SourceUrlCorrectionTask;
import org.tmatesoft.svn.core.SVNException;

public class QuickMerge {
    @NotNull
    private final MergeContext myMergeContext;
    private final Continuation myContinuation;
    private QuickMergeInteraction myInteraction;

    public QuickMerge(@NotNull MergeContext mergeContext) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/QuickMerge", "<init>"));
        }
        this.myMergeContext = mergeContext;
        this.myContinuation = Continuation.createFragmented((Project)mergeContext.getProject(), (boolean)true);
    }

    public void execute(@NotNull QuickMergeInteraction interaction, TaskDescriptor ... finalTasks) {
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/QuickMerge", "execute"));
        }
        if (finalTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalTasks", "org/jetbrains/idea/svn/integrate/QuickMerge", "execute"));
        }
        this.myInteraction = interaction;
        this.myInteraction.setTitle(this.myMergeContext.getTitle());
        FileDocumentManager.getInstance().saveAllDocuments();
        LinkedList<TaskDescriptor> tasks = new LinkedList<TaskDescriptor>();
        tasks.add(new MergeInitChecksTask(this.myMergeContext, this.myInteraction));
        tasks.add(new SourceUrlCorrectionTask(this.myMergeContext, this.myInteraction));
        tasks.add(new CheckRepositorySupportsMergeInfoTask(this.myMergeContext, this.myInteraction));
        if (finalTasks.length > 0) {
            tasks.addAll(Arrays.asList(finalTasks));
        }
        this.myContinuation.addExceptionHandler(VcsException.class, (Consumer)new Consumer<VcsException>(){

            public void consume(VcsException e) {
                QuickMerge.this.myInteraction.showErrors(QuickMerge.this.myMergeContext.getTitle(), Collections.singletonList(e));
            }
        });
        this.myContinuation.addExceptionHandler(SVNException.class, (Consumer)new Consumer<SVNException>(){

            public void consume(SVNException e) {
                QuickMerge.this.myInteraction.showErrors(QuickMerge.this.myMergeContext.getTitle(), Collections.singletonList(new VcsException((Throwable)e)));
            }
        });
        this.myContinuation.addExceptionHandler(RuntimeException.class, (Consumer)new Consumer<RuntimeException>(){

            public void consume(RuntimeException e) {
                QuickMerge.this.myInteraction.showError(e);
            }
        });
        this.myContinuation.run(tasks);
    }
}

