/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.SmartList;
import com.intellij.util.xml.NanoXmlUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import icons.XpathIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import net.n3.nanoxml.IXMLBuilder;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltSupport {
    public static final String XALAN_EXTENSION_PREFIX = "http://xml.apache.org/xalan/";
    public static final String XSLT_NS = "http://www.w3.org/1999/XSL/Transform";
    public static final String PLUGIN_EXTENSIONS_NS = "urn:idea:xslt-plugin#extensions";
    public static final Key<ParameterizedCachedValue<XsltChecker.LanguageLevel, PsiFile>> FORCE_XSLT_KEY = Key.create((String)"FORCE_XSLT");
    private static final Map<String, String> XPATH_ATTR_MAP = new THashMap(10);
    private static final Map<String, Set<String>> XPATH_AVT_MAP = new THashMap(10);

    private XsltSupport() {
    }

    @NotNull
    public static PsiFile[] getFiles(XmlAttribute attribute) {
        XmlAttributeValue value = attribute.getValueElement();
        if (value != null) {
            SmartList files = new SmartList();
            InjectedLanguageUtil.enumerate((PsiElement)value, (PsiLanguageInjectionHost.InjectedPsiVisitor)new PsiLanguageInjectionHost.InjectedPsiVisitor((List)files){
                final /* synthetic */ List val$files;
                {
                    this.val$files = list;
                }

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "org/intellij/lang/xpath/xslt/XsltSupport$1", "visit"));
                    }
                    if (places == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "org/intellij/lang/xpath/xslt/XsltSupport$1", "visit"));
                    }
                    if (injectedPsi instanceof XPathFile) {
                        this.val$files.add(injectedPsi);
                    }
                }
            });
            PsiFile[] psiFileArray = files.isEmpty() ? PsiFile.EMPTY_ARRAY : PsiUtilCore.toPsiFileArray((Collection)files);
            if (psiFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/XsltSupport", "getFiles"));
            }
            return psiFileArray;
        }
        if (PsiFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/XsltSupport", "getFiles"));
        }
        return PsiFile.EMPTY_ARRAY;
    }

    public static boolean isXsltAttribute(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isXsltAttribute"));
        }
        return XsltSupport.isXsltTag(attribute.getParent());
    }

    public static boolean isXsltTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/lang/xpath/xslt/XsltSupport", "isXsltTag"));
        }
        if (!tag.isValid()) {
            return false;
        }
        String s = tag.getNamespace();
        return XSLT_NS.equals(s) || s.startsWith(XALAN_EXTENSION_PREFIX);
    }

    private static boolean isXsltCoreTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/lang/xpath/xslt/XsltSupport", "isXsltCoreTag"));
        }
        return tag.isValid() && XSLT_NS.equals(tag.getNamespace());
    }

    public static boolean isXPathAttribute(@NotNull XmlAttribute attribute) {
        XsltChecker.LanguageLevel level;
        PsiFile file;
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isXPathAttribute"));
        }
        if (attribute.getValueElement() == null) {
            return false;
        }
        String name = attribute.getName();
        if (XsltSupport.isXsltAttribute(attribute)) {
            String tagName = attribute.getParent().getLocalName();
            String s = XPATH_ATTR_MAP.get(name);
            if (!(s != null && s.length() <= 0 || tagName.equals(s) || XsltSupport.isAttributeValueTemplate(attribute, true))) {
                return false;
            }
        } else if (!XsltSupport.isAttributeValueTemplate(attribute, false)) {
            return false;
        }
        return (file = attribute.getContainingFile()) != null && (level = XsltSupport.getXsltLanguageLevel(file)) != XsltChecker.LanguageLevel.NONE;
    }

    private static boolean isAttributeValueTemplate(@NotNull XmlAttribute attribute, boolean isXsltAttribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isAttributeValueTemplate"));
        }
        return (!isXsltAttribute || XsltSupport.mayBeAVT(attribute)) && XsltSupport.getAVTOffset(attribute.getValue(), 0) != -1;
    }

    public static boolean isVariableOrParamName(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isVariableOrParamName"));
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isVariableOrParam(attribute.getParent());
    }

    public static boolean isVariableOrParam(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/lang/xpath/xslt/XsltSupport", "isVariableOrParam"));
        }
        String localName = tag.getLocalName();
        return ("variable".equals(localName) || "param".equals(localName)) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isVariable(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isVariable"));
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isVariable(attribute.getParent());
    }

    public static boolean isVariable(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/lang/xpath/xslt/XsltSupport", "isVariable"));
        }
        String localName = tag.getLocalName();
        return "variable".equals(localName) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isParam(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isParam"));
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isParam(attribute.getParent());
    }

    public static boolean isParam(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/lang/xpath/xslt/XsltSupport", "isParam"));
        }
        String localName = tag.getLocalName();
        return "param".equals(localName) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isPatternAttribute(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isPatternAttribute"));
        }
        if (!XsltSupport.isXsltAttribute(attribute)) {
            return false;
        }
        String name = attribute.getName();
        if ("match".equals(name)) {
            return true;
        }
        if ("count".equals(name) || "from".equals(name)) {
            return "number".equals(attribute.getParent().getLocalName());
        }
        return false;
    }

    public static boolean isTemplateCall(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/lang/xpath/xslt/XsltSupport", "isTemplateCall"));
        }
        return "call-template".equals(tag.getLocalName()) && XsltSupport.hasNameAttribute(tag) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isFunction(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/lang/xpath/xslt/XsltSupport", "isFunction"));
        }
        return "function".equals(tag.getLocalName()) && XsltSupport.hasNameAttribute(tag) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isApplyTemplates(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/lang/xpath/xslt/XsltSupport", "isApplyTemplates"));
        }
        String localName = tag.getLocalName();
        return "apply-templates".equals(localName) && XsltSupport.isXsltCoreTag(tag);
    }

    private static boolean hasNameAttribute(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/lang/xpath/xslt/XsltSupport", "hasNameAttribute"));
        }
        return tag.getAttribute("name", null) != null;
    }

    public static boolean isTemplateCallName(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isTemplateCallName"));
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isTemplateCall(attribute.getParent());
    }

    private static boolean isXsltNameAttribute(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isXsltNameAttribute"));
        }
        return "name".equals(attribute.getName()) && XsltSupport.isXsltAttribute(attribute);
    }

    public static boolean isTemplateName(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isTemplateName"));
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isTemplate(attribute.getParent());
    }

    public static boolean isFunctionName(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isFunctionName"));
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isFunction(attribute.getParent());
    }

    public static boolean isTemplate(@NotNull XmlTag element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/XsltSupport", "isTemplate"));
        }
        return XsltSupport.isTemplate(element, true);
    }

    public static boolean isTemplate(@NotNull XmlTag element, boolean requireName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/XsltSupport", "isTemplate"));
        }
        return "template".equals(element.getLocalName()) && (!requireName || XsltSupport.hasNameAttribute(element)) && XsltSupport.isXsltCoreTag(element);
    }

    public static boolean isXsltFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/intellij/lang/xpath/xslt/XsltSupport", "isXsltFile"));
        }
        if (psiFile.getFileType() != StdFileTypes.XML) {
            return false;
        }
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        XsltChecker.LanguageLevel level = XsltSupport.getXsltLanguageLevel(psiFile);
        return level != XsltChecker.LanguageLevel.NONE;
    }

    public static XsltChecker.LanguageLevel getXsltLanguageLevel(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/intellij/lang/xpath/xslt/XsltSupport", "getXsltLanguageLevel"));
        }
        CachedValuesManager mgr = CachedValuesManager.getManager((Project)psiFile.getProject());
        return (XsltChecker.LanguageLevel)((Object)mgr.getParameterizedCachedValue((UserDataHolder)psiFile, FORCE_XSLT_KEY, XsltSupportProvider.INSTANCE, false, (Object)psiFile));
    }

    public static boolean isXsltRootTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/lang/xpath/xslt/XsltSupport", "isXsltRootTag"));
        }
        String localName = tag.getLocalName();
        return ("stylesheet".equals(localName) || "transform".equals(localName)) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isTemplateCallParamName(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "isTemplateCallParamName"));
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isTemplateCallParam(attribute.getParent());
    }

    private static boolean isTemplateCallParam(@NotNull XmlTag parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/intellij/lang/xpath/xslt/XsltSupport", "isTemplateCallParam"));
        }
        return "with-param".equals(parent.getLocalName()) && XsltSupport.hasNameAttribute(parent) && XsltSupport.isXsltCoreTag(parent);
    }

    public static boolean isTopLevelElement(XmlTag tag) {
        XmlTag p = tag;
        while ((p = p.getParentTag()) != null) {
            if (!XsltSupport.isXsltTag(p)) continue;
            return XsltSupport.isXsltRootTag(p);
        }
        return false;
    }

    public static boolean isIncludeOrImportHref(XmlAttribute xmlattribute) {
        if (xmlattribute == null || !XsltSupport.isXsltAttribute(xmlattribute)) {
            return false;
        }
        String localName = xmlattribute.getParent().getLocalName();
        return XsltSupport.isIncludeOrImport(localName) && "href".equals(xmlattribute.getName());
    }

    private static boolean isIncludeOrImport(String localName) {
        return "import".equals(localName) || "include".equals(localName);
    }

    public static boolean isIncludeOrImport(XmlTag tag) {
        if (tag == null) {
            return false;
        }
        return XsltSupport.isIncludeOrImport(tag.getLocalName()) && XsltSupport.isXsltCoreTag(tag) && tag.getAttribute("href", null) != null;
    }

    public static boolean isImport(XmlTag tag) {
        if (tag == null) {
            return false;
        }
        return "import".equals(tag.getLocalName()) && XsltSupport.isXsltCoreTag(tag) && tag.getAttribute("href", null) != null;
    }

    @Nullable
    public static PsiElement getAttValueToken(@NotNull XmlAttribute attribute) {
        PsiElement firstChild;
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "getAttValueToken"));
        }
        XmlAttributeValue valueElement = attribute.getValueElement();
        if (valueElement != null && (firstChild = valueElement.getFirstChild()) != null) {
            PsiElement nextSibling = firstChild.getNextSibling();
            return nextSibling instanceof XmlToken && ((XmlToken)nextSibling).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN ? nextSibling : null;
        }
        return null;
    }

    public static boolean isMode(XmlAttribute xmlattribute) {
        if ("mode".equals(xmlattribute.getName())) {
            XmlTag parent = xmlattribute.getParent();
            return XsltSupport.isApplyTemplates(parent) || XsltSupport.isTemplate(parent, false);
        }
        return false;
    }

    public static int getAVTOffset(String value, int i) {
        while ((i = value.indexOf(123, i)) != -1 && i == value.indexOf("{{", i) && (i += 2) != -1) {
        }
        return i;
    }

    public static boolean mayBeAVT(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/XsltSupport", "mayBeAVT"));
        }
        if (XsltSupport.isXsltAttribute(attribute)) {
            String tagName = attribute.getParent().getLocalName();
            Set<String> allowedAttrs = XPATH_AVT_MAP.get(tagName);
            if (allowedAttrs == null) {
                return XsltSupport.isExtensionAvtAttribute(attribute);
            }
            return allowedAttrs.contains(attribute.getName());
        }
        return true;
    }

    private static boolean isExtensionAvtAttribute(XmlAttribute attribute) {
        String namespace = attribute.getParent().getNamespace();
        return namespace.startsWith(XALAN_EXTENSION_PREFIX) && "file".equals(attribute.getName());
    }

    public static Icon createXsltIcon(Icon icon) {
        return LayeredIcon.create((Icon)icon, (Icon)XpathIcons.Xslt_filetype_overlay);
    }

    static {
        XPATH_ATTR_MAP.put("select", "");
        XPATH_ATTR_MAP.put("match", "");
        XPATH_ATTR_MAP.put("test", "");
        XPATH_ATTR_MAP.put("use-when", "");
        XPATH_ATTR_MAP.put("group-by", "");
        XPATH_ATTR_MAP.put("group-adjacent", "");
        XPATH_ATTR_MAP.put("count", "number");
        XPATH_ATTR_MAP.put("from", "number");
        XPATH_ATTR_MAP.put("value", "number");
        XPATH_ATTR_MAP.put("use", "key");
        XPATH_AVT_MAP.put("element", (Set<String>)new THashSet(Arrays.asList("name", "namespace")));
        XPATH_AVT_MAP.put("attribute", (Set<String>)new THashSet(Arrays.asList("name", "namespace")));
        XPATH_AVT_MAP.put("namespace", (Set<String>)new THashSet(Arrays.asList("name")));
        XPATH_AVT_MAP.put("processing-instruction", (Set<String>)new THashSet(Arrays.asList("name")));
        XPATH_AVT_MAP.put("number", (Set<String>)new THashSet(Arrays.asList("format", "lang", "letter-value", "grouping-separator", "grouping-size", "ordinal")));
        XPATH_AVT_MAP.put("sort", (Set<String>)new THashSet(Arrays.asList("lang", "data-type", "order", "case-order", "collation")));
        XPATH_AVT_MAP.put("message", (Set<String>)new THashSet(Arrays.asList("terminate")));
        XPATH_AVT_MAP.put("value-of", (Set<String>)new THashSet(Arrays.asList("separator")));
        XPATH_AVT_MAP.put("result-document", (Set<String>)new THashSet(Arrays.asList("format", "href", "method", "byte-order-mark", "cdata-section-elements", "doctype-public", "doctype-system", "encoding", "escape-uri-attributes", "include-content-type", "indent", "media-type", "normalization-form", "omit-xml-declaration", "standalone", "undeclare-prefixes", "output-version")));
    }

    private static class XsltSupportProvider
    implements ParameterizedCachedValueProvider<XsltChecker.LanguageLevel, PsiFile> {
        public static final ParameterizedCachedValueProvider<XsltChecker.LanguageLevel, PsiFile> INSTANCE = new XsltSupportProvider();

        private XsltSupportProvider() {
        }

        public CachedValueProvider.Result<XsltChecker.LanguageLevel> compute(PsiFile psiFile) {
            XmlTag rootTag;
            XmlDocument doc;
            if (!(psiFile instanceof XmlFile)) {
                return CachedValueProvider.Result.create((Object)((Object)XsltChecker.LanguageLevel.NONE), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            XmlFile xmlFile = (XmlFile)psiFile;
            if (psiFile instanceof PsiFileEx && ((PsiFileEx)psiFile).isContentsLoaded() && (doc = xmlFile.getDocument()) != null && (rootTag = doc.getRootTag()) != null) {
                XmlAttribute v;
                XsltChecker.LanguageLevel level = XsltSupport.isXsltRootTag(rootTag) ? ((v = rootTag.getAttribute("version")) != null ? XsltChecker.getLanguageLevel(v.getValue()) : XsltChecker.LanguageLevel.NONE) : ((v = rootTag.getAttribute("version", XsltSupport.XSLT_NS)) != null ? XsltChecker.getLanguageLevel(v.getValue()) : XsltChecker.LanguageLevel.NONE);
                return CachedValueProvider.Result.create((Object)((Object)level), (Object[])new Object[]{rootTag});
            }
            XsltChecker xsltChecker = new XsltChecker();
            NanoXmlUtil.parseFile((PsiFile)psiFile, (IXMLBuilder)xsltChecker);
            return CachedValueProvider.Result.create((Object)((Object)xsltChecker.getLanguageLevel()), (Object[])new Object[]{psiFile});
        }
    }
}

