/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ResourceBundlePropertyStructureViewElement
implements StructureViewTreeElement,
ResourceBundleEditorViewElement {
    private final ResourceBundle myResourceBundle;
    private final IProperty myProperty;
    private String myPresentableName;
    private static final TextAttributesKey INCOMPLETE_PROPERTY_KEY;

    public ResourceBundlePropertyStructureViewElement(ResourceBundle resourceBundle, IProperty property) {
        this.myResourceBundle = resourceBundle;
        this.myProperty = property;
    }

    public IProperty getProperty() {
        return this.myProperty;
    }

    @Override
    public PsiElement[] getPsiElements() {
        return new PsiElement[]{this.getValue()};
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    public PsiElement getValue() {
        return this.myProperty.getPsiElement();
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement", "getChildren"));
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ColoredItemPresentation coloredItemPresentation = new ColoredItemPresentation(){

            public String getPresentableText() {
                return ResourceBundlePropertyStructureViewElement.this.myPresentableName == null ? ResourceBundlePropertyStructureViewElement.this.myProperty.getName() : ResourceBundlePropertyStructureViewElement.this.myPresentableName;
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return PlatformIcons.PROPERTY_ICON;
            }

            public TextAttributesKey getTextAttributesKey() {
                boolean isComplete = PropertiesUtil.isPropertyComplete(ResourceBundlePropertyStructureViewElement.this.myResourceBundle, ResourceBundlePropertyStructureViewElement.this.myProperty.getName());
                if (isComplete) {
                    return PropertiesHighlighter.PROPERTY_KEY;
                }
                return INCOMPLETE_PROPERTY_KEY;
            }
        };
        if (coloredItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement", "getPresentation"));
        }
        return coloredItemPresentation;
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    static {
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_KEY).clone();
        textAttributes.setForegroundColor(Color.red);
        INCOMPLETE_PROPERTY_KEY = TextAttributesKey.createTextAttributesKey((String)"INCOMPLETE_PROPERTY_KEY", (TextAttributes)textAttributes);
    }
}

