/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.gradle.tooling.internal.consumer.connection.NonCancellableConsumerConnectionAdapter;
import org.jetbrains.plugins.gradle.service.notification.OpenGradleSettingsCallback;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleLog {
    public static final Logger LOG = Logger.getInstance(GradleLog.class);
    private static final String GRADLE_PROVIDER_DOES_NOT_SUPPORT_CANCELLATION_MESSAGE = "Note: Version of Gradle provider does not support cancellation. Upgrade your Gradle build.";

    private GradleLog() {
    }

    public static class GradleLogbackAppender
    extends AppenderBase<ILoggingEvent> {
        protected void append(ILoggingEvent event) {
            ThrowableProxy throwableProxy = event.getThrowableProxy() instanceof ThrowableProxy ? (ThrowableProxy)event.getThrowableProxy() : null;
            Throwable throwable = throwableProxy == null ? null : throwableProxy.getThrowable();
            switch (event.getLevel().toInt()) {
                case -2147483648: 
                case 5000: 
                case 10000: {
                    LOG.debug(event.getFormattedMessage(), throwable);
                    break;
                }
                case 20000: {
                    LOG.info(event.getFormattedMessage(), throwable);
                    break;
                }
                case 30000: {
                    LOG.warn(event.getFormattedMessage(), throwable);
                    break;
                }
                case 40000: {
                    LOG.error(event.getFormattedMessage(), throwable);
                    break;
                }
                case 0x7FFFFFFF: {
                    break;
                }
                default: {
                    LOG.debug(event.getFormattedMessage(), throwable);
                }
            }
            if (NonCancellableConsumerConnectionAdapter.class.getName().equals(event.getLoggerName()) && GradleLog.GRADLE_PROVIDER_DOES_NOT_SUPPORT_CANCELLATION_MESSAGE.equals(event.getMessage())) {
                ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
                List canceledTasks = processingManager.findTasksOfState(GradleConstants.SYSTEM_ID, new ExternalSystemTaskState[]{ExternalSystemTaskState.CANCELING, ExternalSystemTaskState.CANCELED});
                for (ExternalSystemTask canceledTask : canceledTasks) {
                    Project project = canceledTask.getId().findProject();
                    if (project == null) continue;
                    String errorMessage = String.format("%s <a href=\"%s\">Open Gradle settings</a>", "Configured version of Gradle does not support cancellation. Please, use Gradle 2.1 or newer.\n", "open_gradle_settings");
                    NotificationData notification = new NotificationData("Gradle supports cancellation since 2.1 version", errorMessage, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
                    notification.setListener("open_gradle_settings", (NotificationListener)new OpenGradleSettingsCallback(project));
                    notification.setBalloonNotification(true);
                    ExternalSystemNotificationManager.getInstance((Project)project).showNotification(GradleConstants.SYSTEM_ID, notification);
                }
            }
        }
    }
}

