/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import org.jetbrains.annotations.NotNull;

public class ApplicationManager {
    protected static Application ourApplication = null;

    public static Application getApplication() {
        return ourApplication;
    }

    private static void setApplication(@NotNull Application instance) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        ourApplication = instance;
        CachedSingletonsRegistry.cleanupCachedFields();
    }

    public static void setApplication(@NotNull Application instance, @NotNull Disposable parent) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        final Application old = ourApplication;
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                if (old != null) {
                    ApplicationManager.setApplication(old);
                }
            }
        });
        ApplicationManager.setApplication(instance);
    }

    public static void setApplication(@NotNull Application instance, @NotNull Getter<FileTypeRegistry> fileTypeRegistryGetter, @NotNull Getter<EncodingRegistry> encodingRegistryGetter, @NotNull Disposable parent) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        if (fileTypeRegistryGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeRegistryGetter", "com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        if (encodingRegistryGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encodingRegistryGetter", "com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        final Application old = ourApplication;
        final Getter<FileTypeRegistry> oldFileTypeRegistry = FileTypeRegistry.ourInstanceGetter;
        final Getter<EncodingRegistry> oldEncodingRegistry = EncodingRegistry.ourInstanceGetter;
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                if (old != null) {
                    ApplicationManager.setApplication(old);
                    FileTypeRegistry.ourInstanceGetter = oldFileTypeRegistry;
                    EncodingRegistry.ourInstanceGetter = oldEncodingRegistry;
                }
            }
        });
        ApplicationManager.setApplication(instance);
        FileTypeRegistry.ourInstanceGetter = fileTypeRegistryGetter;
        EncodingRegistry.ourInstanceGetter = encodingRegistryGetter;
    }
}

