/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InlinePropertyHandler
extends JavaInlineActionHandler {
    public static final String REFACTORING_NAME = PropertiesBundle.message((String)"inline.property.refactoring", (Object[])new Object[0]);
    public static final String REFACTORING_ID = "refactoring.inline.property";

    public boolean canInlineElement(PsiElement element) {
        if (element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.STRING_LITERAL) {
            Object[] references = element.getParent().getReferences();
            return ContainerUtil.find((Object[])references, (Condition)FilteringIterator.instanceOf(PropertyReference.class)) != null;
        }
        return element instanceof IProperty;
    }

    public void inlineElement(final Project project, Editor editor, PsiElement psiElement) {
        if (!(psiElement instanceof IProperty)) {
            return;
        }
        IProperty property = (IProperty)psiElement;
        final String propertyValue = property.getValue();
        if (propertyValue == null) {
            return;
        }
        final List occurrences = Collections.synchronizedList(ContainerUtil.newArrayList());
        final Set<PsiFile> containingFiles = Collections.synchronizedSet(new HashSet());
        containingFiles.add(psiElement.getContainingFile());
        boolean result = ReferencesSearch.search((PsiElement)psiElement).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference psiReference) {
                PsiElement element = psiReference.getElement();
                PsiElement parent = element.getParent();
                if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression && ((PsiExpressionList)parent).getExpressions().length == 1) {
                    occurrences.add(parent.getParent());
                    containingFiles.add(element.getContainingFile());
                    return true;
                }
                return false;
            }
        });
        if (!result) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Property has non-method usages", (String)REFACTORING_NAME, null);
        }
        if (occurrences.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Property has no usages", (String)REFACTORING_NAME, null);
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            String occurrencesString = RefactoringBundle.message((String)"occurrences.string", (Object[])new Object[]{occurrences.size()});
            String question = PropertiesBundle.message((String)"inline.property.confirmation", (Object[])new Object[]{property.getName(), propertyValue}) + " " + occurrencesString;
            RefactoringMessageDialog dialog = new RefactoringMessageDialog(REFACTORING_NAME, question, "refactoring.inlineVariable", "OptionPane.questionIcon", true, project);
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
        }
        final RefactoringEventData data = new RefactoringEventData();
        data.addElement(psiElement.copy());
        new WriteCommandAction.Simple(project, REFACTORING_NAME, containingFiles.toArray(new PsiFile[containingFiles.size()])){

            protected void run() throws Throwable {
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(InlinePropertyHandler.REFACTORING_ID, data);
                PsiLiteral stringLiteral = (PsiLiteral)JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createExpressionFromText("\"" + StringUtil.escapeStringCharacters((String)propertyValue) + "\"", null);
                for (PsiElement occurrence : occurrences) {
                    occurrence.replace(stringLiteral.copy());
                }
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(InlinePropertyHandler.REFACTORING_ID, null);
            }
        }.execute();
    }
}

