/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract.closure;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterSettings;

public abstract class ExtractClosureProcessorBase
extends BaseRefactoringProcessor {
    protected final GrIntroduceParameterSettings myHelper;
    private static final String EXTRACT_CLOSURE = "Extract closure";

    public ExtractClosureProcessorBase(@NotNull GrIntroduceParameterSettings helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureProcessorBase", "<init>"));
        }
        super(helper.getProject());
        this.myHelper = helper;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{ExtractClosureProcessorBase.this.myHelper.getToSearchFor()};
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureProcessorBase$1", "getElements"));
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return ExtractClosureProcessorBase.EXTRACT_CLOSURE;
            }
        };
        if (usageViewDescriptorAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureProcessorBase", "createUsageViewDescriptor"));
        }
        return usageViewDescriptorAdapter;
    }

    protected String getCommandName() {
        return EXTRACT_CLOSURE;
    }

    @NotNull
    public static GrClosableBlock generateClosure(@NotNull GrIntroduceParameterSettings helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureProcessorBase", "generateClosure"));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ ");
        String[] params = ExtractUtil.getParameterString(helper, true);
        if (params.length > 0) {
            for (String p : params) {
                buffer.append(p);
            }
            buffer.append("->");
        }
        if (helper.getStatements().length > 1) {
            buffer.append('\n');
        }
        ExtractUtil.generateBody(helper, false, buffer, helper.isForceReturn());
        buffer.append(" }");
        GrClosableBlock grClosableBlock = GroovyPsiElementFactory.getInstance(helper.getProject()).createClosureFromText(buffer.toString(), helper.getToReplaceIn());
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureProcessorBase", "generateClosure"));
        }
        return grClosableBlock;
    }
}

