/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.Collections;
import java.util.List;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.InstanceModelAdapter;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.SingleTypeModelPromise;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceBackedModelCreator<T>
implements ModelCreator {
    private final ModelPromise promise;
    private final ModelRuleDescriptor descriptor;
    private final List<ModelReference<?>> inputs;
    private final ModelReference<T> reference;
    private final Factory<? extends T> factory;

    public static <T> ModelCreator of(ModelReference<T> reference, ModelRuleDescriptor sourceDescriptor, T instance) {
        return InstanceBackedModelCreator.of(reference, sourceDescriptor, Factories.constant(instance));
    }

    public static <T> ModelCreator of(ModelReference<T> reference, ModelRuleDescriptor sourceDescriptor, Factory<? extends T> factory) {
        return InstanceBackedModelCreator.of(reference, sourceDescriptor, Collections.<ModelReference<?>>emptyList(), factory);
    }

    public static <T> ModelCreator of(ModelReference<T> reference, ModelRuleDescriptor sourceDescriptor, List<ModelReference<?>> inputBindings, Factory<? extends T> factory) {
        return new InstanceBackedModelCreator<T>(reference, sourceDescriptor, inputBindings, factory);
    }

    private InstanceBackedModelCreator(ModelReference<T> reference, ModelRuleDescriptor descriptor, List<ModelReference<?>> inputs, Factory<? extends T> factory) {
        this.reference = reference;
        this.factory = factory;
        this.promise = new SingleTypeModelPromise(reference.getType());
        this.descriptor = descriptor;
        this.inputs = inputs;
    }

    @Override
    public ModelPath getPath() {
        return this.reference.getPath();
    }

    @Override
    public ModelPromise getPromise() {
        return this.promise;
    }

    @Override
    public ModelAdapter create(Inputs inputs) {
        return InstanceModelAdapter.of(this.reference.getType(), this.factory.create());
    }

    @Override
    public List<ModelReference<?>> getInputs() {
        return this.inputs;
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }
}

