/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.generic.TemplateVariable;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageTemplateVariablesDialog
extends DialogWrapper {
    private final TemplateVariablesTable myTemplateVariableTable;

    protected ManageTemplateVariablesDialog(@NotNull Component parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/tasks/generic/ManageTemplateVariablesDialog", "<init>"));
        }
        super(parent, true);
        this.myTemplateVariableTable = new TemplateVariablesTable();
        this.setTitle("Template Variables");
        this.init();
    }

    public void setTemplateVariables(List<TemplateVariable> list) {
        this.myTemplateVariableTable.setValues(list);
    }

    public List<TemplateVariable> getTemplateVariables() {
        return this.myTemplateVariableTable.getTemplateVariables();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myTemplateVariableTable.getComponent();
    }

    private static class TemplateVariablesTable
    extends ListTableWithButtons<TemplateVariable> {
        private TemplateVariablesTable() {
        }

        protected ListTableModel createListModel() {
            ListTableWithButtons.ElementsColumnInfoBase<TemplateVariable> name = new ListTableWithButtons.ElementsColumnInfoBase<TemplateVariable>("Name"){

                @Nullable
                protected String getDescription(TemplateVariable templateVariable) {
                    return templateVariable.getDescription();
                }

                @Nullable
                public String valueOf(TemplateVariable templateVariable) {
                    return templateVariable.getName();
                }

                public boolean isCellEditable(TemplateVariable templateVariable) {
                    return !templateVariable.isReadOnly();
                }

                public void setValue(TemplateVariable templateVariable, String s) {
                    if (s.equals(this.valueOf(templateVariable))) {
                        return;
                    }
                    templateVariable.setName(s);
                    TemplateVariablesTable.this.setModified();
                }
            };
            ListTableWithButtons.ElementsColumnInfoBase<TemplateVariable> value = new ListTableWithButtons.ElementsColumnInfoBase<TemplateVariable>("Value"){

                @Nullable
                public String valueOf(TemplateVariable templateVariable) {
                    return templateVariable.getValue();
                }

                public boolean isCellEditable(TemplateVariable templateVariable) {
                    return !templateVariable.isReadOnly();
                }

                public void setValue(TemplateVariable templateVariable, String s) {
                    templateVariable.setValue(s);
                    TemplateVariablesTable.this.setModified();
                }

                public TableCellRenderer getRenderer(TemplateVariable variable) {
                    if (variable.isHidden()) {
                        return new TableCellRenderer(){

                            @Override
                            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                return new JPasswordField(value.toString());
                            }
                        };
                    }
                    return super.getRenderer((Object)variable);
                }

                @Nullable
                public TableCellEditor getEditor(final TemplateVariable variable) {
                    if (variable.isHidden()) {
                        return new AbstractTableCellEditor(){
                            private JPasswordField myPasswordField;

                            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                                this.myPasswordField = new JPasswordField(variable.getValue());
                                return this.myPasswordField;
                            }

                            public Object getCellEditorValue() {
                                return this.myPasswordField.getText();
                            }
                        };
                    }
                    return super.getEditor((Object)variable);
                }

                @Nullable
                protected String getDescription(TemplateVariable templateVariable) {
                    return templateVariable.getDescription();
                }
            };
            ColumnInfo<TemplateVariable, Boolean> isShownOnFirstTab = new ColumnInfo<TemplateVariable, Boolean>("Show on first tab"){

                @Nullable
                public Boolean valueOf(TemplateVariable o) {
                    return o.isShownOnFirstTab();
                }

                public void setValue(TemplateVariable variable, Boolean value) {
                    variable.setShownOnFirstTab(value);
                    TemplateVariablesTable.this.setModified();
                }

                public Class getColumnClass() {
                    return Boolean.class;
                }

                public boolean isCellEditable(TemplateVariable variable) {
                    return !variable.isReadOnly();
                }

                @Nullable
                public String getTooltipText() {
                    return "Whether this template variable will be shown in 'General tab'";
                }
            };
            ColumnInfo<TemplateVariable, Boolean> isHidden = new ColumnInfo<TemplateVariable, Boolean>("Hide"){

                @Nullable
                public Boolean valueOf(TemplateVariable o) {
                    return o.isHidden();
                }

                public void setValue(TemplateVariable variable, Boolean value) {
                    variable.setHidden(value);
                    TemplateVariablesTable.this.setModified();
                    TemplateVariablesTable.this.refreshValues();
                }

                public Class getColumnClass() {
                    return Boolean.class;
                }

                public boolean isCellEditable(TemplateVariable variable) {
                    return !variable.isReadOnly();
                }

                @Nullable
                public String getTooltipText() {
                    return "Whether this template variable will be hidden like password field";
                }
            };
            return new ListTableModel(new ColumnInfo[]{name, value, isShownOnFirstTab, isHidden});
        }

        protected TemplateVariable createElement() {
            return new TemplateVariable("", "");
        }

        protected boolean isEmpty(TemplateVariable element) {
            return StringUtil.isEmpty((String)element.getName()) && StringUtil.isEmpty((String)element.getValue());
        }

        protected TemplateVariable cloneElement(TemplateVariable variable) {
            return variable.clone();
        }

        protected boolean canDeleteElement(TemplateVariable selection) {
            return true;
        }

        public List<TemplateVariable> getTemplateVariables() {
            return this.getElements();
        }
    }
}

