/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdDisplayList;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.wizard.DynamicWizardStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import icons.AndroidIcons;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class AvdListDialog
extends DialogWrapper
implements AvdUiAction.AvdInfoProvider {
    private final Project myProject;
    private AvdDisplayList myAvdDisplayList;

    public AvdListDialog(@Nullable Project project) {
        super(project);
        this.myProject = project;
        this.myAvdDisplayList = new AvdDisplayList(this, project);
        this.myAvdDisplayList.setBorder(ourDefaultBorder);
        this.setTitle("AVD Manager");
        Window window = this.getWindow();
        if (window == null) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
        } else {
            window.setPreferredSize(WizardConstants.DEFAULT_WIZARD_WINDOW_SIZE);
        }
    }

    public void init() {
        super.init();
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return DynamicWizardStep.createWizardStepHeader(WizardConstants.ANDROID_NPW_HEADER_COLOR, AndroidIcons.Wizards.NewProjectMascotGreen, "Your Virtual Devices");
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myAvdDisplayList;
    }

    @Override
    @Nullable
    public AvdInfo getAvdInfo() {
        return null;
    }

    @Override
    public void refreshAvds() {
        this.myAvdDisplayList.refreshAvds();
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void notifyRun() {
        if (this.isShowing()) {
            this.close(1);
        }
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return null;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JComponent panel = super.createSouthPanel();
        if (panel != null) {
            panel.setBorder(ourDefaultBorder);
        }
        return panel;
    }

    @Nullable
    public AvdInfo getSelected() {
        return this.myAvdDisplayList.getAvdInfo();
    }
}

