/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.CloneDeviceAction;
import com.android.tools.idea.avdmanager.CreateDeviceAction;
import com.android.tools.idea.avdmanager.DeviceDefinitionList;
import com.android.tools.idea.avdmanager.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceUiAction;
import com.android.tools.idea.avdmanager.EditDeviceAction;
import com.android.tools.idea.wizard.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.WizardConstants;
import com.intellij.openapi.Disposable;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseDeviceDefinitionStep
extends DynamicWizardStepWithHeaderAndDescription
implements DeviceUiAction.DeviceProvider {
    private JPanel myPanel;
    private DeviceDefinitionList myDeviceDefinitionList;
    private DeviceDefinitionPreview myDeviceDefinitionPreview;
    private JButton myEditDeviceButton;
    private JPanel myEditButtonContainer;
    private final EditDeviceAction myEditDeviceAction;
    private final CreateDeviceAction myCreateDeviceAction;
    private final CloneDeviceAction myCloneDeviceAction;

    public ChooseDeviceDefinitionStep(@Nullable Disposable parentDisposable) {
        super("Select Hardware", "Choose a device definition", null, parentDisposable);
        this.$$$setupUI$$$();
        this.myEditDeviceAction = new EditDeviceAction(this, "Edit Device...");
        this.myCreateDeviceAction = new CreateDeviceAction(this, "Create Device...");
        this.myCloneDeviceAction = new CloneDeviceAction(this, "Clone Device...");
        this.setBodyComponent(this.myPanel);
        this.myDeviceDefinitionList.addSelectionListener(new DeviceDefinitionList.DeviceDefinitionSelectionListener(){

            @Override
            public void onDeviceSelectionChanged(@Nullable Device selectedDevice) {
                ChooseDeviceDefinitionStep.this.myDeviceDefinitionPreview.setDevice(selectedDevice);
                ChooseDeviceDefinitionStep.this.myState.put(AvdWizardConstants.DEVICE_DEFINITION_KEY, selectedDevice);
                ChooseDeviceDefinitionStep.this.updateEditButton(selectedDevice);
            }
        });
        this.myEditButtonContainer.setBackground(JBColor.background());
        this.myEditDeviceButton.setBackground(JBColor.background());
        this.myDeviceDefinitionList.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
        this.updateEditButton(null);
    }

    private void updateEditButton(@Nullable Device selectedDevice) {
        if (selectedDevice == null) {
            this.myEditDeviceButton.setAction(this.myCreateDeviceAction);
        } else if (DeviceManagerConnection.getDefaultDeviceManagerConnection().isUserDevice(selectedDevice)) {
            this.myEditDeviceButton.setAction(this.myEditDeviceAction);
        } else {
            this.myEditDeviceButton.setAction(this.myCloneDeviceAction);
        }
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        this.myDeviceDefinitionList.setSelectedDevice(this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY));
    }

    @Override
    public boolean validate() {
        return this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY) != null;
    }

    @Override
    public boolean isStepVisible() {
        Boolean isInEditMode = this.myState.get(AvdWizardConstants.IS_IN_EDIT_MODE_KEY);
        if (isInEditMode != null && isInEditMode.booleanValue()) {
            return this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY) == null;
        }
        return true;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Choose Device Definition Step" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ChooseDeviceDefinitionStep", "getStepName"));
        }
        return "Choose Device Definition Step";
    }

    @Override
    @Nullable
    public Device getDevice() {
        return this.myDeviceDefinitionList.getDevice();
    }

    @Override
    public void refreshDevices() {
        this.myDeviceDefinitionList.refreshDevices();
    }

    @Override
    @Nullable
    protected JBColor getTitleBackgroundColor() {
        return WizardConstants.ANDROID_NPW_HEADER_COLOR;
    }

    @Override
    @Nullable
    protected JBColor getTitleTextColor() {
        return WizardConstants.ANDROID_NPW_HEADER_TEXT_COLOR;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        DeviceDefinitionPreview deviceDefinitionPreview;
        DeviceDefinitionList deviceDefinitionList;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        this.myDeviceDefinitionList = deviceDefinitionList = new DeviceDefinitionList();
        jPanel2.add((Component)deviceDefinitionList, new GridConstraints(0, 0, 2, 1, 0, 3, 7, 3, null, new Dimension(-1, 1), null));
        this.myDeviceDefinitionPreview = deviceDefinitionPreview = new DeviceDefinitionPreview();
        jPanel2.add((Component)deviceDefinitionPreview, new GridConstraints(0, 1, 1, 1, 4, 2, 0, 3, null, new Dimension(360, -1), new Dimension(360, -1)));
        this.myEditButtonContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 2, 1, 3, 1, null, null, null));
        this.myEditDeviceButton = jButton = new JButton();
        jButton.setText("Edit Device");
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

