/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.stats.Distribution;
import com.android.tools.idea.stats.DistributionService;
import com.google.common.base.CharMatcher;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemImagePreview
extends JPanel {
    private static final Logger LOG = Logger.getInstance(SystemImagePreview.class);
    private static final String NO_SYSTEM_IMAGE_SELECTED = "No System Image Selected";
    private static final int FIGURE_PADDING = 3;
    private AvdWizardConstants.SystemImageDescription myImageDescription;
    private Distribution myDistribution;
    private static final int PADDING = 20;
    private static HaxmState ourHaxmState = HaxmState.NOT_INITIALIZED;

    public SystemImagePreview() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int standardFontHeight = SystemImagePreview.this.getGraphics().getFontMetrics(AvdWizardConstants.STANDARD_FONT).getHeight();
                if (SystemImagePreview.this.myDistribution != null && mouseEvent.getY() > SystemImagePreview.this.getHeight() - 20 - standardFontHeight) {
                    try {
                        Desktop.getDesktop().browse(new URI(SystemImagePreview.this.myDistribution.getUrl()));
                    }
                    catch (URISyntaxException e) {
                        LOG.error("Syntax exception in url for distribution " + SystemImagePreview.this.myDistribution.getVersion().toShortString());
                    }
                    catch (IOException e) {
                        LOG.error("IOException trying to open url " + SystemImagePreview.this.myDistribution.getUrl());
                    }
                }
            }
        });
    }

    public void setImage(@Nullable AvdWizardConstants.SystemImageDescription image) {
        if (image == null || !image.isRemote()) {
            this.myImageDescription = image;
        }
        if (image != null && !image.isRemote()) {
            this.myDistribution = DistributionService.getInstance().getDistributionForApiLevel(image.getVersion().getApiLevel());
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        HaxmState haxmState;
        Icon icon;
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(JBColor.background());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(JBColor.foreground());
        g2d.setFont(AvdWizardConstants.STANDARD_FONT);
        if (this.myImageDescription == null) {
            FontMetrics metrics = g2d.getFontMetrics();
            g2d.drawString(NO_SYSTEM_IMAGE_SELECTED, (this.getWidth() - metrics.stringWidth(NO_SYSTEM_IMAGE_SELECTED)) / 2, (this.getHeight() - metrics.getHeight()) / 2);
            return;
        }
        g2d.setFont(AvdWizardConstants.TITLE_FONT);
        FontMetrics metrics = g.getFontMetrics(AvdWizardConstants.TITLE_FONT);
        String codeName = SystemImagePreview.getCodeName(this.myImageDescription);
        if (codeName != null) {
            g2d.drawString(codeName, 20, 20 + metrics.getHeight() / 2);
            g2d.drawLine(0, 50, this.getWidth(), 50);
        }
        if ((icon = SystemImagePreview.getIcon(codeName)) != null) {
            icon.paintIcon(this, g, 3, 70);
        }
        int stringHeight = g2d.getFontMetrics(AvdWizardConstants.TITLE_FONT).getHeight();
        int figureHeight = g2d.getFontMetrics(AvdWizardConstants.FIGURE_FONT).getHeight();
        int infoSegmentX = 151;
        int infoSegmentY = 95;
        g2d.setFont(AvdWizardConstants.FIGURE_FONT);
        g2d.drawString("API Level", infoSegmentX, infoSegmentY += figureHeight);
        g2d.setFont(AvdWizardConstants.TITLE_FONT);
        g2d.drawString(this.myImageDescription.getVersion().getApiString(), infoSegmentX, infoSegmentY += stringHeight);
        infoSegmentY += 20;
        g2d.setFont(AvdWizardConstants.FIGURE_FONT);
        g2d.drawString("Android", infoSegmentX, infoSegmentY += figureHeight);
        g2d.setFont(AvdWizardConstants.TITLE_FONT);
        g2d.drawString(this.myImageDescription.getVersionName(), infoSegmentX, infoSegmentY += stringHeight);
        String tag = this.myImageDescription.getTag().getId();
        String vendorName = tag.equals("android-wear") || tag.equals("android-tv") ? "Android" : this.myImageDescription.getVendor();
        if (metrics.stringWidth(vendorName) > 128) {
            Iterable parts = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().split((CharSequence)vendorName);
            String currentLine = "";
            for (String part : parts) {
                if (metrics.stringWidth(currentLine) >= 128) {
                    g2d.drawString(currentLine, infoSegmentX, infoSegmentY += stringHeight);
                    currentLine = "";
                }
                currentLine = currentLine + part + " ";
            }
            if (!currentLine.isEmpty()) {
                g2d.drawString(currentLine, infoSegmentX, infoSegmentY += stringHeight);
            }
        } else {
            g2d.drawString(vendorName, infoSegmentX, infoSegmentY += stringHeight);
        }
        infoSegmentY += 20;
        g2d.setFont(AvdWizardConstants.FIGURE_FONT);
        g2d.drawString("System Image", infoSegmentX, infoSegmentY += figureHeight);
        g2d.setFont(AvdWizardConstants.TITLE_FONT);
        g2d.drawString(this.myImageDescription.getAbiType(), infoSegmentX, infoSegmentY += stringHeight);
        if (this.myImageDescription.getVersion().getApiLevel() < 8) {
            g2d.setFont(AvdWizardConstants.TITLE_FONT);
            g2d.drawString("This API Level is Deprecated", 20, infoSegmentY += stringHeight * 2);
        }
        if ((haxmState = SystemImagePreview.getHaxmState(false)) == HaxmState.NOT_INSTALLED && !this.myImageDescription.getAbiType().startsWith(Abi.X86.toString())) {
            g2d.setFont(AvdWizardConstants.TITLE_FONT);
            g2d.setColor((Color)JBColor.RED);
            g2d.drawString("Consider using a x86 System Image", 20, infoSegmentY += stringHeight * 2);
            g2d.drawString("for better emulation speed", 20, infoSegmentY += stringHeight);
        } else if (haxmState == HaxmState.NOT_LATEST) {
            g2d.setColor((Color)JBColor.RED);
            g2d.setFont(AvdWizardConstants.TITLE_FONT);
            g2d.drawString("Newer HAXM Version Available", 20, infoSegmentY += stringHeight * 2);
            g2d.drawString("(Use SDK Manager)", 20, infoSegmentY += stringHeight);
        }
        if (this.myDistribution != null) {
            g2d.setFont(AvdWizardConstants.STANDARD_FONT);
            g2d.setColor((Color)JBColor.BLUE);
            g2d.drawString("? - See documentation for Android " + this.myDistribution.getVersion().toShortString() + " APIs", 20, this.getHeight() - 20);
        }
    }

    @Nullable
    public static String getCodeName(@NotNull AvdWizardConstants.SystemImageDescription description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/avdmanager/SystemImagePreview", "getCodeName"));
        }
        return SdkVersionInfo.getCodeName((int)description.getVersion().getApiLevel());
    }

    @Nullable
    public static Icon getIcon(@Nullable String codename) {
        if (codename == null) {
            return null;
        }
        Icon icon = null;
        try {
            icon = IconLoader.findIcon((String)String.format("/icons/versions/%1$s.png", codename), AndroidIcons.class);
        }
        catch (RuntimeException ignored) {
            // empty catch block
        }
        if (icon != null) {
            return icon;
        }
        int size = 128;
        BufferedImage image = UIUtil.createImage((int)size, (int)size, (int)2);
        Graphics g = ((Image)image).getGraphics();
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        Font f = UIUtil.getLabelFont();
        Font font = new Font(f.getName(), f.getStyle() | 1, 100);
        g.setColor(JBColor.background());
        g.fillRect(0, 0, size, size);
        g.setColor(JBColor.foreground());
        g.setFont(font);
        int height = g.getFontMetrics().getHeight();
        int width = g.getFontMetrics().stringWidth("?");
        g.drawString("?", (size - width) / 2, height + (size - height) / 2);
        return new ImageIcon(image);
    }

    private static HaxmState getHaxmState(boolean forceRefresh) {
        if (ourHaxmState == HaxmState.NOT_INITIALIZED || forceRefresh) {
            ourHaxmState = SystemImagePreview.computeHaxmState();
        }
        return ourHaxmState;
    }

    private static HaxmState computeHaxmState() {
        try {
            if (SystemInfo.isMac) {
                Pattern pattern;
                Matcher matcher;
                String output = ExecUtil.execAndReadLine((String[])new String[]{"/usr/sbin/kextstat", "-l", "-b", "com.intel.kext.intelhaxm"});
                if (output != null && !output.isEmpty() && (matcher = (pattern = Pattern.compile("com\\.intel\\.kext\\.intelhaxm( \\((.+)\\))?")).matcher(output)).find()) {
                    if (matcher.groupCount() >= 2) {
                        String version = matcher.group(2);
                        try {
                            FullRevision revision = FullRevision.parseRevision((String)version);
                            FullRevision current = new FullRevision(1, 1, 1);
                            if (revision.compareTo(current) < 0) {
                                return HaxmState.NOT_LATEST;
                            }
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    return HaxmState.INSTALLED;
                }
                return HaxmState.NOT_INSTALLED;
            }
            if (SystemInfo.isWindows) {
                ProcessOutput processOutput = ExecUtil.execAndGetOutput((List)ImmutableList.of((Object)"sc", (Object)"query", (Object)"intelhaxm"), null);
                return Iterables.all((Iterable)processOutput.getStdoutLines(), (Predicate)new Predicate<String>(){

                    public boolean apply(String input) {
                        return input == null || !input.contains("does not exist");
                    }
                }) ? HaxmState.INSTALLED : HaxmState.NOT_INSTALLED;
            }
            if (SystemInfo.isUnix) {
                ProcessOutput processOutput = ExecUtil.execAndGetOutput((List)ImmutableList.of((Object)"kvm-ok"), null);
                return Iterables.any((Iterable)processOutput.getStdoutLines(), (Predicate)new Predicate<String>(){

                    public boolean apply(String input) {
                        return input != null && input.contains("KVM acceleration can be used");
                    }
                }) ? HaxmState.INSTALLED : HaxmState.NOT_INSTALLED;
            }
            assert (!SystemInfo.isLinux);
            return HaxmState.NOT_INSTALLED;
        }
        catch (ExecutionException e) {
            return HaxmState.NOT_INSTALLED;
        }
    }

    static enum HaxmState {
        NOT_INITIALIZED,
        INSTALLED,
        NOT_INSTALLED,
        NOT_LATEST;

    }
}

