/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.tools.idea.editors.navigation.Utilities;
import com.android.tools.idea.editors.navigation.macros.Macros;
import com.android.tools.idea.editors.navigation.macros.MultiMatch;
import com.android.tools.idea.editors.navigation.model.ActivityState;
import com.android.tools.idea.editors.navigation.model.Listener;
import com.android.tools.idea.editors.navigation.model.MenuState;
import com.android.tools.idea.editors.navigation.model.NavigationModel;
import com.android.tools.idea.editors.navigation.model.State;
import com.android.tools.idea.editors.navigation.model.Transition;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import org.jetbrains.annotations.NotNull;

public class CodeGenerator {
    private static final String[] FRAMEWORK_IMPORTS = new String[]{"android.app.Activity", "android.content.Intent", "android.os.Bundle"};
    public static final String TRANSITION_ADDED = "Transition added";
    public final Module module;
    public final NavigationModel navigationModel;
    public final Listener<String> listener;

    public CodeGenerator(NavigationModel navigationModel, Module module, Listener<String> listener) {
        this.navigationModel = navigationModel;
        this.module = module;
        this.listener = listener;
    }

    private ActivityState getAssociatedActivityState(MenuState menuState) {
        for (Transition t : this.navigationModel.getTransitions()) {
            State state;
            if (t.getDestination().getState() != menuState || !((state = t.getSource().getState()) instanceof ActivityState)) continue;
            return (ActivityState)state;
        }
        assert (false);
        return null;
    }

    private void addImports(ImportHelper importHelper, PsiJavaFile file, String[] classNames) {
        for (String className : classNames) {
            PsiClass psiClass = Utilities.getPsiClass(this.module, className);
            if (psiClass == null) continue;
            importHelper.addImport(file, psiClass);
        }
    }

    private void addImportsAsNecessary(PsiClass psiClass, String ... classNames) {
        PsiJavaFile file = (PsiJavaFile)psiClass.getContainingFile();
        ImportHelper importHelper = new ImportHelper(CodeStyleSettingsManager.getSettings((Project)this.module.getProject()));
        this.addImports(importHelper, file, FRAMEWORK_IMPORTS);
        this.addImports(importHelper, file, classNames);
    }

    private void notifyListeners(PsiClass psiClass) {
        this.listener.notify(TRANSITION_ADDED);
    }

    public void implementTransition(final Transition transition) {
        PsiClass psiClass;
        ActivityState newActivity;
        Project project = this.module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        final PsiElementFactory factory = facade.getElementFactory();
        final CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        final Macros macros = Macros.getInstance(this.module.getProject());
        State sourceState = transition.getSource().getState();
        State destinationState = transition.getDestination().getState();
        if (sourceState instanceof MenuState && destinationState instanceof ActivityState) {
            MenuState menuState = (MenuState)sourceState;
            newActivity = (ActivityState)destinationState;
            final ActivityState originatingActivity = this.getAssociatedActivityState(menuState);
            final PsiClass psiClass2 = Utilities.getPsiClass(this.module, originatingActivity.getClassName());
            if (psiClass2 != null) {
                new WriteCommandAction<Void>(project, "Add navigation transition", new PsiFile[]{psiClass2.getContainingFile()}){

                    protected void run(@NotNull Result<Void> result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/editors/navigation/macros/CodeGenerator$1", "run"));
                        }
                        PsiMethod signature = factory.createMethodFromText("public boolean onPrepareOptionsMenu(Menu menu){ }", (PsiElement)psiClass2);
                        PsiMethod method = psiClass2.findMethodBySignature(signature, false);
                        if (method == null) {
                            method = factory.createMethodFromText("@Override public boolean onPrepareOptionsMenu(Menu menu){boolean result=super.onPrepareOptionsMenu(menu);return result;}", (PsiElement)psiClass2);
                            psiClass2.add((PsiElement)method);
                            method = psiClass2.findMethodBySignature(signature, false);
                            assert (method != null);
                        }
                        String parameterName = method.getParameterList().getParameters()[0].getName();
                        PsiCodeBlock body = method.getBody();
                        assert (body != null);
                        PsiStatement[] statements = body.getStatements();
                        PsiStatement lastStatement = statements[statements.length - 1];
                        MultiMatch macro = macros.installMenuItemOnGetMenuItemAndLaunchActivityMacro;
                        MultiMatch.Bindings<String> bindings = new MultiMatch.Bindings<String>();
                        bindings.put("$consume", "true");
                        bindings.put("$menuItem", "$menu", parameterName);
                        bindings.put("$menuItem", "$id", "R.id." + transition.getSource().getViewName());
                        bindings.put("$f", "context", originatingActivity.getClassName() + ".this");
                        bindings.put("$f", "activityClass", newActivity.getClassName() + ".class");
                        String newCode = macro.instantiate(bindings);
                        PsiStatement newStatement = factory.createStatementFromText(newCode + ";", (PsiElement)body);
                        body.addBefore((PsiElement)newStatement, (PsiElement)lastStatement);
                        CodeGenerator.this.addImportsAsNecessary(psiClass2, new String[]{"android.view.Menu", "android.view.MenuItem"});
                        codeStyleManager.reformat((PsiElement)method);
                        CodeGenerator.this.notifyListeners(psiClass2);
                    }
                }.execute();
            }
        }
        if (sourceState instanceof ActivityState && destinationState instanceof MenuState) {
            ActivityState activityState = (ActivityState)sourceState;
            final MenuState menuState = (MenuState)destinationState;
            psiClass = Utilities.getPsiClass(this.module, activityState.getClassName());
            if (psiClass != null) {
                new WriteCommandAction<Void>(project, "Add navigation transition", new PsiFile[]{psiClass.getContainingFile()}){

                    protected void run(@NotNull Result<Void> result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/editors/navigation/macros/CodeGenerator$2", "run"));
                        }
                        PsiMethod signature = factory.createMethodFromText("boolean onCreateOptionsMenu(Menu menu){}", (PsiElement)psiClass);
                        PsiMethod method = psiClass.findMethodBySignature(signature, false);
                        if (method == null) {
                            method = factory.createMethodFromText("@Override public boolean onCreateOptionsMenu(Menu menu) { return true;}", (PsiElement)psiClass);
                            psiClass.add((PsiElement)method);
                            method = psiClass.findMethodBySignature(signature, false);
                            assert (method != null);
                        }
                        String parameterName = method.getParameterList().getParameters()[0].getName();
                        PsiCodeBlock body = method.getBody();
                        assert (body != null);
                        PsiStatement[] statements = body.getStatements();
                        PsiStatement lastStatement = statements[statements.length - 1];
                        String newStatementText = "getMenuInflater().inflate(R.menu.$XmlResourceName, $parameterName);";
                        newStatementText = newStatementText.replace("$XmlResourceName", menuState.getXmlResourceName());
                        newStatementText = newStatementText.replace("$parameterName", parameterName);
                        PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)body);
                        body.addBefore((PsiElement)newStatement, (PsiElement)lastStatement);
                        CodeGenerator.this.addImportsAsNecessary(psiClass, new String[]{"android.view.Menu"});
                        codeStyleManager.reformat((PsiElement)method);
                        CodeGenerator.this.notifyListeners(psiClass);
                    }
                }.execute();
            }
        }
        if (sourceState instanceof ActivityState && destinationState instanceof ActivityState) {
            final ActivityState sourceActivityState = (ActivityState)sourceState;
            newActivity = (ActivityState)destinationState;
            psiClass = Utilities.getPsiClass(this.module, sourceActivityState.getClassName());
            if (psiClass != null) {
                new WriteCommandAction<Void>(project, "Add navigation transition", new PsiFile[]{psiClass.getContainingFile()}){

                    protected void run(@NotNull Result<Void> result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/editors/navigation/macros/CodeGenerator$3", "run"));
                        }
                        PsiMethod signature = factory.createMethodFromText("void onCreate(Bundle savedInstanceState){}", (PsiElement)psiClass);
                        PsiMethod method = psiClass.findMethodBySignature(signature, false);
                        if (method == null) {
                            method = factory.createMethodFromText("@Override public void onCreate(Bundle savedInstanceState) {super.onCreate(savedInstanceState);}", (PsiElement)psiClass);
                            psiClass.add((PsiElement)method);
                            method = psiClass.findMethodBySignature(signature, false);
                            assert (method != null);
                        }
                        PsiCodeBlock body = method.getBody();
                        assert (body != null);
                        PsiStatement[] statements = body.getStatements();
                        PsiStatement lastStatement = statements[statements.length - 1];
                        String newCode = "findViewById($id).setOnClickListener(new View.OnClickListener() {   @Override  public void onClick(View v) {    $context.startActivity(new Intent($context, $activityClass));  }})";
                        newCode = newCode.replaceAll("\\$id", "R.id." + transition.getSource().getViewName());
                        newCode = newCode.replaceAll("\\$context", sourceActivityState.getClassName() + ".this");
                        newCode = newCode.replaceAll("\\$activityClass", newActivity.getClassName() + ".class");
                        PsiStatement newStatement = factory.createStatementFromText(newCode + ";", (PsiElement)body);
                        body.addAfter((PsiElement)newStatement, (PsiElement)lastStatement);
                        CodeGenerator.this.addImportsAsNecessary(psiClass, new String[]{"android.view.View"});
                        codeStyleManager.reformat((PsiElement)method);
                        CodeGenerator.this.notifyListeners(psiClass);
                    }
                }.execute();
            }
        }
    }
}

