/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.ide.common.resources.configuration.RegionQualifier;
import com.android.tools.idea.rendering.FlagManager;
import com.google.common.base.Objects;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Locale {
    private static final RegionQualifier ANY_REGION = new RegionQualifier("__");
    private static final LanguageQualifier ANY_LANGUAGE = new LanguageQualifier("__");
    public static final Locale ANY = new Locale(ANY_LANGUAGE, ANY_REGION);
    @NotNull
    public final LanguageQualifier language;
    @NotNull
    public final RegionQualifier region;
    public static final Comparator<Locale> LANGUAGE_NAME_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String name2;
            LanguageQualifier language1 = locale1.language;
            LanguageQualifier language2 = locale2.language;
            if (language1 == ANY_LANGUAGE) {
                return language2 == ANY_LANGUAGE ? 0 : -1;
            }
            if (language2 == ANY_LANGUAGE) {
                return 1;
            }
            String name1 = LocaleManager.getLanguageName((String)language1.getValue());
            int compare = StringUtil.compare((String)name1, (String)(name2 = LocaleManager.getLanguageName((String)language2.getValue())), (boolean)false);
            if (compare == 0) {
                return REGION_NAME_COMPARATOR.compare(locale1, locale2);
            }
            return compare;
        }
    };
    public static final Comparator<Locale> LANGUAGE_CODE_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String code2;
            LanguageQualifier language1 = locale1.language;
            LanguageQualifier language2 = locale2.language;
            if (language1 == ANY_LANGUAGE) {
                return language2 == ANY_LANGUAGE ? 0 : -1;
            }
            if (language2 == ANY_LANGUAGE) {
                return 1;
            }
            String code1 = language1.getValue();
            int compare = StringUtil.compare((String)code1, (String)(code2 = language2.getValue()), (boolean)false);
            if (compare == 0) {
                return REGION_CODE_COMPARATOR.compare(locale1, locale2);
            }
            return compare;
        }
    };
    public static final Comparator<Locale> REGION_NAME_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            RegionQualifier region1 = locale1.region;
            RegionQualifier region2 = locale2.region;
            if (region1 == ANY_REGION) {
                return region2 == ANY_REGION ? 0 : -1;
            }
            if (region2 == ANY_REGION) {
                return 1;
            }
            String language1 = LocaleManager.getRegionName((String)region1.getValue());
            String language2 = LocaleManager.getRegionName((String)region2.getValue());
            return StringUtil.compare((String)language1, (String)language2, (boolean)false);
        }
    };
    public static final Comparator<Locale> REGION_CODE_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            RegionQualifier region1 = locale1.region;
            RegionQualifier region2 = locale2.region;
            if (region1 == ANY_REGION) {
                return region2 == ANY_REGION ? 0 : -1;
            }
            if (region2 == ANY_REGION) {
                return 1;
            }
            String code1 = region1.getValue();
            String code2 = region2.getValue();
            return StringUtil.compare((String)code1, (String)code2, (boolean)false);
        }
    };

    private Locale(@NotNull LanguageQualifier language, @NotNull RegionQualifier region) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/android/tools/idea/rendering/Locale", "<init>"));
        }
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/android/tools/idea/rendering/Locale", "<init>"));
        }
        if (language.getValue().equals("__")) {
            language = ANY_LANGUAGE;
        }
        if (region.getValue().equals("__")) {
            region = ANY_REGION;
        }
        this.language = language;
        this.region = region;
    }

    @NotNull
    public static Locale create(@NotNull LanguageQualifier language, @Nullable RegionQualifier region) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/android/tools/idea/rendering/Locale", "create"));
        }
        Locale locale = new Locale(language, region != null ? region : ANY_REGION);
        if (locale == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/Locale", "create"));
        }
        return locale;
    }

    @NotNull
    public static Locale create(@NotNull LanguageQualifier language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/android/tools/idea/rendering/Locale", "create"));
        }
        Locale locale = new Locale(language, ANY_REGION);
        if (locale == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/Locale", "create"));
        }
        return locale;
    }

    public static Locale create(FolderConfiguration folder) {
        LanguageQualifier language = folder.getLanguageQualifier();
        RegionQualifier region = folder.getRegionQualifier();
        if (language == null && region == null) {
            return ANY;
        }
        if (region == null) {
            return Locale.create(language);
        }
        assert (language != null);
        return Locale.create(language, region);
    }

    @NotNull
    public static Locale create(@NotNull String localeString) {
        RegionQualifier region;
        LanguageQualifier language;
        if (localeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localeString", "com/android/tools/idea/rendering/Locale", "create"));
        }
        int index = localeString.indexOf(45);
        if (index != -1) {
            language = new LanguageQualifier(localeString.substring(0, index));
            assert (localeString.charAt(index + 1) == 'r') : localeString;
            region = new RegionQualifier(localeString.substring(index + 2));
        } else {
            assert (localeString.length() == 2) : localeString;
            assert (!localeString.equals("__"));
            language = new LanguageQualifier(localeString);
            region = ANY_REGION;
        }
        Locale locale = new Locale(language, region);
        if (locale == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/Locale", "create"));
        }
        return locale;
    }

    @NotNull
    public Icon getFlagImage() {
        String languageCode = this.hasLanguage() ? this.language.getValue() : null;
        String regionCode = this.hasRegion() ? this.region.getValue() : null;
        FlagManager icons = FlagManager.get();
        if (languageCode == null && regionCode == null) {
            Icon icon = AndroidIcons.Globe;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/Locale", "getFlagImage"));
            }
            return icon;
        }
        Icon image = icons.getFlag(languageCode, regionCode);
        if (image == null) {
            image = AndroidIcons.EmptyFlag;
        }
        Icon icon = image;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/Locale", "getFlagImage"));
        }
        return icon;
    }

    public boolean hasLanguage() {
        return this.language != ANY_LANGUAGE;
    }

    public boolean hasRegion() {
        return this.region != ANY_REGION;
    }

    public String toLocaleId() {
        return this.hasLanguage() && this.hasRegion() ? this.language.getValue() + "-" + this.region.getValue() : (this.hasLanguage() ? this.language.getValue() : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.language.hashCode();
        result = 31 * result + this.region.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Locale other = (Locale)obj;
        if (!this.language.equals((Object)other.language)) {
            return false;
        }
        return this.region.equals((Object)other.region);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().addValue((Object)this.language.getValue()).addValue((Object)this.region.getValue()).toString();
    }
}

