/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefreshQueue {
    public static RefreshQueue getInstance() {
        return ServiceManager.getService(RefreshQueue.class);
    }

    @NotNull
    public final RefreshSession createSession(boolean async, boolean recursive, @Nullable Runnable finishRunnable) {
        RefreshSession refreshSession = this.createSession(async, recursive, finishRunnable, this.getDefaultModalityState());
        if (refreshSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/RefreshQueue", "createSession"));
        }
        return refreshSession;
    }

    @NotNull
    public abstract RefreshSession createSession(boolean var1, boolean var2, @Nullable Runnable var3, @NotNull ModalityState var4);

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/newvfs/RefreshQueue", "refresh"));
        }
        this.refresh(async, recursive, finishRunnable, this.getDefaultModalityState(), files);
    }

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/newvfs/RefreshQueue", "refresh"));
        }
        this.refresh(async, recursive, finishRunnable, this.getDefaultModalityState(), files);
    }

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull ModalityState state, VirtualFile ... files) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/vfs/newvfs/RefreshQueue", "refresh"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/newvfs/RefreshQueue", "refresh"));
        }
        RefreshSession session = this.createSession(async, recursive, finishRunnable, state);
        session.addAllFiles(files);
        session.launch();
    }

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull ModalityState state, @NotNull Collection<VirtualFile> files) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/vfs/newvfs/RefreshQueue", "refresh"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/newvfs/RefreshQueue", "refresh"));
        }
        RefreshSession session = this.createSession(async, recursive, finishRunnable, state);
        session.addAllFiles(files);
        session.launch();
    }

    public abstract void processSingleEvent(@NotNull VFileEvent var1);

    public abstract void cancelSession(long var1);

    @NotNull
    protected ModalityState getDefaultModalityState() {
        ModalityState modalityState = ModalityState.NON_MODAL;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/RefreshQueue", "getDefaultModalityState"));
        }
        return modalityState;
    }
}

