/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.configuration.deployment;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentConfigurationManager {
    @NotNull
    public static DeploymentConfigurationManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/configuration/deployment/DeploymentConfigurationManager", "getInstance"));
        }
        DeploymentConfigurationManager deploymentConfigurationManager = ServiceManager.getService(project, DeploymentConfigurationManager.class);
        if (deploymentConfigurationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/configuration/deployment/DeploymentConfigurationManager", "getInstance"));
        }
        return deploymentConfigurationManager;
    }

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getDeploymentConfigurations(@NotNull ServerType<?> var1);

    public abstract void createAndRunConfiguration(@NotNull ServerType<?> var1, @Nullable RemoteServer<?> var2);
}

