/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.Matcher;
import java.awt.event.KeyEvent;

public class SpeedSearch {
    private String myString = "";
    private boolean myEnabled;
    private Matcher myMatcher;

    public void type(String letter) {
        this.updatePattern(this.myString + letter);
    }

    public void backspace() {
        if (this.myString.length() > 0) {
            this.updatePattern(this.myString.substring(0, this.myString.length() - 1));
        }
    }

    public boolean shouldBeShowing(String string) {
        return string == null || this.myString.length() == 0 || this.myMatcher != null && this.myMatcher.matches(string);
    }

    public void process(KeyEvent e) {
        String old = this.myString;
        if (e.isConsumed()) {
            return;
        }
        if (e.getKeyCode() == 8) {
            this.backspace();
            e.consume();
        } else if (e.getKeyCode() == 27) {
            if (this.isHoldingFilter()) {
                this.updatePattern("");
                e.consume();
            }
        } else {
            char ch = e.getKeyChar();
            if (Character.isLetterOrDigit(ch) || ch == ' ' || ch == '*' || ch == '_' || ch == '-' || ch == '\"' || ch == '\'' || ch == '/' || ch == '.') {
                this.type(Character.toString(ch));
                e.consume();
            }
        }
        if (!old.equalsIgnoreCase(this.myString)) {
            this.update();
        }
    }

    public void update() {
    }

    public void noHits() {
    }

    public boolean isHoldingFilter() {
        return this.myEnabled && this.myString.length() > 0;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void reset() {
        if (this.isHoldingFilter()) {
            this.updatePattern("");
        }
        if (this.myEnabled) {
            this.update();
        }
    }

    public String getFilter() {
        return this.myString;
    }

    public void updatePattern(String string) {
        this.myString = string;
        try {
            this.myMatcher = NameUtil.buildMatcher((String)("*" + string), (int)0, (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            this.myMatcher = null;
        }
    }
}

