/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class WCInfoWithBranches
extends WCInfo {
    private final List<Branch> myBranches;
    private final VirtualFile myRoot;
    private final String myTrunkRoot;

    public WCInfoWithBranches(@NotNull WCInfo info, List<Branch> branches, VirtualFile root, String trunkToot) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/dialogs/WCInfoWithBranches", "<init>"));
        }
        super(info.getRootInfo(), info.isIsWcRoot(), info.getStickyDepth());
        this.myBranches = branches;
        this.myRoot = root;
        this.myTrunkRoot = trunkToot;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public VirtualFile getVcsRoot() {
        return this.myRoot;
    }

    public List<Branch> getBranches() {
        return this.myBranches;
    }

    public VirtualFile getRoot() {
        return this.myRoot;
    }

    public String getTrunkRoot() {
        return this.myTrunkRoot;
    }

    public static class Branch {
        private final String myName;
        private final String myUrl;

        public Branch(String url) {
            this.myName = SVNPathUtil.tail((String)url);
            this.myUrl = url;
        }

        public String getName() {
            return this.myName;
        }

        public String getUrl() {
            return this.myUrl;
        }

        public String toString() {
            return this.myName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Branch branch = (Branch)o;
            return !(this.myUrl != null ? !this.myUrl.equals(branch.myUrl) : branch.myUrl != null);
        }

        public int hashCode() {
            return this.myUrl != null ? this.myUrl.hashCode() : 0;
        }
    }
}

